/*
 * Decompiled with CFR 0.152.
 */
package de.inovat.dua.pufferlzzsnachfordern;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientSenderInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.DataState;
import de.bsvrz.dav.daf.main.Dataset;
import de.bsvrz.dav.daf.main.OneSubscriptionPerSendData;
import de.bsvrz.dav.daf.main.ReceiveOptions;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.SendSubscriptionNotConfirmed;
import de.bsvrz.dav.daf.main.SenderRole;
import de.bsvrz.dav.daf.main.archive.ArchiveData;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKindCombination;
import de.bsvrz.dav.daf.main.archive.ArchiveDataQueryResult;
import de.bsvrz.dav.daf.main.archive.ArchiveDataSpecification;
import de.bsvrz.dav.daf.main.archive.ArchiveOrder;
import de.bsvrz.dav.daf.main.archive.ArchiveQueryPriority;
import de.bsvrz.dav.daf.main.archive.ArchiveRequestManager;
import de.bsvrz.dav.daf.main.archive.ArchiveRequestOption;
import de.bsvrz.dav.daf.main.archive.ArchiveTimeSpecification;
import de.bsvrz.dav.daf.main.archive.DatasetReceiverInterface;
import de.bsvrz.dav.daf.main.archive.HistoryTypeParameter;
import de.bsvrz.dav.daf.main.archive.TimingType;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.debug.Debug;
import de.inovat.dua.pufferlzzsnachfordern.Auftrag;
import de.inovat.dua.pufferlzzsnachfordern.AuftragsListe;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.Stream;

public class VewDeLve255
implements ClientSenderInterface,
DatasetReceiverInterface {
    private static final Debug debug = Debug.getLogger();
    private static final long EINE_MINUTE_IN_MILLISEKUNDEN = 60000L;
    private static final long EINE_STUNDE_IN_MILLISEKUNDEN = 3600000L;
    private static final long EIN_TAG_IN_MILLISEKUNDEN = 86400000L;
    private static final long ZEHN_MINUTEN_IN_MILLISEKUNDEN = 600000L;
    private static ArchiveRequestManager _archiv;
    private static Aspect _aspExterneErfassung;
    private static Aspect _aspTlsAbruf;
    private static AttributeGroup _atgFs;
    private static AttributeGroup _atgPufferAbrufLve;
    private static ClientDavInterface _dav;
    private static DataModel _konfiguration;
    private static int _datenNachforderungInTagen;
    private static int _minWarteZeitZwischenAbrufVersuchenInStunden;
    private static int _maxAnzahlAbrufVersuche;
    private final Set<Long> _setVorhandeneDatensaetze = new ConcurrentSkipListSet<Long>();
    private long _letzterIntervallBeginn;
    SystemObject _deLve255;
    Set<SystemObject> _mengeFs;

    public VewDeLve255(ClientDavInterface dav, SystemObject deLve255, Set<SystemObject> mengeFs, int datenNachforderungInTagen, int minWarteZeitZwischenAbrufVersuchenInStunden, int maxAnzahlAbrufVersuche) {
        _dav = dav;
        this._deLve255 = deLve255;
        this._mengeFs = mengeFs;
        _datenNachforderungInTagen = datenNachforderungInTagen;
        _minWarteZeitZwischenAbrufVersuchenInStunden = minWarteZeitZwischenAbrufVersuchenInStunden;
        _maxAnzahlAbrufVersuche = maxAnzahlAbrufVersuche;
        _konfiguration = _dav.getDataModel();
        _archiv = _dav.getArchive();
        _atgFs = _konfiguration.getAttributeGroup("atg.verkehrsDatenLangZeitIntervall");
        _aspExterneErfassung = _konfiguration.getAspect("asp.externeErfassung");
        _atgPufferAbrufLve = _konfiguration.getAttributeGroup("atg.tlsLveAbrufPufferInhalt");
        _aspTlsAbruf = _konfiguration.getAspect("asp.tlsAbruf");
        try {
            _dav.subscribeSender((ClientSenderInterface)this, this._deLve255, new DataDescription(_atgPufferAbrufLve, _aspTlsAbruf), SenderRole.sender());
        }
        catch (OneSubscriptionPerSendData e) {
            debug.warning(String.format("Doppelanmeldung f\u00fcr [%s] (anderer Sender vorhanden?). Pufferabruf wird f\u00fcr Objekt nicht weiter ber\u00fccksichtigt.", this._deLve255.getPid()), (Throwable)e);
        }
        DataDescription ddFS = new DataDescription(_atgFs, _aspExterneErfassung);
        long aktuelleZeit = System.currentTimeMillis();
        long vonZeitDatenNachforderung = this.ermittleIntervallBeginnAmTag(aktuelleZeit - (long)_datenNachforderungInTagen * 86400000L);
        for (SystemObject soFs : mengeFs) {
            ArchiveTimeSpecification timeSpec = new ArchiveTimeSpecification(TimingType.ARCHIVE_TIME, false, vonZeitDatenNachforderung, aktuelleZeit);
            ArchiveDataSpecification arsSpec = new ArchiveDataSpecification(timeSpec, ArchiveDataKindCombination.all(), ArchiveOrder.BY_INDEX, ArchiveRequestOption.NORMAL, ddFS, soFs);
            ArchiveDataQueryResult queryResult = _archiv.request(ArchiveQueryPriority.MEDIUM, arsSpec);
            try {
                if (queryResult.isRequestSuccessful()) {
                    Stream.of(queryResult.getStreams()).forEach(s -> {
                        try {
                            ArchiveData archiveData = s.take();
                            while (archiveData != null) {
                                if (DataState.DATA.equals(archiveData.getDataType())) {
                                    this.update(new Dataset[]{archiveData});
                                }
                                archiveData = s.take();
                            }
                        }
                        catch (IOException | IllegalStateException | InterruptedException e) {
                            debug.warning("Fehler beim Empfang von Archivdaten", (Throwable)e);
                        }
                    });
                }
            }
            catch (IllegalStateException | InterruptedException e) {
                debug.warning("Fehler beim Empfang von Archivdaten", (Throwable)e);
            }
            _archiv.subscribeReceiver((DatasetReceiverInterface)this, soFs, ddFS, ReceiveOptions.normal(), HistoryTypeParameter.TIME, aktuelleZeit - vonZeitDatenNachforderung);
        }
        long ausfuehrungsZeitPunkt = this.ermittleZeitpunktMinute(aktuelleZeit) + 600000L;
        int anzahlInialerAuftraege = 0;
        for (long intervallBeginn = vonZeitDatenNachforderung; intervallBeginn < aktuelleZeit - (long)_minWarteZeitZwischenAbrufVersuchenInStunden * 3600000L; intervallBeginn += 3600000L) {
            if (!this._setVorhandeneDatensaetze.contains(intervallBeginn)) {
                Auftrag auftrag = new Auftrag(ausfuehrungsZeitPunkt, intervallBeginn, intervallBeginn + 3600000L, 1, this);
                AuftragsListe.getInstanz().addAuftrag(auftrag);
                ++anzahlInialerAuftraege;
            }
            ausfuehrungsZeitPunkt += 60000L;
            this._letzterIntervallBeginn = intervallBeginn;
        }
        debug.info(String.format("Initial %d Auftr\u00e4ge f\u00fcr [%s] erstellt.", anzahlInialerAuftraege, this._deLve255.getPid()));
    }

    private void alteEintraegeLoeschen() {
        long aeltesterZeitpunkt = System.currentTimeMillis() - (long)_datenNachforderungInTagen * 86400000L - 86400000L;
        this._setVorhandeneDatensaetze.removeIf(zeitpunkt -> zeitpunkt < aeltesterZeitpunkt);
    }

    public void ausfuehren(Auftrag auftrag) {
        this.updateVorhandeneDatensaetze(auftrag);
        if (!this._setVorhandeneDatensaetze.contains(auftrag.getIntervallBeginn()) && auftrag.getAktAnzahlAbrufVersuche() < _maxAnzahlAbrufVersuche) {
            DataDescription datenBeschreibung = new DataDescription(_atgPufferAbrufLve, _aspTlsAbruf);
            Data datenPufferAbruf = _dav.createData(_atgPufferAbrufLve);
            datenPufferAbruf.getTimeValue("Zeitpunkt").setMillis(auftrag.getIntervallBeginn());
            datenPufferAbruf.getUnscaledValue("Anzahl").set(1);
            try {
                _dav.sendData(new ResultData(this._deLve255, datenBeschreibung, System.currentTimeMillis(), datenPufferAbruf, false));
            }
            catch (SendSubscriptionNotConfirmed e) {
                debug.warning(String.format("Sendeversuch f\u00fcr Pufferabfrage wegen fehlender Sendeanmeldung fehlgeschlagen: [%s]", datenBeschreibung), (Throwable)e);
            }
            long ausfuehrungsZeitPunkt = auftrag.getAusfuehrungsZeitPunkt() + (long)_minWarteZeitZwischenAbrufVersuchenInStunden * 3600000L;
            Auftrag folgeAuftrag = new Auftrag(ausfuehrungsZeitPunkt, auftrag.getIntervallBeginn(), auftrag.getIntervallEnde(), auftrag.getAktAnzahlAbrufVersuche() + 1, auftrag.getVewDeLve255());
            AuftragsListe.getInstanz().addAuftrag(folgeAuftrag);
            debug.info(String.format("Ausgef\u00fchrter Auftrag: %s%nNachfolge Auftrag   : %s", auftrag, folgeAuftrag));
        }
    }

    private void updateVorhandeneDatensaetze(Auftrag auftrag) {
        DataDescription ddFS = new DataDescription(_atgFs, _aspExterneErfassung);
        for (SystemObject soFs : this._mengeFs) {
            ArchiveTimeSpecification timeSpec = new ArchiveTimeSpecification(TimingType.ARCHIVE_TIME, false, auftrag.getIntervallBeginn(), auftrag.getIntervallEnde());
            ArchiveDataSpecification arsSpec = new ArchiveDataSpecification(timeSpec, ArchiveDataKindCombination.all(), ArchiveOrder.BY_INDEX, ArchiveRequestOption.NORMAL, ddFS, soFs);
            ArchiveDataQueryResult queryResult = _archiv.request(ArchiveQueryPriority.MEDIUM, arsSpec);
            try {
                if (!queryResult.isRequestSuccessful()) continue;
                Stream.of(queryResult.getStreams()).forEach(s -> {
                    try {
                        ArchiveData archiveData = s.take();
                        while (archiveData != null) {
                            if (DataState.DATA.equals(archiveData.getDataType())) {
                                this.update(new Dataset[]{archiveData});
                            }
                            archiveData = s.take();
                        }
                    }
                    catch (IOException | IllegalStateException | InterruptedException e) {
                        debug.warning("Fehler beim Empfang von Archivdaten", (Throwable)e);
                    }
                });
            }
            catch (IllegalStateException | InterruptedException e) {
                debug.warning("Fehler beim Empfang von Archivdaten", (Throwable)e);
            }
        }
    }

    @Deprecated(forRemoval=true)
    private String ausgabeVorhandeneDatenZeitPunkte() {
        SimpleDateFormat datumsFormatierer = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss,SSS");
        StringBuilder sb = new StringBuilder();
        sb.append(this).append(String.format(":%n", new Object[0]));
        for (long zeitpunkt : this._setVorhandeneDatensaetze) {
            sb.append(datumsFormatierer.format(new Date(zeitpunkt))).append(String.format("%n", new Object[0]));
        }
        return sb.toString();
    }

    public void dataRequest(SystemObject object, DataDescription dataDescription, byte state) {
    }

    private long ermittleIntervallBeginnAmTag(long zeitPunkt) {
        GregorianCalendar vonZeitPunkt = new GregorianCalendar();
        vonZeitPunkt.setTimeInMillis(zeitPunkt);
        vonZeitPunkt.set(14, 0);
        vonZeitPunkt.set(13, 0);
        vonZeitPunkt.set(12, 0);
        vonZeitPunkt.set(11, 0);
        return vonZeitPunkt.getTimeInMillis();
    }

    private long ermittleZeitpunktMinute(long zeitPunkt) {
        GregorianCalendar vonZeitPunkt = new GregorianCalendar();
        vonZeitPunkt.setTimeInMillis(zeitPunkt);
        vonZeitPunkt.set(14, 0);
        vonZeitPunkt.set(13, 0);
        return vonZeitPunkt.getTimeInMillis();
    }

    public long getLetzterIntervallBeginn() {
        return this._letzterIntervallBeginn;
    }

    public String getPid() {
        return this._deLve255.getPid();
    }

    public boolean isRequestSupported(SystemObject object, DataDescription dataDescription) {
        return false;
    }

    public void setLetzterIntervallBeginn(long letzterIntervallBeginn) {
        this._letzterIntervallBeginn = letzterIntervallBeginn;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (SystemObject so : this._mengeFs) {
            sb.append(so.getPid()).append("  ");
        }
        return sb.toString();
    }

    public void update(Dataset[] datasetResults) {
        for (Dataset ergebnisDaten : datasetResults) {
            this._setVorhandeneDatensaetze.add(ergebnisDaten.getDataTime());
        }
        this.alteEintraegeLoeschen();
    }
}

