# SWE de.inovat.dua.pufferlzzsnachfordern

## Übersicht

Die SWE `de.inovat.dua.pufferlzzsnachfordern` dient dazu, fehlende Langzeitdaten von BASt-Dauerzählstellen, die über TLS angeschlossen sind, zu ermitteln und ggf. per TLS-Pufferanfrage abzurufen, um so die Datenlücken im Archiv wieder zu vervollständigen.

Dazu wird für einen bestimmten, zurückliegenden Zeitbereich (Aufrufparameter `-datenNachforderungInTage`) für die zu überwachenden Langzeitzählstellen (Aufrufparameter `-listePids`) das Archiv auf fehlende Langzeitdaten (`typ.fahrStreifen`, `atg.verkehrsDatenLangZeitIntervall`, `asp.externeErfassung`) überprüft.  Für fehlende Stundenwerte wird dann mehrfach (Aufrufparameter `-maxAnzahlAbrufVersuche`) versucht, diese in bestimmten zeitlichen Abständen (Aufrufparameter `-minWarteZeitZwischenAbrufVersuchenInStunden`) per TLS-Pufferabruf von der Streckenstation abzurufen.


## StartStopp / Aufrufparameter

Nachfolgende Auszug aus einer `startStopp.json` Datei zeigt einen möglichen Aufruf der SWE. Die für die SWE spezifischen Aufrufparameter sind im Anschluss beschrieben.

```json

    {
      "applikation": "%java%",
      "aufrufParameter": [
        " -cp %lib%/de.inovat.dua.pufferlzzsnachfordern/de.inovat.dua.pufferlzzsnachfordern-runtime.jar",
        " %jvmArgs%",
        " -Xmx3000m",
        " de.inovat.dua.pufferlzzsnachfordern.PufferAbrufLzzsNachfordern",
        " -datenverteiler=%davHost1%:%davAppPort1%",
        " -benutzer=%benutzer%",
        " -authentifizierung=%authentifizierung%",
        " -erlaubeHmacAuthentifizierung=nein",
        " -verschluesselung=automatisch",
        " -zweiteVerbindung=ja",
        " -puffer=50000000:50000000:100000000",
        " -listePids=%listePidsLzzsGprsTdsQsg%",
        " -datenNachforderungInTagen=40",
        " -minWarteZeitZwischenAbrufVersuchenInStunden=12",
        " -maxAnzahlAbrufVersuche=10",
        " -debugOrdner=%debugBasisOrdner%/TlsPufferAbrufNachfordernLzzsTdsQsq",
        " -debugLevelStdErrText=%debugLevelStdErrText%",
        " -debugLevelFileText=%debugLevelFileText%",
        " -debugFileCount=%debugFileCount%"
      ],
      "inkarnationsTyp": "dav",
      "inkarnationsName": "TlsPufferAbrufNachfordernLzzsTdsQsg",
      "initialize": false,
      "mitInkarnationsName": true,
      "startArt": {
        "option": "manuell",
        "neuStart": true,
        "intervall": ""
      },
```

Die für die SWE spezifischen Aufrufparameter steuern das Verhalten wie folgt:

### `-listePids=%listePidsLzzsGprsTdsQsg%`

- Legt fest, für welche Langzeitzählstellen (Objekte vom Typ `typ.langZeitZählstelle` oder KB's)) das Nachfordern von Langzeitdaten durch einen TLS-Pufferabruf erfolgen soll.
- Default ist `-listePids=alle`. Es werden dann für alle LZZS die Daten nachgefordert. In diesem Fall sollten aber auch alle LZZS per TLS angebunden sein. 
- Alternativ kann auch eine Liste mit PID von LZZS oder Konfigurationsbereichen angegeben werden (Trennzeichen: `,` oder `;` oder `:`. Es werden dann nur für diese LZZS die Daten aus dem Puffer nachgefordert.
  - Beispiel: `-listePids=dz.altenberge-2.b54.4_700,dz.bad-berleburg.b480.13_200,dz.bi-hillegossen.b66.0_000`
  - Hinweis: Im vorliegenden Fall ist die Liste über das Makro `%listePidsLzzsGprsTdsQsg%` definiert worden
  
### `-datenNachforderungInTagen=40`

- Anzahl der Tage vor dem Start der SWE, für die fehlende Langzeitdaten per TLS-Pufferabfrage nachgefordert werden sollen.
- Default ist `-datenNachforderungInTagen=40`.
  - Beispiel: Wird die SWE am 29.10.2024 (Uhrzeit ist nicht relevant) mit dem Wert `-datenNachforderungInTagen=40` gestartet, werden fehlende Daten ab dem 19.09.2024 0:00 Uhr nachgefordert.

### `-minWarteZeitZwischenAbrufVersuchenInStunden=12`

- Zeit in Stunden zwischen zwei Abrufversuchen für einen fehlenden Stundenwert.
- Default ist `-minWarteZeitZwischenAbrufVersuchenInStunden=12`.
- Wenn ein oder mehrere Stundenwerte der Langzeitdaten fehlen, so war die Ursache i.d.R. ein Kommunikationsausfall zur Streckenstation. Da diese Ausfälle normalerweise Stunden oder auch Tage dauern, sollte der Zeitraum zwischen zwei Abfragen nicht zu kurz gewählt werden, da sonst u. U. die Nachfragen nicht erfolgreich sind (Station ist dann eventuell während der Nachfragen noch immer nicht erreichbar). 

### `-maxAnzahlAbrufVersuche=10`

- Legt fest, wie oft maximal versucht werden soll, einen fehlenden Datensatz (Stundenwert) nachzufordern.
- Default ist `-maxAnzahlAbrufVersuche=10`.
- Wird die SWE mit den Werten `-minWarteZeitZwischenAbrufVersuchenInStunden=12` und `-maxAnzahlAbrufVersuche=10` gestartet, wird 12h * 10 = 120h (5 Tage) lang versucht, eine Datenlücke nachzuforden. Damit werden dann auch längere Kommunikationsausfälle zu einer Streckenstation ausgeglichen.

## Speicherverbrauch

Ja nach Anzahl der LZZS, für die Daten nachgefordert werden sollen, benötigt die SWE entsprechend viel Heap-Memory (Java Parameter z. B. `-Xmx3000m`). Sollte die SWE nach dem Start mit einer "Out of Memory" Fehlermeldung abstürzen, muss der Wert für `-Xmx` erhöht werden.

## Disclaimer

Copyright (C) 2016-2024 inovat - Dipl.-Ing. H. C. Kniß

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.

Dieses Programm ist Freie Software: Sie können es unter den Bedingungen
der GNU General Public License, wie von der Free Software Foundation,
Version 3 der Lizenz oder (nach Ihrer Wahl) jeder neueren
veröffentlichten Version, weiterverbreiten und/oder modifizieren.

Dieses Programm wird in der Hoffnung, dass es nützlich sein wird, aber
OHNE JEDE GEWÄHRLEISTUNG, bereitgestellt; sogar ohne die implizite
Gewährleistung der MARKTFÄHIGKEIT oder EIGNUNG FÜR EINEN BESTIMMTEN ZWECK.
Siehe die GNU General Public License für weitere Details.

Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
Programm erhalten haben. Wenn nicht, siehe <http://www.gnu.org/licenses/>.

## Kontakt
                                                                             
inovat, Dipl.-Ing. H. C. Kniß                                                                     
An der Krautwiese 37                                                                                     
D-53783 Eitorf                                                                                       
+49 (0)2243 8464 193                                                                                 
info@inovat.de                                                                                        
www.inovat.de
