/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.rw.einstellungen;

import de.bsvrz.buv.rw.basislib.Rahmenwerk;
import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungLocation;
import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungOwnerType;
import de.bsvrz.buv.rw.basislib.einstellungen.SpeicherKey;
import de.bsvrz.buv.rw.basislib.urlasser.UrlasserInfo;
import de.bsvrz.buv.rw.rw.einstellungen.EinstellungenSpeichermanager;
import de.bsvrz.buv.rw.rw.einstellungen.EinstellungenXmlHandler;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientReceiverInterface;
import de.bsvrz.dav.daf.main.ClientSenderInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.OneSubscriptionPerSendData;
import de.bsvrz.dav.daf.main.ReceiveOptions;
import de.bsvrz.dav.daf.main.ReceiverRole;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.SendSubscriptionNotConfirmed;
import de.bsvrz.dav.daf.main.SenderRole;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.debug.Debug;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class DavConnector
implements ClientReceiverInterface,
ClientSenderInterface {
    private final AttributeGroup netzAtg;
    private final Aspect sollAsp;
    private final Aspect vorgabeAsp;
    private final AttributeGroup benutzerAtg;
    private final EinstellungenSpeichermanager speichermanager;
    private static final Debug LOGGER = Debug.getLogger();
    private static final String START_FRAME_EXPRESSION = "[\\s]*\\[START\\]";
    private static final String ENDE_FRAME_EXPRESSION = "\\[ENDE\\][\\s]*";
    private static final int MAX_LINE_LENGTH = 15000;
    private final ClientDavInterface dav;
    private final DataModel model;
    private final SystemObject oberflaechenObject;

    static String entpackeString(String string) {
        String result = string.trim();
        result = result.replaceAll(START_FRAME_EXPRESSION, "");
        result = result.replaceAll(ENDE_FRAME_EXPRESSION, "");
        return result;
    }

    DavConnector(EinstellungenSpeichermanager speichermanager, Rahmenwerk rahmenwerk) {
        if (!rahmenwerk.isOnline()) {
            throw new IllegalStateException("Es besteht keine Rahmenwerkverbindung");
        }
        this.speichermanager = speichermanager;
        this.dav = rahmenwerk.getDavVerbindung();
        this.model = this.dav.getDataModel();
        this.oberflaechenObject = rahmenwerk.getOberflaechenObject();
        this.netzAtg = this.model.getAttributeGroup("atg.globaleEinstellungenOberfl\u00e4cheNetzweit");
        this.benutzerAtg = this.model.getAttributeGroup("atg.benutzerEinstellungenOberfl\u00e4cheNetzweit");
        this.sollAsp = this.model.getAspect("asp.parameterSoll");
        this.vorgabeAsp = this.model.getAspect("asp.parameterVorgabe");
        this.dav.subscribeReceiver((ClientReceiverInterface)this, this.oberflaechenObject, new DataDescription(this.netzAtg, this.sollAsp), ReceiveOptions.normal(), ReceiverRole.receiver());
        this.dav.subscribeReceiver((ClientReceiverInterface)this, this.oberflaechenObject, new DataDescription(this.benutzerAtg, this.sollAsp), ReceiveOptions.normal(), ReceiverRole.receiver());
        try {
            this.dav.subscribeSender((ClientSenderInterface)this, this.oberflaechenObject, new DataDescription(this.netzAtg, this.vorgabeAsp), SenderRole.sender());
        }
        catch (OneSubscriptionPerSendData e) {
            e.printStackTrace();
        }
        try {
            this.dav.subscribeSender((ClientSenderInterface)this, this.oberflaechenObject, new DataDescription(this.benutzerAtg, this.vorgabeAsp), SenderRole.sender());
        }
        catch (OneSubscriptionPerSendData e) {
            e.printStackTrace();
        }
    }

    public void dataRequest(SystemObject arg0, DataDescription arg1, byte arg2) {
    }

    public void disconnect() {
    }

    public boolean isRequestSupported(SystemObject arg0, DataDescription arg1) {
        return false;
    }

    @Deprecated
    public synchronized void saveBenutzerEinstellungsSpeicher(String pid, String data, UrlasserInfo info) throws SendSubscriptionNotConfirmed {
        de.bsvrz.puk.param.lib.daten.UrlasserInfo urlasserInfo = new de.bsvrz.puk.param.lib.daten.UrlasserInfo(info.getBenutzer(), info.getPasswort(), info.getUrsache(), info.getVeranlasser());
        this.saveBenutzerEinstellungsSpeicher(pid, data, urlasserInfo);
    }

    public synchronized void saveBenutzerEinstellungsSpeicher(String pid, String data, de.bsvrz.puk.param.lib.daten.UrlasserInfo info) throws SendSubscriptionNotConfirmed {
        SystemObject benutzerToSave = this.model.getObject(pid);
        if (benutzerToSave == null) {
            LOGGER.error("Der Benutzer mit der PID: " + pid + " existiert nicht in der aktuellen Konfiguration!");
            return;
        }
        ResultData benutzerDaten = this.dav.getData(this.oberflaechenObject, new DataDescription(this.benutzerAtg, this.sollAsp), 0L);
        Data neueDaten = benutzerDaten != null && benutzerDaten.getData() != null ? benutzerDaten.getData().createModifiableCopy() : this.dav.createData(this.benutzerAtg);
        Data.Array benutzerArray = neueDaten.getArray("Benutzereinstellungen");
        int dataIdx = 0;
        while (dataIdx < benutzerArray.getLength()) {
            SystemObject benutzer = benutzerArray.getItem(dataIdx).getReferenceValue("benutzer").getSystemObject();
            if (benutzerToSave.equals(benutzer)) break;
            ++dataIdx;
        }
        if (dataIdx >= benutzerArray.getLength()) {
            benutzerArray.setLength(dataIdx + 1);
        }
        benutzerArray.getItem(dataIdx).getReferenceValue("benutzer").setSystemObject(benutzerToSave);
        int lines = data.length() / 15000 + 1;
        Data.TextArray textArray = benutzerArray.getItem(dataIdx).getTextArray("Voreinstellungen");
        textArray.setLength(lines);
        int line = 0;
        while (line < lines) {
            int start = line * 15000;
            int ende = Math.min((line + 1) * 15000, data.length());
            String substring = data.substring(start, ende);
            textArray.getTextValue(line).setText(substring);
            ++line;
        }
        if (info != null) {
            Data urlasserDaten = neueDaten.getItem("Urlasser");
            urlasserDaten.getReferenceValue("BenutzerReferenz").setSystemObject(info.getBenutzer());
            urlasserDaten.getTextValue("Ursache").setText(info.getUrsache());
            urlasserDaten.getTextValue("Veranlasser").setText(info.getVeranlasser());
        }
        ResultData resultData = new ResultData(this.oberflaechenObject, new DataDescription(this.benutzerAtg, this.vorgabeAsp), this.dav.getTime(), neueDaten);
        this.dav.sendData(resultData);
    }

    @Deprecated
    public synchronized void saveSystemEinstellungsSpeicher(String data, UrlasserInfo info) throws SendSubscriptionNotConfirmed {
        de.bsvrz.puk.param.lib.daten.UrlasserInfo urlasserInfo = new de.bsvrz.puk.param.lib.daten.UrlasserInfo(info.getBenutzer(), info.getPasswort(), info.getUrsache(), info.getVeranlasser());
        this.saveSystemEinstellungsSpeicher(data, urlasserInfo);
    }

    public synchronized void saveSystemEinstellungsSpeicher(String data, de.bsvrz.puk.param.lib.daten.UrlasserInfo info) throws SendSubscriptionNotConfirmed {
        Data neueDaten = this.dav.createData(this.netzAtg);
        Data.TextArray textArray = neueDaten.getItem("BenutzereinstellungenGlobal").getTextArray("Voreinstellungen");
        int lines = data.length() / 15000 + 1;
        textArray.setLength(lines);
        int line = 0;
        while (line < lines) {
            int start = line * 15000;
            int ende = Math.min((line + 1) * 15000, data.length());
            String substring = data.substring(start, ende);
            textArray.getTextValue(line).setText(substring);
            ++line;
        }
        if (info != null) {
            Data urlasserDaten = neueDaten.getItem("Urlasser");
            urlasserDaten.getReferenceValue("BenutzerReferenz").setSystemObject(info.getBenutzer());
            urlasserDaten.getTextValue("Ursache").setText(info.getUrsache());
            urlasserDaten.getTextValue("Veranlasser").setText(info.getVeranlasser());
        }
        ResultData resultData = new ResultData(this.oberflaechenObject, new DataDescription(this.netzAtg, this.vorgabeAsp), this.dav.getTime(), neueDaten);
        this.dav.sendData(resultData);
    }

    public void update(ResultData[] results) {
        ResultData[] resultDataArray = results;
        int n = results.length;
        int n2 = 0;
        while (n2 < n) {
            block21: {
                ResultData result = resultDataArray[n2];
                Data daten = result.getData();
                if (daten != null) {
                    SAXParser parser;
                    SAXParserFactory factory;
                    if (result.getDataDescription().getAttributeGroup().equals(this.netzAtg)) {
                        try {
                            factory = SAXParserFactory.newInstance();
                            parser = factory.newSAXParser();
                            StringBuilder strBuffer = new StringBuilder();
                            Data.TextArray textArray = daten.getItem("BenutzereinstellungenGlobal").getTextArray("Voreinstellungen");
                            Data.TextValue[] textValueArray = textArray.getTextValues();
                            int n3 = textValueArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                Data.TextValue textValue = textValueArray[n4];
                                strBuffer.append(textValue.getText());
                                ++n4;
                            }
                            if (strBuffer.length() == 0) {
                                LOGGER.fine("Es wurden keine globalen Benutzereinstellungen gefunden");
                                break block21;
                            }
                            parser.parse(new InputSource(new StringReader(strBuffer.toString())), (DefaultHandler)new EinstellungenXmlHandler(this.speichermanager, new SpeicherKey(EinstellungOwnerType.SYSTEM, EinstellungLocation.NETZWERKWEIT)));
                        }
                        catch (ParserConfigurationException e) {
                            LOGGER.error(e.getLocalizedMessage());
                        }
                        catch (SAXException e) {
                            LOGGER.error(e.getLocalizedMessage());
                        }
                        catch (IOException e) {
                            LOGGER.error(e.getLocalizedMessage());
                        }
                    } else if (result.getDataDescription().getAttributeGroup().equals(this.benutzerAtg)) {
                        try {
                            factory = SAXParserFactory.newInstance();
                            parser = factory.newSAXParser();
                            Data.Array benutzerArray = daten.getArray("Benutzereinstellungen");
                            int idx = 0;
                            while (idx < benutzerArray.getLength()) {
                                StringBuilder strBuffer = new StringBuilder();
                                SystemObject benutzer = benutzerArray.getItem(idx).getReferenceValue("benutzer").getSystemObject();
                                if (benutzer == null) {
                                    LOGGER.warning("Der Parameterdatensatz der Benutzereinstellungen enth\u00e4lt an Position " + idx + " keine g\u00fcltige Benutzerreferenz");
                                } else {
                                    Data.TextArray textArray = benutzerArray.getItem(idx).getTextArray("Voreinstellungen");
                                    Data.TextValue[] textValueArray = textArray.getTextValues();
                                    int n5 = textValueArray.length;
                                    int n6 = 0;
                                    while (n6 < n5) {
                                        Data.TextValue textValue = textValueArray[n6];
                                        strBuffer.append(textValue.getText());
                                        ++n6;
                                    }
                                    try {
                                        SpeicherKey key = new SpeicherKey(EinstellungOwnerType.BENUTZER, EinstellungLocation.NETZWERKWEIT, benutzer.getPid());
                                        parser.parse(new InputSource(new StringReader(strBuffer.toString())), (DefaultHandler)new EinstellungenXmlHandler(this.speichermanager, key));
                                    }
                                    catch (SAXException e) {
                                        LOGGER.error(e.getLocalizedMessage());
                                    }
                                    catch (IOException e) {
                                        LOGGER.error(e.getLocalizedMessage());
                                    }
                                }
                                ++idx;
                            }
                        }
                        catch (ParserConfigurationException e) {
                            LOGGER.error(e.getLocalizedMessage());
                        }
                        catch (SAXException e) {
                            LOGGER.error(e.getLocalizedMessage());
                        }
                    }
                }
            }
            ++n2;
        }
    }
}

