/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.rw.einstellungen;

import de.bsvrz.buv.rw.basislib.Rahmenwerk;
import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungAvailabilityListener;
import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungChangeListener;
import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungLocation;
import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungOwnerType;
import de.bsvrz.buv.rw.basislib.einstellungen.Einstellungen;
import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungsAdresse;
import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungsFactory;
import de.bsvrz.buv.rw.basislib.einstellungen.SpeicherKey;
import de.bsvrz.buv.rw.basislib.einstellungen.UrlasserDialogAbgebrochenException;
import de.bsvrz.buv.rw.basislib.urlasser.UrlasserInfoDatenDialog;
import de.bsvrz.buv.rw.basislib.urlasser.UrlasserInfoDatenSender;
import de.bsvrz.buv.rw.rw.einstellungen.EinstellungenSpeichermanager;
import de.bsvrz.buv.rw.rw.einstellungen.EinstellungsSpeicherException;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.puk.param.lib.daten.UrlasserInfo;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class EinstellungenImpl
implements Einstellungen {
    private static EinstellungenImpl instance;
    private EinstellungenSpeichermanager speicherManager;
    private final Map<String, EinstellungsFactory> factories = new HashMap<String, EinstellungsFactory>();

    protected void activate() {
        instance = this;
    }

    protected void deactivate() {
        instance = null;
    }

    public static EinstellungenImpl getInstance() {
        return instance;
    }

    protected void bindRahmenwerk(Rahmenwerk newRahmenwerk) {
        this.speicherManager = new EinstellungenSpeichermanager(this, newRahmenwerk);
    }

    protected void unbindRahmenwerk(Rahmenwerk oldRahmenwerk) {
        this.speicherManager = null;
    }

    protected void addEinstellungsFactory(EinstellungsFactory factory) {
        this.factories.put(factory.getTyp(), factory);
    }

    protected void removeEinstellungsFactory(EinstellungsFactory factory) {
        this.factories.remove(factory.getTyp());
    }

    public Object getValue(EinstellungsAdresse adresse) throws IOException {
        return this.speicherManager.getValue(adresse);
    }

    public void setValue(final EinstellungsAdresse adresse, final Object einstellung) throws IOException {
        try {
            if (adresse.getLocation() == EinstellungLocation.NETZWERKWEIT && adresse.getOwnerType() == EinstellungOwnerType.SYSTEM) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        UrlasserInfoDatenDialog dialog = new UrlasserInfoDatenDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), new UrlasserInfoDatenSender(){

                            public void execute(ClientDavInterface verbindung, UrlasserInfo urlasser) {
                                try {
                                    EinstellungenImpl.this.setValue(adresse, einstellung, urlasser);
                                }
                                catch (IOException e) {
                                    ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Fehler", (String)"Einstellung konnte nicht gespeichert werden", (IStatus)new Status(4, "de.bsvrz.buv.rw.rw.einstellungen", e.getLocalizedMessage(), (Throwable)e));
                                }
                            }
                        });
                        if (dialog.open() != 0) {
                            throw new CancelException();
                        }
                    }
                });
            } else {
                this.setValue(adresse, einstellung, null);
            }
        }
        catch (CancelException e) {
            throw new UrlasserDialogAbgebrochenException();
        }
    }

    public void setValue(EinstellungsAdresse adresse, Object einstellung, UrlasserInfo urlasser) throws IOException {
        UrlasserInfo info = urlasser;
        if (urlasser == null) {
            Rahmenwerk rahmenwerk = this.speicherManager.getRahmenwerk();
            info = rahmenwerk.isOnline() ? new UrlasserInfo(rahmenwerk.getBenutzer(), rahmenwerk.getPasswort(), "Einstellung f\u00fcr " + adresse.getId() + " aktualisiert", rahmenwerk.getBenutzerName()) : new UrlasserInfo(null, rahmenwerk.getPasswort(), "Einstellung f\u00fcr " + adresse.getId() + " aktualisiert", rahmenwerk.getBenutzerName());
        }
        try {
            this.speicherManager.setValue(adresse, einstellung, info);
        }
        catch (EinstellungsSpeicherException e) {
            throw new IOException(e);
        }
    }

    public void addEinstellungsListener(EinstellungChangeListener listener) {
        this.speicherManager.addChangeListener(listener, null);
    }

    public void addEinstellungsListener(EinstellungChangeListener listener, String category) {
        this.speicherManager.addChangeListener(listener, category);
    }

    public void removeEinstellungsListener(EinstellungChangeListener listener) {
        this.speicherManager.removeChangeListener(listener, null);
    }

    public void removeEinstellungsListener(EinstellungChangeListener listener, String category) {
        this.speicherManager.removeChangeListener(listener, category);
    }

    public void addEinstellungsAvailabilityListener(EinstellungAvailabilityListener listener) {
        this.speicherManager.addAvailabilityListener(listener);
    }

    public void removeEinstellungsAvailabilityListener(EinstellungAvailabilityListener listener) {
        this.speicherManager.removeAvailabilityListener(listener);
    }

    EinstellungsFactory getFactory(String typ) {
        return this.factories.get(typ);
    }

    public void removeValue(EinstellungsAdresse adresse) {
        try {
            this.setValue(adresse, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void removeValue(EinstellungsAdresse adresse, UrlasserInfo urlasser) {
        try {
            this.setValue(adresse, null, urlasser);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Map<String, String> getEinstellungsId(SpeicherKey key) throws IOException {
        return this.speicherManager.getEinstellungsId(key);
    }

    public static class CancelException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }
}

