/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.rw.einstellungen;

import de.bsvrz.buv.rw.basislib.Rahmenwerk;
import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsEvent;
import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsListener;
import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungAvailabilityListener;
import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungChangeListener;
import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungLocation;
import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungOwnerType;
import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungsAdresse;
import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungsFactory;
import de.bsvrz.buv.rw.basislib.einstellungen.SpeicherKey;
import de.bsvrz.buv.rw.rw.einstellungen.DavConnector;
import de.bsvrz.buv.rw.rw.einstellungen.EinstellungenImpl;
import de.bsvrz.buv.rw.rw.einstellungen.EinstellungenXmlHandler;
import de.bsvrz.buv.rw.rw.einstellungen.EinstellungsListenerManager;
import de.bsvrz.buv.rw.rw.einstellungen.EinstellungsSpeicher;
import de.bsvrz.buv.rw.rw.einstellungen.EinstellungsSpeicherException;
import de.bsvrz.buv.rw.rw.einstellungen.LokalSpeicher;
import de.bsvrz.buv.rw.rw.einstellungen.RwEinstellungenActivator;
import de.bsvrz.buv.rw.rw.einstellungen.SpeicherErgebnis;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.puk.param.lib.daten.UrlasserInfo;
import de.bsvrz.sys.funclib.debug.Debug;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EinstellungenSpeichermanager {
    private final EinstellungsListenerManager listenerManager = new EinstellungsListenerManager();
    private final Map<SpeicherKey, EinstellungsSpeicher> speicherVerwaltung = new HashMap<SpeicherKey, EinstellungsSpeicher>();
    private final Object connectMutex = new Object();
    private final Object saveMutex = new Object();
    private boolean verbunden;
    private Rahmenwerk rahmenwerk;
    private EinstellungenImpl einstellungen;
    private DavConnector davConnector;
    private static final Debug LOGGER = Debug.getLogger();

    public EinstellungenSpeichermanager(EinstellungenImpl einstellungen, Rahmenwerk rahmenwerk) {
        this.einstellungen = einstellungen;
        this.rahmenwerk = rahmenwerk;
        this.rahmenwerk.addDavVerbindungsListener(new DavVerbindungsListener(){

            public void verbindungGetrennt(DavVerbindungsEvent event) {
                EinstellungenSpeichermanager.this.disconnect();
            }

            public boolean verbindungHalten(DavVerbindungsEvent event) {
                return false;
            }

            public void verbindungHergestellt(DavVerbindungsEvent event) {
                EinstellungenSpeichermanager.this.connect(event.getDavVerbindung());
            }
        });
        this.connect(rahmenwerk.getDavVerbindung());
        this.intialisiereLokalenSpeicher();
    }

    public void addAvailabilityListener(EinstellungAvailabilityListener listener) {
        this.listenerManager.add(listener);
    }

    public void addChangeListener(EinstellungChangeListener listener, String category) {
        this.listenerManager.add(listener, category);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connect(ClientDavInterface davVerbindung) {
        if (davVerbindung != null) {
            Object object = this.connectMutex;
            synchronized (object) {
                if (!this.verbunden) {
                    this.verbunden = true;
                    this.davConnector = new DavConnector(this, this.rahmenwerk);
                    this.initialisiereLokalenBenutzerSpeicher(this.rahmenwerk.getBenutzer());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnect() {
        Object object = this.connectMutex;
        synchronized (object) {
            if (this.verbunden) {
                Map<SpeicherKey, EinstellungsSpeicher> map = this.speicherVerwaltung;
                synchronized (map) {
                    HashSet<SpeicherKey> keySet = new HashSet<SpeicherKey>(this.speicherVerwaltung.keySet());
                    for (SpeicherKey key : keySet) {
                        if (!key.isLocal() || key.getOwnerType() == EinstellungOwnerType.SYSTEM) continue;
                        this.speicherVerwaltung.remove(key);
                    }
                }
                this.verbunden = false;
                this.listenerManager.fireAvailability(false);
            }
        }
    }

    public DavConnector getDavConnector() {
        return this.davConnector;
    }

    public Rahmenwerk getRahmenwerk() {
        return this.rahmenwerk;
    }

    public Object getValue(EinstellungsAdresse adresse) throws IOException {
        SpeicherKey key = new SpeicherKey(adresse);
        EinstellungsSpeicher speicher = this.speicherVerwaltung.get(key);
        if (speicher == null) {
            return null;
        }
        return speicher.getValue(adresse);
    }

    public Map<String, String> getEinstellungsId(SpeicherKey key) {
        EinstellungsSpeicher speicher = this.speicherVerwaltung.get(key);
        if (speicher == null) {
            return Collections.emptyMap();
        }
        return speicher.getEinstellungsId();
    }

    private void initialisiereLokalenBenutzerSpeicher(SystemObject benutzer) {
        IPreferenceStore preferenceStore;
        String einstellungsDaten;
        if (benutzer == null) {
            return;
        }
        if (this.rahmenwerk.isOnline() && !(einstellungsDaten = (preferenceStore = RwEinstellungenActivator.getDefault().getPreferenceStore()).getString(LokalSpeicher.getPreferenceKey(benutzer.getPid()))).isEmpty()) {
            this.parseLokaleEinstellungsdaten(einstellungsDaten, new SpeicherKey(EinstellungOwnerType.BENUTZER, EinstellungLocation.LOKAL, benutzer.getPid()));
        }
    }

    private void intialisiereLokalenSpeicher() {
        IPreferenceStore preferenceStore = RwEinstellungenActivator.getDefault().getPreferenceStore();
        String einstellungsDaten = preferenceStore.getString(LokalSpeicher.getPreferenceKey(null));
        SpeicherKey key = new SpeicherKey(EinstellungOwnerType.SYSTEM, EinstellungLocation.LOKAL);
        EinstellungsSpeicher speicher = EinstellungsSpeicher.createSpeicher(key, this);
        this.speicherVerwaltung.put(key, speicher);
        if (!einstellungsDaten.isEmpty()) {
            this.parseLokaleEinstellungsdaten(einstellungsDaten, key);
        }
        if (this.rahmenwerk.isOnline()) {
            this.initialisiereLokalenBenutzerSpeicher(this.rahmenwerk.getBenutzer());
        }
    }

    private void parseLokaleEinstellungsdaten(String einstellungsDaten, SpeicherKey speicherKey) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(new InputSource(new StringReader(einstellungsDaten)), (DefaultHandler)new EinstellungenXmlHandler(this, speicherKey));
        }
        catch (ParserConfigurationException e) {
            LOGGER.error(e.getLocalizedMessage());
        }
        catch (SAXException e) {
            LOGGER.error(e.getLocalizedMessage());
        }
        catch (IOException e) {
            LOGGER.error(e.getLocalizedMessage());
        }
    }

    public void removeAvailabilityListener(EinstellungAvailabilityListener listener) {
        this.listenerManager.remove(listener);
    }

    public void removeChangeListener(EinstellungChangeListener listener, String category) {
        this.listenerManager.remove(listener, category);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setEinstellung(EinstellungsAdresse adresse, String data) {
        Object object = this.saveMutex;
        synchronized (object) {
            SpeicherKey key = new SpeicherKey(adresse);
            EinstellungsSpeicher speicher = this.speicherVerwaltung.get(key);
            if (speicher == null) {
                speicher = EinstellungsSpeicher.createSpeicher(key, this);
                this.speicherVerwaltung.put(key, speicher);
            }
            SpeicherErgebnis ergebnis = speicher.setValue(adresse, data);
            switch (ergebnis) {
                case NEW: 
                case CHANGED: 
                case REMOVED: {
                    try {
                        Object einstellung = speicher.getValue(adresse);
                        this.listenerManager.fireChanges(ergebnis, adresse, einstellung);
                    }
                    catch (IOException e) {
                        LOGGER.warning(e.getLocalizedMessage());
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setValue(EinstellungsAdresse adresse, Object einstellung, UrlasserInfo info) throws IOException, EinstellungsSpeicherException {
        Object object = this.saveMutex;
        synchronized (object) {
            EinstellungsFactory factory = this.validateAccess(adresse);
            SpeicherKey key = new SpeicherKey(adresse);
            EinstellungsSpeicher speicher = this.speicherVerwaltung.get(key);
            if (speicher == null) {
                if (key.isLocal() && key.getOwnerType() != EinstellungOwnerType.SYSTEM) {
                    this.initialisiereLokalenBenutzerSpeicher(this.rahmenwerk.getDavVerbindung().getDataModel().getObject(key.getPid()));
                }
                speicher = this.speicherVerwaltung.get(key);
                if (this.rahmenwerk.isOnline() && speicher == null) {
                    speicher = EinstellungsSpeicher.createSpeicher(key, this);
                    this.speicherVerwaltung.put(key, speicher);
                }
                if (speicher == null) {
                    throw new IOException("Einstellungsspeicher ist im Offline-Betrieb nicht verf\u00fcgbar!");
                }
            }
            SpeicherErgebnis ergebnis = einstellung == null ? speicher.setValue(adresse, null) : speicher.setValue(adresse, factory.serialisiere(einstellung));
            switch (ergebnis) {
                case NEW: 
                case CHANGED: 
                case REMOVED: {
                    speicher.save(info);
                    this.listenerManager.fireChanges(ergebnis, adresse, einstellung);
                    this.saveMutex.notifyAll();
                    break;
                }
            }
        }
    }

    private EinstellungsFactory validateAccess(EinstellungsAdresse adresse) {
        if (!(this.verbunden || adresse.getLocation() != EinstellungLocation.NETZWERKWEIT && adresse.getOwnerType() == EinstellungOwnerType.SYSTEM)) {
            throw new IllegalStateException("Es besteht keine Datenverteilerverbindung");
        }
        EinstellungsFactory factory = this.einstellungen.getFactory(adresse.getTyp());
        if (factory == null) {
            throw new IllegalStateException("Es ist keine Factory f\u00fcr die Kategorie: " + adresse.getTyp() + " registriert!");
        }
        return factory;
    }
}

