/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.rw.einstellungen;

import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungsAdresse;
import de.bsvrz.buv.rw.basislib.einstellungen.SpeicherKey;
import de.bsvrz.buv.rw.rw.einstellungen.DavConnector;
import de.bsvrz.buv.rw.rw.einstellungen.EinstellungenSpeichermanager;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class EinstellungenXmlHandler
extends DefaultHandler {
    private String currentId;
    private String currentTyp;
    private final StringBuilder currentData = new StringBuilder();
    private final StringBuilder teilData = new StringBuilder();
    private final EinstellungenSpeichermanager speichermanager;
    private final SpeicherKey speicherKey;
    private Map<String, String> vorherigeEinstellungen;

    EinstellungenXmlHandler(EinstellungenSpeichermanager speichermanager, SpeicherKey speicherKey) {
        this.speichermanager = speichermanager;
        this.speicherKey = speicherKey;
        this.vorherigeEinstellungen = speichermanager.getEinstellungsId(speicherKey);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("parameter".equals(qName)) {
            this.currentData.setLength(0);
            this.currentId = attributes.getValue("id");
            this.currentTyp = attributes.getValue("typ");
        } else if ("teilParameter".equals(qName)) {
            this.teilData.setLength(0);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("parameter".equals(qName)) {
            this.saveData();
            this.currentId = null;
            this.currentTyp = null;
            this.currentData.setLength(0);
        } else if ("teilParameter".equals(qName)) {
            this.currentData.append(DavConnector.entpackeString(this.teilData.toString()));
            this.teilData.setLength(0);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
        for (Map.Entry<String, String> entry : this.vorherigeEinstellungen.entrySet()) {
            EinstellungsAdresse adresse = new EinstellungsAdresse(entry.getValue(), entry.getKey(), this.speicherKey.getOwnerType(), this.speicherKey.getPid(), this.speicherKey.getLocation());
            this.speichermanager.setEinstellung(adresse, null);
        }
    }

    private void saveData() {
        if (this.currentData.length() > 0) {
            EinstellungsAdresse adresse = new EinstellungsAdresse(this.currentTyp, this.currentId, this.speicherKey.getOwnerType(), this.speicherKey.getPid(), this.speicherKey.getLocation());
            this.speichermanager.setEinstellung(adresse, DavConnector.entpackeString(this.currentData.toString()));
            String vorherigerTyp = this.vorherigeEinstellungen.get(this.currentId);
            if (adresse.getTyp().equals(vorherigerTyp)) {
                this.vorherigeEinstellungen.remove(this.currentId);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String strValue = new String(ch, start, length);
        this.currentData.append(strValue);
    }
}

