/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.rw.einstellungen;

import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungAvailabilityListener;
import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungChangeListener;
import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungsAdresse;
import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungsEvent;
import de.bsvrz.buv.rw.rw.einstellungen.SpeicherErgebnis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class EinstellungsListenerManager {
    private final List<EinstellungAvailabilityListener> avaliabilityListeners = new ArrayList<EinstellungAvailabilityListener>();
    private final List<EinstellungChangeListener> globalListeners = new ArrayList<EinstellungChangeListener>();
    private final Map<String, List<EinstellungChangeListener>> categoryListeners = new HashMap<String, List<EinstellungChangeListener>>();

    EinstellungsListenerManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireChanges(SpeicherErgebnis ergebnis, EinstellungsAdresse adresse, Object einstellung) {
        ArrayList<EinstellungChangeListener> listeners = new ArrayList<EinstellungChangeListener>();
        Object object = this.globalListeners;
        synchronized (object) {
            listeners.addAll(this.globalListeners);
        }
        object = this.categoryListeners;
        synchronized (object) {
            List<EinstellungChangeListener> liste = this.categoryListeners.get(adresse.getTyp());
            if (liste != null) {
                listeners.addAll(liste);
            }
        }
        if (!listeners.isEmpty()) {
            EinstellungsEvent event = new EinstellungsEvent((Object)this, adresse, einstellung);
            for (EinstellungChangeListener listener : listeners) {
                switch (ergebnis) {
                    case CHANGED: {
                        listener.einstellungAktualisiert(event);
                        break;
                    }
                    case NEW: {
                        listener.einstellungAngelegt(event);
                        break;
                    }
                    case REMOVED: {
                        listener.einstellungEntfernt(event);
                        break;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireAvailability(boolean status) {
        List<EinstellungAvailabilityListener> list = this.avaliabilityListeners;
        synchronized (list) {
            for (EinstellungAvailabilityListener listener : this.avaliabilityListeners) {
                if (status) {
                    listener.available();
                    continue;
                }
                listener.disabled();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(EinstellungChangeListener listener, String category) {
        if (category == null) {
            List<EinstellungChangeListener> list = this.globalListeners;
            synchronized (list) {
                this.globalListeners.add(listener);
            }
        }
        Map<String, List<EinstellungChangeListener>> map = this.categoryListeners;
        synchronized (map) {
            List<EinstellungChangeListener> liste = this.categoryListeners.get(category);
            if (liste == null) {
                liste = new ArrayList<EinstellungChangeListener>();
                this.categoryListeners.put(category, liste);
            }
            liste.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(EinstellungChangeListener listener, String category) {
        if (category == null) {
            List<EinstellungChangeListener> list = this.globalListeners;
            synchronized (list) {
                this.globalListeners.remove(listener);
            }
        }
        Map<String, List<EinstellungChangeListener>> map = this.categoryListeners;
        synchronized (map) {
            List<EinstellungChangeListener> liste = this.categoryListeners.get(category);
            if (liste != null) {
                liste.remove(listener);
                if (liste.isEmpty()) {
                    this.categoryListeners.remove(category);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(EinstellungAvailabilityListener listener) {
        List<EinstellungAvailabilityListener> list = this.avaliabilityListeners;
        synchronized (list) {
            this.avaliabilityListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(EinstellungAvailabilityListener listener) {
        List<EinstellungAvailabilityListener> list = this.avaliabilityListeners;
        synchronized (list) {
            this.avaliabilityListeners.remove(listener);
        }
    }
}

