/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.rw.einstellungen;

import de.bsvrz.buv.rw.basislib.einstellungen.Einstellung;
import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungOwnerType;
import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungsAdresse;
import de.bsvrz.buv.rw.basislib.einstellungen.SpeicherKey;
import de.bsvrz.buv.rw.rw.einstellungen.BenutzerKlasseNetzSpeicher;
import de.bsvrz.buv.rw.rw.einstellungen.BenutzerNetzSpeicher;
import de.bsvrz.buv.rw.rw.einstellungen.EinstellungImpl;
import de.bsvrz.buv.rw.rw.einstellungen.EinstellungenSpeichermanager;
import de.bsvrz.buv.rw.rw.einstellungen.EinstellungsSpeicherException;
import de.bsvrz.buv.rw.rw.einstellungen.LokalSpeicher;
import de.bsvrz.buv.rw.rw.einstellungen.SpeicherErgebnis;
import de.bsvrz.buv.rw.rw.einstellungen.SystemNetzSpeicher;
import de.bsvrz.puk.param.lib.daten.UrlasserInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class EinstellungsSpeicher {
    private final Map<EinstellungenKey, Einstellung> einstellungen = new HashMap<EinstellungenKey, Einstellung>();

    static EinstellungsSpeicher createSpeicher(SpeicherKey key, EinstellungenSpeichermanager manager) {
        EinstellungsSpeicher result;
        switch (key.getLocation()) {
            case LOKAL: {
                result = EinstellungsSpeicher.createLokalenSpeicher(key.getOwnerType(), key.getPid());
                break;
            }
            case NETZWERKWEIT: {
                result = EinstellungsSpeicher.createNetzSpeicher(key.getOwnerType(), key.getPid(), manager);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unerwartete Einstellungsspeicher-Location: " + key.getLocation());
            }
        }
        return result;
    }

    private static EinstellungsSpeicher createNetzSpeicher(EinstellungOwnerType ownerType, String pid, EinstellungenSpeichermanager manager) {
        EinstellungsSpeicher result;
        switch (ownerType) {
            case BENUTZER: {
                result = new BenutzerNetzSpeicher(pid, manager);
                break;
            }
            case BENUTZERKLASSE: {
                result = new BenutzerKlasseNetzSpeicher(pid, manager);
                break;
            }
            case SYSTEM: {
                result = new SystemNetzSpeicher(manager);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unerwarteter Einstellungsbesitzer: " + ownerType);
            }
        }
        return result;
    }

    private static EinstellungsSpeicher createLokalenSpeicher(EinstellungOwnerType ownerType, String pid) {
        LokalSpeicher result;
        switch (ownerType) {
            case BENUTZERKLASSE: 
            case BENUTZER: {
                result = new LokalSpeicher(pid);
                break;
            }
            case SYSTEM: {
                result = new LokalSpeicher(null);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unerwarteter Einstellungsbesitzer: " + ownerType);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getValue(EinstellungsAdresse adresse) throws IOException {
        Einstellung einstellung = null;
        Map<EinstellungenKey, Einstellung> map = this.einstellungen;
        synchronized (map) {
            einstellung = this.einstellungen.get(new EinstellungenKey(adresse));
        }
        if (einstellung == null) {
            return null;
        }
        return einstellung.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SpeicherErgebnis setValue(EinstellungsAdresse adresse, String daten) {
        SpeicherErgebnis result = SpeicherErgebnis.UNCHANGED;
        EinstellungenKey key = new EinstellungenKey(adresse);
        Map<EinstellungenKey, Einstellung> map = this.einstellungen;
        synchronized (map) {
            Einstellung oldValue = this.einstellungen.get(key);
            if (oldValue == null) {
                result = SpeicherErgebnis.NEW;
                this.einstellungen.put(key, new EinstellungImpl(key.typ, daten));
            } else if (!oldValue.getText().equals(daten)) {
                if (daten == null) {
                    result = SpeicherErgebnis.REMOVED;
                    this.einstellungen.remove(key);
                } else {
                    result = SpeicherErgebnis.CHANGED;
                    this.einstellungen.put(key, new EinstellungImpl(key.typ, daten));
                }
            }
        }
        return result;
    }

    void save(UrlasserInfo info) throws EinstellungsSpeicherException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            document.setXmlStandalone(true);
            Element root = document.createElement("einstellungen");
            document.appendChild(root);
            root.setAttribute("zeitstempel", DateFormat.getDateTimeInstance().format(new Date(System.currentTimeMillis())));
            for (Map.Entry<EinstellungenKey, Einstellung> einstellung : this.einstellungen.entrySet()) {
                Element parameterElement = document.createElement("parameter");
                parameterElement.setAttribute("id", einstellung.getKey().id);
                parameterElement.setAttribute("typ", einstellung.getKey().typ);
                root.appendChild(parameterElement);
                CDATASection dataElement = document.createCDATASection(einstellung.getValue().getText());
                parameterElement.appendChild(dataElement);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            DOMSource source = new DOMSource(document);
            ByteArrayOutputStream destinationStream = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(destinationStream);
            transformer.transform(source, result);
            this.doSave(new String(destinationStream.toByteArray(), "UTF-8"), info);
        }
        catch (Exception e) {
            throw new EinstellungsSpeicherException(e);
        }
    }

    protected abstract void doSave(String var1, UrlasserInfo var2) throws EinstellungsSpeicherException;

    public Map<String, String> getEinstellungsId() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (EinstellungenKey key : this.einstellungen.keySet()) {
            result.put(key.id, key.typ);
        }
        return result;
    }

    private static class EinstellungenKey {
        private final String typ;
        private final String id;

        EinstellungenKey(EinstellungsAdresse adresse) {
            this.typ = adresse.getTyp();
            this.id = adresse.getId();
        }

        public String toString() {
            return String.valueOf(this.typ) + ": " + this.id;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.typ == null ? 0 : this.typ.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EinstellungenKey other = (EinstellungenKey)obj;
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            return !(this.typ == null ? other.typ != null : !this.typ.equals(other.typ));
        }
    }
}

