/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.rw;

import de.bsvrz.buv.rw.rw.menu.RwToolbarElementManagerImpl;
import de.bsvrz.buv.rw.rw.perspective.RwPerspectives;
import de.bsvrz.buv.rw.rw.preferences.RahmenwerkPreference;
import java.util.Arrays;
import java.util.Optional;
import java.util.Timer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public final class RahmenwerkActivator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "de.bsvrz.buv.rw.rw";
    private static RahmenwerkActivator plugin;
    private MApplication application;
    private static final Timer RAHMENWERK_TIMER;
    private RwPerspectives rwPerspectives;
    private RwToolbarElementManagerImpl toolbarElementManager;

    static {
        RAHMENWERK_TIMER = new Timer("RahmenwerkMainTimer", true);
    }

    public static RahmenwerkActivator getDefault() {
        return plugin;
    }

    public static Timer getRahmenwerkTimer() {
        return RAHMENWERK_TIMER;
    }

    public MApplication getApplication() {
        return this.application;
    }

    public Image getImage(String pluginPath) {
        ImageDescriptor descriptor = this.getImageDescriptor(pluginPath);
        if (descriptor == null) {
            return null;
        }
        Image image = this.getImageRegistry().get(descriptor.toString());
        if (image == null) {
            image = descriptor.createImage();
            this.getImageRegistry().put(descriptor.toString(), image);
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String pluginPath) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)pluginPath);
    }

    public void setApplication(MApplication application) {
        this.application = application;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        RahmenwerkPreference[] rahmenwerkPreferenceArray = RahmenwerkPreference.values();
        int n = rahmenwerkPreferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            RahmenwerkPreference preference = rahmenwerkPreferenceArray[n2];
            Object defaultValue = preference.getDefaultValue();
            if (defaultValue != null) {
                if (defaultValue instanceof Boolean) {
                    this.getPreferenceStore().setDefault(preference.getId(), ((Boolean)defaultValue).booleanValue());
                } else if (defaultValue instanceof Integer) {
                    this.getPreferenceStore().setDefault(preference.getId(), ((Integer)defaultValue).intValue());
                } else if (defaultValue instanceof Double) {
                    this.getPreferenceStore().setDefault(preference.getId(), ((Double)defaultValue).doubleValue());
                } else {
                    this.getPreferenceStore().setDefault(preference.getId(), defaultValue.toString());
                }
            }
            ++n2;
        }
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public RwPerspectives getRwPerspectives() {
        if (this.rwPerspectives == null) {
            this.rwPerspectives = new RwPerspectives();
        }
        return this.rwPerspectives;
    }

    public String getDefaultPerspectiveId() {
        String result = this.getPreferenceStore().getString(RahmenwerkPreference.START_PERSPEKTIVE.getId());
        if (!this.getRwPerspectives().hasPerspective(result)) {
            result = (String)RahmenwerkPreference.START_PERSPEKTIVE.getDefaultValue();
        }
        return result;
    }

    public Image findCommandImage(String id) {
        IExtension[] extensions;
        Optional<IConfigurationElement> first;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.ui.commandImages");
        Image returnImage = null;
        if (point != null && (first = Arrays.asList(extensions = point.getExtensions()).stream().flatMap(e -> Arrays.asList(e.getConfigurationElements()).stream()).filter(e -> id.equals(e.getAttribute("commandId"))).findFirst()).isPresent()) {
            IConfigurationElement e2 = first.get();
            ImageDescriptor iconDesc = RahmenwerkActivator.imageDescriptorFromPlugin((String)e2.getNamespaceIdentifier(), (String)e2.getAttribute("icon"));
            returnImage = this.getImageRegistry().get(iconDesc.toString());
            if (returnImage == null) {
                returnImage = iconDesc.createImage();
                this.getImageRegistry().put(iconDesc.toString(), returnImage);
            }
        }
        return returnImage;
    }

    public RwToolbarElementManagerImpl getRwToolBarManager() {
        if (this.toolbarElementManager == null) {
            this.toolbarElementManager = (RwToolbarElementManagerImpl)ContextInjectionFactory.make(RwToolbarElementManagerImpl.class, (IEclipseContext)this.application.getContext());
            this.toolbarElementManager.init();
        }
        return this.toolbarElementManager;
    }
}

