/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.rw.handler;

import de.bsvrz.buv.rw.basislib.Rahmenwerk;
import de.bsvrz.buv.rw.basislib.dav.DavConnectionException;
import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsEvent;
import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsListener;
import de.bsvrz.buv.rw.rw.internal.RahmenwerkImpl;
import de.bsvrz.buv.rw.rw.login.LoginDialog;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class AnmeldenHandler
extends AbstractHandler
implements DavVerbindungsListener {
    private final Rahmenwerk rahmenwerk = RahmenwerkImpl.getInstanz();

    public AnmeldenHandler() {
        this.rahmenwerk.addDavVerbindungsListener((DavVerbindungsListener)this);
        this.setBaseEnabled(!this.rahmenwerk.isOnline());
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        LoginDialog login = new LoginDialog();
        if (login.open() == 0 && login.getAnmeldeDaten().isOnline()) {
            try {
                ((RahmenwerkImpl)this.rahmenwerk).login(login.getAnmeldeDaten());
                this.setEnabled(false);
            }
            catch (DavConnectionException e) {
                this.setEnabled(true);
                ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"FEHLER", (String)("Anmeldung fehlgeschlagen:\n" + e.getLocalizedMessage()), (IStatus)new Status(4, "de.bsvrz.buv.rw.rw", e.getLocalizedMessage()));
            }
        }
        return null;
    }

    public void verbindungHergestellt(DavVerbindungsEvent event) {
        this.setBaseEnabled(false);
    }

    public void verbindungGetrennt(DavVerbindungsEvent event) {
        this.setBaseEnabled(true);
    }

    public boolean verbindungHalten(DavVerbindungsEvent event) {
        return false;
    }
}

