/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.rw.internal;

import de.bsvrz.buv.rw.basislib.Rahmenwerk;
import de.bsvrz.buv.rw.basislib.dav.DavConnectionException;
import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsEvent;
import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsListener;
import de.bsvrz.buv.rw.rw.RahmenwerkActivator;
import de.bsvrz.buv.rw.rw.login.LoginDialog;
import de.bsvrz.buv.rw.rw.menu.RwToolbarElementManagerImpl;
import de.bsvrz.dav.daf.main.ApplicationCloseActionHandler;
import de.bsvrz.dav.daf.main.ClientDavConnection;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientDavParameters;
import de.bsvrz.dav.daf.main.CommunicationError;
import de.bsvrz.dav.daf.main.ConnectionException;
import de.bsvrz.dav.daf.main.DavConnectionListener;
import de.bsvrz.dav.daf.main.InconsistentLoginException;
import de.bsvrz.dav.daf.main.MissingParameterException;
import de.bsvrz.dav.daf.main.config.ConfigurationAuthority;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.commandLineArgs.ArgumentList;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.operatingMessage.MessageSender;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.SafeRunnable;

public final class RahmenwerkImpl
implements Rahmenwerk {
    private static RahmenwerkImpl instanz;
    private String[] arguments;
    private ClientDavConnection davVerbindung;
    private String benutzerName;
    private String passwort;
    private final List<DavVerbindungsListener> verbindungsListenerList = new ArrayList<DavVerbindungsListener>();
    private static final Debug LOGGER;

    static {
        LOGGER = Debug.getLogger();
    }

    public static RahmenwerkImpl getInstanz() {
        return instanz;
    }

    protected void activate() {
        this.arguments = Platform.getApplicationArgs();
        instanz = this;
        try {
            ClientDavParameters parameters = new ClientDavParameters();
            LOGGER.finer("ClientDavParameter initialisiert" + parameters);
        }
        catch (MissingParameterException e) {
            LOGGER.finer("ClientDavParameterinitialisierung fehlgeschalgen: " + e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDavVerbindungsListener(DavVerbindungsListener listener) {
        List<DavVerbindungsListener> list = this.verbindungsListenerList;
        synchronized (list) {
            this.verbindungsListenerList.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void davVerbindungBeenden() {
        if (this.davVerbindung != null) {
            Object listener2;
            DavVerbindungsEvent event = new DavVerbindungsEvent((Object)this, DavVerbindungsEvent.Type.DISCONNECT, (ClientDavInterface)this.davVerbindung);
            Object vetoLock = new Object();
            VetoListenerJob vetoListenerJob = new VetoListenerJob(this, vetoLock);
            for (Object listener2 : this.verbindungsListenerList) {
                if (!listener2.verbindungHalten(event)) continue;
                vetoListenerJob.addVetoListener((DavVerbindungsListener)listener2);
            }
            vetoListenerJob.schedule();
            listener2 = vetoLock;
            synchronized (listener2) {
                try {
                    if (!vetoListenerJob.isRunning()) {
                        vetoLock.wait(5000L);
                    }
                }
                catch (InterruptedException e) {
                    LOGGER.warning(e.getLocalizedMessage());
                }
            }
            IJobManager jobManager = Job.getJobManager();
            jobManager.cancel((Object)"RahmenwerkJobs");
            try {
                jobManager.join((Object)"RahmenwerkJobs", null);
            }
            catch (OperationCanceledException e) {
                LOGGER.warning(e.getLocalizedMessage(), (Throwable)e);
            }
            catch (InterruptedException e) {
                LOGGER.warning(e.getLocalizedMessage(), (Throwable)e);
            }
            this.davVerbindung.disconnect(false, null);
        }
    }

    public void davVerbindungHerstellen(String name, String pass, String host, int port) throws DavConnectionException {
        if (this.davVerbindung != null) {
            throw new IllegalStateException("Es besteht bereits eine Datenverteilerverbindung");
        }
        this.benutzerName = name;
        this.passwort = pass;
        ArgumentList argumentList = this.getStartParameter();
        try {
            ClientDavParameters parameter = new ClientDavParameters(argumentList);
            parameter.setDavCommunicationAddress(host);
            parameter.setDavCommunicationSubAddress(port);
            if (argumentList.hasArgument("-ConfigurationPathBenutzer")) {
                parameter.setConfigurationPath(argumentList.fetchArgument("-ConfigurationPathBenutzer").getValue());
            }
            if (argumentList.hasArgument("-applicationTypePid")) {
                parameter.setApplicationTypePid(argumentList.fetchArgument("-applicationTypePid").getValue());
            }
            StringBuilder appName = new StringBuilder();
            appName.append("Rahmenwerk_auf_");
            appName.append(InetAddress.getLocalHost().getHostAddress());
            appName.append("_Benutzer_");
            appName.append(this.benutzerName);
            parameter.setApplicationName(appName.toString());
            this.davVerbindung = new ClientDavConnection(parameter);
            this.davVerbindung.connect();
            this.davVerbindung.addConnectionListener(new DavConnectionListener(){

                public void connectionClosed(ClientDavInterface dav) {
                    if (dav.equals(RahmenwerkImpl.this.davVerbindung)) {
                        DavVerbindungsEvent event = new DavVerbindungsEvent((Object)this, DavVerbindungsEvent.Type.DISCONNECT, (ClientDavInterface)RahmenwerkImpl.this.davVerbindung);
                        RahmenwerkImpl.this.davVerbindung = null;
                        RahmenwerkImpl.this.fireVerbindungsListeners(event);
                    }
                }
            });
            this.davVerbindung.setCloseHandler(new ApplicationCloseActionHandler(){

                public void close(String message) {
                    if (RahmenwerkImpl.this.davVerbindung != null) {
                        RahmenwerkImpl.this.davVerbindung.disconnect(true, message);
                        DavVerbindungsEvent event = new DavVerbindungsEvent((Object)this, DavVerbindungsEvent.Type.DISCONNECT, (ClientDavInterface)RahmenwerkImpl.this.davVerbindung);
                        RahmenwerkImpl.this.davVerbindung = null;
                        RahmenwerkImpl.this.fireVerbindungsListeners(event);
                    }
                }
            });
            this.davVerbindung.login(name, this.passwort);
            MessageSender.getInstance().init((ClientDavInterface)this.davVerbindung, "Rahmenwerk", appName.toString());
            DavVerbindungsEvent event = new DavVerbindungsEvent((Object)this, DavVerbindungsEvent.Type.CONNECT, (ClientDavInterface)this.davVerbindung);
            this.fireVerbindungsListeners(event);
        }
        catch (CommunicationError | ConnectionException | InconsistentLoginException | MissingParameterException | UnknownHostException e) {
            this.handleConnectionError((Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireVerbindungsListeners(final DavVerbindungsEvent event) {
        DavVerbindungsEvent.Type type = event.getType();
        HashSet<DavVerbindungsListener> listeners = new HashSet<DavVerbindungsListener>();
        List<DavVerbindungsListener> list = this.verbindungsListenerList;
        synchronized (list) {
            listeners.addAll(this.verbindungsListenerList);
        }
        switch (type) {
            case CONNECT: {
                for (final DavVerbindungsListener listener : listeners) {
                    listener.verbindungHergestellt(event);
                }
                break;
            }
            case DISCONNECT: {
                for (final DavVerbindungsListener listener : listeners) {
                    SafeRunnable.run((ISafeRunnable)new ISafeRunnable(){

                        public void run() throws Exception {
                            listener.verbindungGetrennt(event);
                        }

                        public void handleException(Throwable exception) {
                            ILog log = RahmenwerkActivator.getDefault().getLog();
                            log.log((IStatus)new Status(4, "de.bsvrz.buv.rw.rw", "Fehler beim unterbrechen der Datenverteiler-Verbindung...", exception));
                        }
                    });
                }
                break;
            }
        }
    }

    public String getBenutzerName() {
        return this.benutzerName;
    }

    public SystemObject getBenutzer() {
        if (this.davVerbindung != null) {
            return this.davVerbindung.getLocalUser();
        }
        return null;
    }

    public ClientDavInterface getDavVerbindung() {
        return this.davVerbindung;
    }

    public String getPasswort() {
        return this.passwort;
    }

    public ArgumentList getStartParameter() {
        String[] argCopy = new String[this.arguments.length];
        System.arraycopy(this.arguments, 0, argCopy, 0, this.arguments.length);
        return new ArgumentList(argCopy);
    }

    private void handleConnectionError(Exception e) throws DavConnectionException {
        if (this.davVerbindung != null) {
            this.davVerbindung.disconnect(false, e.getLocalizedMessage());
            this.davVerbindung = null;
        }
        throw new DavConnectionException("Datenverteilerverbindung konnte nicht hergestellt werden", e);
    }

    public boolean isOnline() {
        return this.davVerbindung != null;
    }

    public void login(LoginDialog.AnmeldeDaten daten) throws DavConnectionException {
        try {
            this.davVerbindungHerstellen(daten.getName(), daten.getPasswort(), daten.getHost(), daten.getPort());
        }
        catch (IllegalArgumentException e) {
            MessageDialog.openError(null, (String)"FEHLER", (String)(String.valueOf(e.getLocalizedMessage()) + "\nDie Applikation wird beendet"));
            throw new IllegalArgumentException("Oberflaechenobjekt konnte nicht ermittelt werden", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDavVerbindungsListener(DavVerbindungsListener listener) {
        List<DavVerbindungsListener> list = this.verbindungsListenerList;
        synchronized (list) {
            this.verbindungsListenerList.remove(listener);
        }
    }

    public void setBenutzerName(String benutzerName) {
        this.benutzerName = benutzerName;
    }

    public boolean usesBerechtigungenNeu() {
        ArgumentList.Argument argument;
        ArgumentList argumente = this.getStartParameter();
        return argumente.hasArgument("-rechtePruefung") && "neu".equals((argument = argumente.fetchArgument("-rechtePruefung")).getValue());
    }

    public SystemObject getOberflaechenObject() {
        ConfigurationAuthority result = null;
        if (this.davVerbindung != null) {
            ArgumentList argumente = this.getStartParameter();
            if (argumente.hasArgument("-oberflaechenObjekt")) {
                ArgumentList.Argument argument = argumente.fetchArgument("-oberflaechenObjekt");
                result = this.davVerbindung.getDataModel().getObject(argument.getValue());
                if (result == null) {
                    throw new IllegalArgumentException("Das geforderte Oberfl\u00e4chenobjekt mit der PID \"" + argument.getValue() + "\" ist in der verwendeten Konfiguration nicht verf\u00fcgbar!");
                }
            } else {
                result = this.davVerbindung.getLocalConfigurationAuthority();
            }
        }
        return result;
    }

    public RwToolbarElementManagerImpl getRwToolBarManager() {
        return RahmenwerkActivator.getDefault().getRwToolBarManager();
    }

    private static class VetoListenerJob
    extends Job {
        private final Set<DavVerbindungsListener> vetoListeners = new HashSet<DavVerbindungsListener>();
        private final Rahmenwerk rahmenwerk;
        private final Object lock;
        private boolean running;

        VetoListenerJob(RahmenwerkImpl rahmenwerk, Object lock) {
            super("VetoListenerHandler");
            this.rahmenwerk = rahmenwerk;
            this.lock = lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            monitor.setTaskName("Warte auf zu schlie\u00dfende Datenverteilerverbindungen ....");
            Object object = this.lock;
            synchronized (object) {
                this.running = true;
                this.lock.notifyAll();
            }
            DavVerbindungsEvent event = new DavVerbindungsEvent((Object)this.rahmenwerk, DavVerbindungsEvent.Type.DISCONNECT, this.rahmenwerk.getDavVerbindung());
            while (this.running) {
                Set<DavVerbindungsListener> set = this.vetoListeners;
                synchronized (set) {
                    HashSet<DavVerbindungsListener> keinVeto = new HashSet<DavVerbindungsListener>();
                    for (DavVerbindungsListener listener : this.vetoListeners) {
                        if (listener.verbindungHalten(event)) continue;
                        keinVeto.add(listener);
                    }
                    this.vetoListeners.removeAll(keinVeto);
                    if (this.vetoListeners.isEmpty()) {
                        this.running = false;
                    }
                }
                if (!this.running) continue;
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    LOGGER.warning(e.getLocalizedMessage());
                }
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addVetoListener(DavVerbindungsListener listener) {
            Set<DavVerbindungsListener> set = this.vetoListeners;
            synchronized (set) {
                this.vetoListeners.add(listener);
            }
        }

        public boolean belongsTo(Object family) {
            return "RahmenwerkJobs".equals(family);
        }

        public boolean isRunning() {
            return this.running;
        }
    }
}

