/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.rw.internal;

import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsEvent;
import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsListener;
import de.bsvrz.buv.rw.rw.internal.RahmenwerkImpl;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class RahmenwerkTray {
    private final TrayItem trayItem;
    private final Image grayImage = this.createTrayImage("icons/tray/traygray.png");
    private final Image greenImage = this.createTrayImage("icons/tray/traygreen.png");

    public RahmenwerkTray(Tray parent) {
        this.trayItem = new TrayItem(parent, 0);
        this.updateTrayDisplay();
        DavVerbindungsListener listener = new DavVerbindungsListener(){

            public void verbindungHergestellt(DavVerbindungsEvent event) {
                RahmenwerkTray.this.updateStatus();
            }

            public void verbindungGetrennt(DavVerbindungsEvent event) {
                RahmenwerkTray.this.updateStatus();
            }

            public boolean verbindungHalten(DavVerbindungsEvent event) {
                return false;
            }
        };
        RahmenwerkImpl.getInstanz().addDavVerbindungsListener(listener);
    }

    private Image createTrayImage(String imagePath) {
        ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"de.bsvrz.buv.rw.rw", (String)imagePath);
        if (descriptor == null) {
            return null;
        }
        return descriptor.createImage();
    }

    private void updateStatus() {
        if (this.trayItem != null) {
            this.trayItem.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    RahmenwerkTray.this.updateTrayDisplay();
                }
            });
        }
    }

    public void dispose() {
        if (this.grayImage != null) {
            this.grayImage.dispose();
        }
        if (this.greenImage != null) {
            this.greenImage.dispose();
        }
        this.trayItem.dispose();
    }

    private void updateTrayDisplay() {
        if (this.trayItem != null && !this.trayItem.isDisposed()) {
            Image image;
            String tooltip;
            RahmenwerkImpl rahmenwerk = RahmenwerkImpl.getInstanz();
            ClientDavInterface dav = null;
            if (rahmenwerk.isOnline()) {
                dav = rahmenwerk.getDavVerbindung();
            }
            if (dav == null) {
                tooltip = "Keine Datenverteilerverbindung";
                image = this.grayImage;
            } else {
                tooltip = "Verbindung aufgebaut\n" + dav.getLocalUser() + "\non " + dav.getClientDavParameters().getDavCommunicationAddress() + ":" + dav.getClientDavParameters().getDavCommunicationSubAddress();
                image = this.greenImage;
            }
            this.trayItem.setToolTipText(tooltip);
            this.trayItem.setImage(image);
        }
    }
}

