/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.rw.login;

import de.bsvrz.buv.rw.rw.RahmenwerkActivator;
import de.bsvrz.buv.rw.rw.internal.RahmenwerkImpl;
import de.bsvrz.sys.funclib.commandLineArgs.ArgumentList;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class LoginDialog
extends TitleAreaDialog {
    private static final Debug LOGGER = Debug.getLogger();
    private final List<String> serverIps = new ArrayList<String>();
    private final List<Integer> serverPorts = new ArrayList<Integer>();
    private static final String AUFBAU_STRING_SERVER_IP = "ServerIp";
    private static final String AUFBAU_STRING_SERVER_PORT = "ServerPort";
    private final IPreferenceStore preferences = RahmenwerkActivator.getDefault().getPreferenceStore();
    private static final int MAX_LOGIN_HISTORIE = 5;
    private static final int ONLINE_ID = 1025;
    private static final int OFFLINE_ID = 1026;
    private AnmeldeDaten anmeldeDaten;
    private Text textBenutzername;
    private Text textPasswort;
    private String anmeldeHost;
    private int anmeldePort;
    private final ButtonUpdater buttonUpdater = new ButtonUpdater();
    private final String initialErrorText;
    private Image loginLogo;

    public LoginDialog() {
        this(null);
    }

    public LoginDialog(String errorText) {
        super(null);
        this.initialErrorText = errorText;
        ArgumentList startParameter = RahmenwerkImpl.getInstanz().getStartParameter();
        if (startParameter.hasArgument("-loginLogo")) {
            String imagePath = startParameter.fetchArgument("-loginLogo").getValue();
            this.loginLogo = new Image((Device)Display.getCurrent(), imagePath);
        }
        if (this.loginLogo == null) {
            this.loginLogo = RahmenwerkActivator.getDefault().getImageDescriptor("icons/wizban/bitctrl_wizard.png").createImage();
        }
    }

    protected void buttonPressed(int buttonId) {
        IPreferenceStore preferenceStore = RahmenwerkActivator.getDefault().getPreferenceStore();
        preferenceStore.setValue(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".X", this.getShell().getLocation().x);
        preferenceStore.setValue(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".Y", this.getShell().getLocation().y);
        switch (buttonId) {
            case 1025: {
                this.anmeldeDaten = this.liesAnmeldeDaten(true);
                this.okPressed();
                break;
            }
            case 1026: {
                this.anmeldeDaten = this.liesAnmeldeDaten(false);
                this.okPressed();
                break;
            }
            case 1: {
                this.cancelPressed();
                break;
            }
            default: {
                super.buttonPressed(buttonId);
            }
        }
    }

    public boolean close() {
        boolean result = super.close();
        if (this.loginLogo != null) {
            this.loginLogo.dispose();
        }
        return result;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, "Online", true).setEnabled(false);
        this.createButton(parent, 1026, "Offline", false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        ArgumentList startParameter = RahmenwerkImpl.getInstanz().getStartParameter();
        this.getShell().setText("Anmeldung");
        if (startParameter.hasArgument("-loginDialogTitel")) {
            this.getShell().setText(startParameter.fetchArgument("-loginDialogTitel").getValue());
        }
        this.setTitle("Rahmenwerk-Anmeldung");
        if (startParameter.hasArgument("-loginTitel")) {
            this.setTitle(startParameter.fetchArgument("-loginTitel").getValue());
        }
        this.setMessage("Geben Sie ihre Anmeldedaten an oder starten Sie im Offline-Betrieb");
        if (startParameter.hasArgument("-loginMessage")) {
            this.setMessage(startParameter.fetchArgument("-loginMessage").getValue());
        }
        this.setTitleImage(this.loginLogo);
        this.ladePraeferenzen();
        Composite panel = new Composite(parent, 0);
        panel.setLayoutData((Object)new GridData(1808));
        panel.setLayout((Layout)new GridLayout(4, false));
        Label labelBenutzername = new Label(panel, 0);
        labelBenutzername.setText("Benutzername:");
        this.textBenutzername = new Text(panel, 2048);
        this.textBenutzername.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(3, 1).create());
        this.textBenutzername.addModifyListener((ModifyListener)this.buttonUpdater);
        Label labelPasswort = new Label(panel, 0);
        labelPasswort.setText("Passwort:");
        this.textPasswort = new Text(panel, 0x400800);
        this.textPasswort.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(3, 1).create());
        this.textPasswort.addModifyListener((ModifyListener)this.buttonUpdater);
        if (!startParameter.hasArgument("-disableHost")) {
            Label labelAdresse = new Label(panel, 0);
            labelAdresse.setText("Domainname / IP-Adresse:");
            this.erzeugeAuswahlAdresse(panel);
            Label labelPort = new Label(panel, 0);
            labelPort.setText("TCP-Portnummer:");
            this.erzeugeAuswahlPort(panel);
        } else if (startParameter.hasArgument("-datenverteiler")) {
            this.initAnmeldedaten(startParameter.fetchArgument("-datenverteiler").getValue());
        } else {
            this.initAnmeldedaten(null);
        }
        try {
            String helpContextId = "de.bsvrz.buv.rw.rw.logindialog";
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)panel, "de.bsvrz.buv.rw.rw.logindialog");
        }
        catch (IllegalStateException exception) {
            LOGGER.fine(exception.getLocalizedMessage());
        }
        if (this.initialErrorText != null) {
            this.setErrorMessage(this.initialErrorText);
        }
        return super.createDialogArea(parent);
    }

    private void initAnmeldedaten(String daten) {
        this.anmeldeHost = "localhost";
        this.anmeldePort = 8083;
        if (daten != null) {
            String[] split = daten.split(":");
            this.anmeldeHost = split[0];
            if (split.length > 1) {
                try {
                    this.anmeldePort = Integer.parseInt(split[1]);
                }
                catch (NumberFormatException e) {
                    LOGGER.warning(e.getLocalizedMessage());
                }
            }
        }
    }

    private Combo erzeugeAuswahlAdresse(Composite comp) {
        Combo comboAdresse = new Combo(comp, 0);
        comboAdresse.setData((Object)AUFBAU_STRING_SERVER_IP);
        comboAdresse.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        for (String ip : this.serverIps) {
            comboAdresse.add(ip);
        }
        if (!this.serverIps.isEmpty()) {
            String host = this.serverIps.get(0);
            comboAdresse.setText(host);
            this.anmeldeHost = host;
        }
        comboAdresse.addSelectionListener((SelectionListener)this.buttonUpdater);
        comboAdresse.addModifyListener((ModifyListener)this.buttonUpdater);
        return comboAdresse;
    }

    private Combo erzeugeAuswahlPort(Composite composite) {
        Combo comboPort = new Combo(composite, 0);
        comboPort.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        comboPort.setData((Object)AUFBAU_STRING_SERVER_PORT);
        if (this.serverPorts.size() > 0) {
            for (Integer portItem : this.serverPorts) {
                comboPort.add(portItem.toString());
            }
            comboPort.setText(this.serverPorts.get(0).toString());
            this.anmeldePort = this.serverPorts.get(0);
        }
        comboPort.addSelectionListener((SelectionListener)this.buttonUpdater);
        comboPort.addModifyListener((ModifyListener)this.buttonUpdater);
        return comboPort;
    }

    public AnmeldeDaten getAnmeldeDaten() {
        return this.anmeldeDaten;
    }

    private void hinzufuegenIp(String ip) {
        if (!ip.isEmpty()) {
            this.serverIps.remove(ip.toLowerCase());
            this.serverIps.add(0, ip.toLowerCase());
            while (this.serverIps.size() > 5) {
                this.serverIps.remove(this.serverIps.size() - 1);
            }
        }
    }

    private void hinzufuegenPort(Integer port) {
        if (port != null) {
            this.serverPorts.remove(port);
            this.serverPorts.add(0, port);
        }
        while (this.serverPorts.size() > 5) {
            this.serverPorts.remove(this.serverPorts.size() - 1);
        }
    }

    private void ladePraeferenzen() {
        int i = 0;
        while (i < 5) {
            int port;
            String tempId = AUFBAU_STRING_SERVER_IP + i;
            String tempPort = AUFBAU_STRING_SERVER_PORT + i;
            String ip = this.preferences.getString(tempId);
            if (ip != null) {
                this.serverIps.add(ip);
            }
            if ((port = this.preferences.getInt(tempPort)) > 0) {
                this.serverPorts.add(port);
            }
            ++i;
        }
    }

    private AnmeldeDaten liesAnmeldeDaten(boolean online) {
        String name = this.textBenutzername.getText().trim();
        String passwort = this.textPasswort.getText();
        if (!this.anmeldeHost.isEmpty() && this.anmeldePort > 0) {
            this.hinzufuegenIp(this.anmeldeHost);
            this.hinzufuegenPort(this.anmeldePort);
            this.speicherePraeferenzen();
        }
        return new AnmeldeDaten(name, passwort, this.anmeldeHost, this.anmeldePort, online);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x4000);
    }

    private void speicherePraeferenzen() {
        String id;
        int idx = 0;
        while (idx < 5) {
            id = AUFBAU_STRING_SERVER_IP + idx;
            if (this.serverIps.size() > idx) {
                this.preferences.setValue(id, this.serverIps.get(idx));
            } else {
                this.preferences.setValue(id, null);
            }
            ++idx;
        }
        idx = 0;
        while (idx < 5) {
            id = AUFBAU_STRING_SERVER_PORT + idx;
            if (this.serverPorts.size() > idx) {
                this.preferences.setValue(id, this.serverPorts.get(idx).intValue());
            } else {
                this.preferences.setValue(id, 0);
            }
            ++idx;
        }
    }

    private void updateButtons(Object control) {
        boolean error = false;
        if (control instanceof Combo) {
            Combo combo = (Combo)control;
            if (AUFBAU_STRING_SERVER_IP.equals(combo.getData())) {
                this.anmeldeHost = combo.getText().trim();
            } else if (AUFBAU_STRING_SERVER_PORT.equals(combo.getData())) {
                try {
                    this.anmeldePort = Integer.parseInt(combo.getText().trim());
                    if (this.anmeldePort < 1 || this.anmeldePort > 65535) {
                        this.setMessage("Der Port " + this.anmeldePort + " f\u00fcr die Datenverteilerverbindung ist ung\u00fcltig!", 3);
                        error = true;
                    }
                }
                catch (NumberFormatException e) {
                    LOGGER.finer(e.getLocalizedMessage());
                    this.setMessage("Der Eingabe \"" + combo.getText() + "\" kann nicht als Zahl interpretiert werden!", 3);
                    error = true;
                }
            }
        }
        if (!error) {
            if (this.textBenutzername.getText().trim().isEmpty()) {
                this.setMessage("Es wurde kein Benutzername angegeben!", 2);
                error = true;
            } else if (this.textPasswort.getText().trim().isEmpty()) {
                this.setMessage("Es wurde kein Passwort angegeben!", 2);
                error = true;
            } else if (this.anmeldeHost == null || this.anmeldeHost.isEmpty()) {
                this.setMessage("Es wurde keine Datenverteiler-Host angegeben!", 2);
                error = true;
            } else if (this.anmeldePort < 1 || this.anmeldePort > 65535) {
                this.setMessage("Der Port " + this.anmeldePort + " f\u00fcr die Datenverteilerverbindung ist ung\u00fcltig!", 3);
                error = true;
            }
        }
        if (!error) {
            this.setErrorMessage(null);
            this.setMessage("Geben Sie ihre Anmeldedaten an oder starten Sie im Offline-Betrieb");
        }
        this.getButton(1025).setEnabled(!error);
    }

    protected Point getInitialLocation(Point initialSize) {
        IPreferenceStore preferenceStore = RahmenwerkActivator.getDefault().getPreferenceStore();
        int x = preferenceStore.getInt(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".X");
        int y = preferenceStore.getInt(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".Y");
        if (x == 0 && y == 0) {
            return super.getInitialLocation(initialSize);
        }
        Rectangle bounds = this.getConstrainedShellBounds(new Rectangle(x, y, initialSize.x, initialSize.y));
        return new Point(bounds.x, bounds.y);
    }

    public static final class AnmeldeDaten {
        private final String name;
        private final String passwort;
        private final String host;
        private final int port;
        private final boolean online;

        private AnmeldeDaten(String name, String passwort, String host, int port, boolean online) {
            this.name = name;
            this.passwort = passwort;
            this.host = host;
            this.port = port;
            this.online = online;
        }

        public String getHost() {
            return this.host;
        }

        public String getName() {
            return this.name;
        }

        public String getPasswort() {
            return this.passwort;
        }

        public int getPort() {
            return this.port;
        }

        public boolean isOnline() {
            return this.online;
        }
    }

    private class ButtonUpdater
    implements ModifyListener,
    SelectionListener {
        private ButtonUpdater() {
        }

        public void modifyText(ModifyEvent e) {
            LoginDialog.this.updateButtons(e.getSource());
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            LoginDialog.this.updateButtons(e.getSource());
        }

        public void widgetSelected(SelectionEvent e) {
            LoginDialog.this.updateButtons(e.getSource());
        }
    }
}

