/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.rw.menu;

import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungLocation;
import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungOwnerType;
import de.bsvrz.buv.rw.basislib.einstellungen.SpeicherKey;
import de.bsvrz.buv.rw.basislib.util.RahmenwerkUtil;
import de.bsvrz.buv.rw.rw.RahmenwerkActivator;
import de.bsvrz.buv.rw.rw.internal.RahmenwerkImpl;
import de.bsvrz.dav.daf.main.config.SystemObject;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class LadeSpeicherDialogMenu
extends TitleAreaDialog {
    private final boolean online;
    private SystemObject benutzer;
    private final int style;
    private SpeicherKey speicherKey;
    private Group locationGroup;
    private Group ownerGroup;
    private ComboViewer benutzerAuswahl;
    private boolean userAdmin;

    public LadeSpeicherDialogMenu(Shell parentShell, int style) {
        super(parentShell);
        this.style = style;
        RahmenwerkImpl rahmenwerk = RahmenwerkImpl.getInstanz();
        this.online = rahmenwerk.isOnline();
        if (this.online) {
            this.benutzer = rahmenwerk.getBenutzer();
            this.speicherKey = new SpeicherKey(EinstellungOwnerType.BENUTZER, EinstellungLocation.NETZWERKWEIT, this.benutzer.getPid());
        } else {
            this.benutzer = null;
            this.speicherKey = new SpeicherKey(EinstellungOwnerType.SYSTEM, EinstellungLocation.LOKAL, null);
        }
    }

    private void validateSpeicherKey() {
        boolean valid = false;
        if (this.userAdmin || this.speicherKey.getOwnerType() == EinstellungOwnerType.BENUTZER) {
            valid = true;
        } else if (this.speicherKey.getLocation() == EinstellungLocation.NETZWERKWEIT) {
            valid = (this.style & 0x1000) != 0;
        }
        this.getButton(0).setEnabled(valid);
        if (valid) {
            this.setErrorMessage(null);
        } else {
            this.setErrorMessage("Sie sind nicht berechtigt, Einstellungen an dieser Position zu speichern");
        }
    }

    protected void cancelPressed() {
        this.speicherKey = null;
        super.cancelPressed();
    }

    protected Control createDialogArea(Composite parent) {
        this.userAdmin = RahmenwerkUtil.isUserAdmin();
        if ((this.style & 0x2000) != 0) {
            this.getShell().setText("Sichern");
            this.setTitle("Men\u00fcstruktur sichern");
            this.setMessage("W\u00e4hlen Sie das entsprechende Ziel aus!");
        } else {
            this.getShell().setText("Laden");
            this.setTitle("Men\u00fcstruktur laden");
            this.setMessage("W\u00e4hlen Sie die entsprechende Quelle aus!");
        }
        this.setTitleImage(RahmenwerkActivator.getDefault().getImage("icons/wizban/bitctrl_wizard.png"));
        Composite panel = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)panel);
        panel.setLayout((Layout)new GridLayout(2, false));
        this.erzeugeGruppeAuswahlOrt(panel);
        this.erzeugeGruppeAuswahlSubjekt(panel);
        return panel;
    }

    protected Control createButtonBar(Composite parent) {
        Control result = super.createButtonBar(parent);
        this.validateSpeicherKey();
        return result;
    }

    private void erzeugeGruppeAuswahlOrt(Composite parent) {
        this.locationGroup = new Group(parent, 0);
        this.locationGroup.setText("Auswahl Speicherort:");
        this.locationGroup.setLayout((Layout)new GridLayout());
        this.locationGroup.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        Button button = new Button((Composite)this.locationGroup, 16);
        button.setText("Netzweit");
        button.setEnabled(this.online);
        button.setSelection(this.speicherKey.getLocation() == EinstellungLocation.NETZWERKWEIT);
        button.setData((Object)EinstellungLocation.NETZWERKWEIT);
        button.addSelectionListener((SelectionListener)new SpeicherInfoUpdater());
        button = new Button((Composite)this.locationGroup, 16);
        button.setText("Lokal");
        button.setSelection(this.speicherKey.getLocation() == EinstellungLocation.LOKAL);
        button.setData((Object)EinstellungLocation.LOKAL);
        button.addSelectionListener((SelectionListener)new SpeicherInfoUpdater());
    }

    private void erzeugeGruppeAuswahlSubjekt(Composite panel) {
        GridData gridDataAuswahlSubjekt = new GridData();
        gridDataAuswahlSubjekt.horizontalAlignment = 4;
        gridDataAuswahlSubjekt.grabExcessHorizontalSpace = true;
        gridDataAuswahlSubjekt.grabExcessVerticalSpace = true;
        gridDataAuswahlSubjekt.verticalAlignment = 4;
        this.ownerGroup = new Group(panel, 0);
        this.ownerGroup.setLayout((Layout)new GridLayout());
        this.ownerGroup.setText("Auswahl Subjekt:");
        this.ownerGroup.setLayoutData((Object)gridDataAuswahlSubjekt);
        Button button = new Button((Composite)this.ownerGroup, 16);
        button.setText("Allgemein");
        button.setData((Object)EinstellungOwnerType.SYSTEM);
        button.setSelection(this.speicherKey.getOwnerType() == EinstellungOwnerType.SYSTEM);
        button.addSelectionListener((SelectionListener)new SpeicherInfoUpdater());
        button = new Button((Composite)this.ownerGroup, 16);
        button.setText("Benutzer");
        button.setEnabled(this.online);
        button.setData((Object)EinstellungOwnerType.BENUTZER);
        button.setSelection(this.speicherKey.getOwnerType() == EinstellungOwnerType.BENUTZER);
        button.addSelectionListener((SelectionListener)new SpeicherInfoUpdater());
        Label label = new Label(panel, 0);
        label.setText("Benutzerauswahl:");
        label.setEnabled(this.online);
        this.benutzerAuswahl = new ComboViewer(panel);
        this.benutzerAuswahl.setContentProvider((IContentProvider)new ArrayContentProvider());
        if (this.benutzer != null) {
            ArrayList<SystemObject> benutzerListe = new ArrayList<SystemObject>();
            if (this.userAdmin) {
                benutzerListe.addAll(RahmenwerkImpl.getInstanz().getDavVerbindung().getDataModel().getType("typ.benutzer").getElements());
            } else {
                benutzerListe.add(this.benutzer);
            }
            this.benutzerAuswahl.setInput((Object)benutzerListe.toArray());
            this.benutzerAuswahl.setSelection((ISelection)new StructuredSelection((Object)this.benutzer));
        } else {
            this.benutzerAuswahl.getControl().setEnabled(false);
        }
        this.benutzerAuswahl.addSelectionChangedListener((ISelectionChangedListener)new SpeicherInfoUpdater());
    }

    public SpeicherKey getSpeicherKey() {
        return this.speicherKey;
    }

    private void updateSpeicherInfo() {
        Object element;
        EinstellungLocation location = EinstellungLocation.LOKAL;
        Control[] controlArray = this.locationGroup.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            Object data = control.getData();
            if (data instanceof EinstellungLocation && control instanceof Button && ((Button)control).getSelection()) {
                location = (EinstellungLocation)data;
            }
            ++n2;
        }
        EinstellungOwnerType ownerType = EinstellungOwnerType.SYSTEM;
        Control[] controlArray2 = this.ownerGroup.getChildren();
        int n3 = controlArray2.length;
        n = 0;
        while (n < n3) {
            Control control = controlArray2[n];
            Object data = control.getData();
            if (data instanceof EinstellungOwnerType && control instanceof Button && ((Button)control).getSelection()) {
                ownerType = (EinstellungOwnerType)data;
            }
            ++n;
        }
        String benutzerPid = null;
        if (ownerType == EinstellungOwnerType.BENUTZER && (element = ((IStructuredSelection)this.benutzerAuswahl.getSelection()).getFirstElement()) instanceof SystemObject) {
            benutzerPid = ((SystemObject)element).getPid();
        }
        this.speicherKey = new SpeicherKey(ownerType, location, benutzerPid);
        this.validateSpeicherKey();
    }

    public static enum EnumDialogSpeichernLaden {
        speichern,
        laden;

    }

    private class SpeicherInfoUpdater
    extends SelectionAdapter
    implements ISelectionChangedListener {
        private SpeicherInfoUpdater() {
        }

        public void widgetSelected(SelectionEvent e) {
            LadeSpeicherDialogMenu.this.updateSpeicherInfo();
        }

        public void selectionChanged(SelectionChangedEvent event) {
            LadeSpeicherDialogMenu.this.updateSpeicherInfo();
        }
    }
}

