/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.rw.menu;

import de.bsvrz.buv.rw.rw.internal.RahmenwerkImpl;
import de.bsvrz.buv.rw.rw.menu.AbstractMenueLeiste;
import de.bsvrz.buv.rw.rw.menu.MenueAction;
import de.bsvrz.buv.rw.rw.menu.MenueElement;
import de.bsvrz.buv.rw.rw.menu.MenueSeparator;
import de.bsvrz.buv.rw.rw.menu.RwToolbarElement;
import de.bsvrz.buv.rw.rw.menu.RwToolbarElementManagerImpl;
import de.bsvrz.buv.rw.rw.menu.SubMenue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.services.IServiceLocator;

public class MenuGenerator {
    private final IContributionManager contributionManager;
    private final AbstractMenueLeiste menueLeiste;

    public MenuGenerator(IContributionManager contributionManager, AbstractMenueLeiste menueLeiste) {
        this.contributionManager = contributionManager;
        this.menueLeiste = menueLeiste;
    }

    public final void generiereMenu(IServiceLocator serviceLocator) {
        RwToolbarElementManagerImpl elementManager = RahmenwerkImpl.getInstanz().getRwToolBarManager();
        this.contributionManager.removeAll();
        for (MenueElement child : this.menueLeiste.getElemente()) {
            if (this.contributionManager instanceof IMenuManager) {
                this.generiereMenuRekursiv(serviceLocator, this.contributionManager, child);
                continue;
            }
            if (this.contributionManager instanceof IToolBarManager) {
                this.generiereToolbarRekursiv(serviceLocator, this.contributionManager, child);
                elementManager.getSymbolLeisteManager().update(true);
                continue;
            }
            if (!(this.contributionManager instanceof IStatusLineManager)) continue;
            this.generiereStatusLeisteRekursiv(serviceLocator, this.contributionManager, child);
        }
        this.contributionManager.update(true);
    }

    private void generiereMenuRekursiv(IServiceLocator serviceLocator, IContributionManager parentManager, MenueElement element) {
        if (element instanceof MenueAction) {
            String tempId = ((MenueAction)element).getActionId();
            RwToolbarElementManagerImpl elementManager = RahmenwerkImpl.getInstanz().getRwToolBarManager();
            RwToolbarElement descriptorAction = elementManager.getToolBarElement(tempId);
            if (descriptorAction != null) {
                try {
                    parentManager.add(descriptorAction.createContributionItem(serviceLocator, (MenueAction)element));
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        } else if (element instanceof MenueSeparator) {
            Separator separator = new Separator();
            parentManager.add((IContributionItem)separator);
        } else if (element instanceof SubMenue) {
            String tempSubmenuName = ((SubMenue)element).getName();
            MenuManager tempSubmenu = new MenuManager(tempSubmenuName);
            parentManager.add((IContributionItem)tempSubmenu);
            for (MenueElement child : ((SubMenue)element).getElemente()) {
                this.generiereMenuRekursiv(serviceLocator, (IContributionManager)tempSubmenu, child);
            }
        }
    }

    private void generiereToolbarRekursiv(IServiceLocator serviceLocator, IContributionManager parentManager, MenueElement element) {
        if (element instanceof MenueAction) {
            String tempId = ((MenueAction)element).getActionId();
            RwToolbarElementManagerImpl elementManager = RahmenwerkImpl.getInstanz().getRwToolBarManager();
            RwToolbarElement descriptorAction = elementManager.getToolBarElement(tempId);
            if (descriptorAction != null) {
                try {
                    IContributionItem item = descriptorAction.createContributionItem(serviceLocator, (MenueAction)element);
                    parentManager.add(item);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        } else if (element instanceof MenueSeparator) {
            Separator separator = new Separator();
            parentManager.add((IContributionItem)separator);
        } else if (element instanceof SubMenue) {
            ToolBarSubMenue item = new ToolBarSubMenue(new ToolbarMenueAction(serviceLocator, (SubMenue)element));
            parentManager.add((IContributionItem)item);
        }
    }

    private void generiereStatusLeisteRekursiv(IServiceLocator serviceLocator, IContributionManager parentManager, MenueElement element) {
        if (element instanceof MenueAction) {
            String tempId = ((MenueAction)element).getActionId();
            RwToolbarElementManagerImpl elementManager = RahmenwerkImpl.getInstanz().getRwToolBarManager();
            RwToolbarElement descriptorAction = elementManager.getToolBarElement(tempId);
            if (descriptorAction != null) {
                try {
                    parentManager.add(descriptorAction.createContributionItem(serviceLocator, (MenueAction)element));
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        } else if (element instanceof MenueSeparator) {
            Separator separator = new Separator();
            parentManager.add((IContributionItem)separator);
        } else if (element instanceof SubMenue) {
            ToolBarSubMenue item = new ToolBarSubMenue(new ToolbarMenueAction(serviceLocator, (SubMenue)element));
            parentManager.add((IContributionItem)item);
        }
    }

    private static class ToolBarSubMenue
    extends ContributionItem {
        private final ToolbarMenueAction action;

        ToolBarSubMenue(ToolbarMenueAction action) {
            super(action.getId());
            this.action = action;
        }

        public void fill(ToolBar parent, int index) {
            ToolItem toolItem = new ToolItem(parent, 0x800004);
            toolItem.setText(this.action.getText());
            toolItem.setWidth(0);
            toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Event event = new Event();
                    event.widget = e.widget;
                    action.runWithEvent(event);
                }
            });
        }

        public void fill(Composite parent) {
            String text = this.action.getText();
            Button button = new Button(parent, 8);
            button.setText(text);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Event event = new Event();
                    event.widget = e.widget;
                    action.runWithEvent(event);
                }
            });
        }
    }

    private class ToolbarMenueAction
    extends Action {
        ToolbarMenueAction(final IServiceLocator serviceLocator, final SubMenue element) {
            super(element.getVisibleName(), 4);
            this.setMenuCreator(new IMenuCreator(){

                public Menu getMenu(Menu parent) {
                    return null;
                }

                public Menu getMenu(Control parent) {
                    MenuManager manager = new MenuManager();
                    for (MenueElement child : element.getElemente()) {
                        MenuGenerator.this.generiereMenuRekursiv(serviceLocator, (IContributionManager)manager, child);
                    }
                    Menu menu = new Menu(parent);
                    IContributionItem[] iContributionItemArray = manager.getItems();
                    int n = iContributionItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IContributionItem item = iContributionItemArray[n2];
                        item.fill(menu, -1);
                        ++n2;
                    }
                    return menu;
                }

                public void dispose() {
                }
            });
        }

        public void runWithEvent(Event event) {
            Widget item = event.widget;
            IMenuCreator mc = this.getMenuCreator();
            if (mc != null) {
                Composite parentControl = null;
                Rectangle bounds = null;
                if (item instanceof Control) {
                    parentControl = ((Control)item).getParent();
                    bounds = ((Control)item).getBounds();
                } else if (item instanceof ToolItem) {
                    parentControl = ((ToolItem)item).getParent();
                    bounds = ((ToolItem)item).getBounds();
                }
                Menu m = mc.getMenu((Control)parentControl);
                if (m != null) {
                    Point point = parentControl.toDisplay(new Point(bounds.x, bounds.y));
                    if (parentControl instanceof ToolBar) {
                        m.setLocation(point.x, point.y + bounds.height);
                    } else {
                        m.setLocation(point.x, point.y);
                    }
                    m.setVisible(true);
                }
            }
        }
    }
}

