/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.rw.menu;

import de.bsvrz.buv.rw.rw.internal.RahmenwerkImpl;
import de.bsvrz.buv.rw.rw.menu.Menue;
import de.bsvrz.buv.rw.rw.menu.MenueAction;
import de.bsvrz.buv.rw.rw.menu.MenueSeparator;
import de.bsvrz.buv.rw.rw.menu.RwToolbarElement;
import de.bsvrz.buv.rw.rw.menu.SubMenue;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class MenuXmlHandler
extends DefaultHandler {
    public static final String TAG_STATUS_LEISTE = "statusleiste";
    public static final String TAG_SYMBOL_LEISTE = "symbolleiste";
    public static final String TAG_MENU_LEISTE = "menuleiste";
    public static final String TAG_MENU = "menu";
    public static final String TAG_SUBMENU = "submenu";
    public static final String TAG_ITEM = "item";
    public static final String TAG_PARAMETERS = "parameters";
    public static final String TAG_PARAMETER = "parameter";
    public static final String TAG_SEPARATOR = "separator";
    public static final String ATT_ID = "id";
    public static final String ATT_ACTION_ID = "actionId";
    public static final String ATT_NAME = "name";
    public static final String ATT_USERLABEL = "userLabel";
    public static final String ATT_VALUE = "value";
    private final Menue aktionsLeiste;
    private Menue currentMenu;
    private MenueAction currentAction;

    MenuXmlHandler(Menue menue) {
        this.aktionsLeiste = menue;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (TAG_ITEM.equals(qName)) {
            String id = attributes.getValue(ATT_ACTION_ID);
            RwToolbarElement deskriptorAktion = RahmenwerkImpl.getInstanz().getRwToolBarManager().getToolBarElement(id);
            MenueAction action = new MenueAction(deskriptorAktion, id, attributes.getValue(ATT_NAME));
            action.setUserLabel(attributes.getValue(ATT_USERLABEL));
            this.currentMenu.addElement(action);
            this.currentAction = action;
        } else if (TAG_PARAMETER.equals(qName)) {
            if (this.currentAction != null) {
                this.currentAction.setParameter(attributes.getValue(ATT_ID), attributes.getValue(ATT_NAME), attributes.getValue(ATT_VALUE));
            }
        } else if (!TAG_PARAMETERS.equals(qName) && !TAG_MENU.equals(qName)) {
            if (TAG_MENU_LEISTE.equals(qName)) {
                this.currentMenu = this.aktionsLeiste;
            } else if (TAG_SYMBOL_LEISTE.equals(qName)) {
                this.currentMenu = this.aktionsLeiste;
            } else if (TAG_STATUS_LEISTE.equals(qName)) {
                this.currentMenu = this.aktionsLeiste;
            } else if (TAG_SEPARATOR.equals(qName)) {
                MenueSeparator separator = new MenueSeparator();
                this.currentMenu.addElement(separator);
            } else if (TAG_SUBMENU.equals(qName)) {
                SubMenue subMenu = new SubMenue(attributes.getValue(ATT_NAME));
                this.currentMenu.addElement(subMenu);
                this.currentMenu = subMenu;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (TAG_SUBMENU.equals(qName)) {
            if (this.currentMenu != null) {
                this.currentMenu = this.currentMenu.getMenue();
            }
        } else if (TAG_ITEM.equals(qName)) {
            this.currentAction = null;
        }
    }
}

