/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.rw.menu;

import de.bsvrz.buv.rw.rw.menu.MenueElement;
import de.bsvrz.buv.rw.rw.menu.NamedMenueElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class Menue
extends NamedMenueElement {
    private final List<MenueElement> elemente = new ArrayList<MenueElement>();

    public void addElement(MenueElement element) {
        this.elemente.add(element);
        element.setMenue(this);
        this.setDirty();
    }

    public void addElementBefore(MenueElement element, MenueElement relative) {
        int index = Math.max(0, this.elemente.indexOf(relative));
        this.elemente.add(index, element);
        element.setMenue(this);
        this.setDirty();
    }

    public void addElementAfter(MenueElement element, MenueElement relative) {
        int index = this.elemente.indexOf(relative);
        if (index < 0 || index >= this.elemente.size()) {
            this.elemente.add(element);
            element.setMenue(this);
        } else {
            this.elemente.add(index + 1, element);
            element.setMenue(this);
        }
        this.setDirty();
    }

    public void removeElement(MenueElement element) {
        this.elemente.remove(element);
        element.setMenue(null);
        this.setDirty();
    }

    public List<MenueElement> getElemente() {
        return Collections.unmodifiableList(this.elemente);
    }

    protected void setDirty() {
        Menue menue = this.getMenue();
        if (menue != null) {
            menue.setDirty();
        }
    }

    @Override
    public MenueElement createDeepCopy() {
        Menue menue = this.createMenuCopy();
        for (MenueElement element : this.elemente) {
            menue.addElement(element.createDeepCopy());
        }
        return menue;
    }

    protected abstract Menue createMenuCopy();
}

