/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.rw.menu;

import de.bsvrz.buv.rw.rw.menu.Menue;
import de.bsvrz.buv.rw.rw.menu.MenueElement;
import de.bsvrz.buv.rw.rw.menu.NamedMenueElement;
import de.bsvrz.buv.rw.rw.menu.RwToolbarElement;
import de.bsvrz.buv.rw.rw.menu.RwToolbarElementParameter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MenueAction
extends NamedMenueElement {
    private Menue menue;
    private final String actionId;
    private String userLabel;
    private final Map<String, Parameter> parameter = new HashMap<String, Parameter>();
    private final String name;
    private final RwToolbarElement vorlage;

    public MenueAction(RwToolbarElement vorlage, String actionId, String name) {
        this.vorlage = vorlage;
        this.actionId = actionId;
        this.name = name;
    }

    @Override
    protected void addXmlNode(Document document, Element root) {
        Element element = document.createElement("item");
        element.setAttribute("actionId", this.getActionId());
        element.setAttribute("name", this.getName());
        if (this.userLabel != null && !this.userLabel.isEmpty()) {
            element.setAttribute("userLabel", this.getUserLabel());
        }
        if (!this.parameter.isEmpty()) {
            Element parametersNode = document.createElement("parameters");
            element.appendChild(parametersNode);
            for (Parameter item : this.parameter.values()) {
                Element parameterNode = document.createElement("parameter");
                parameterNode.setAttribute("id", item.getParameterId());
                parameterNode.setAttribute("name", item.getName());
                String value = item.getValue();
                if (value != null) {
                    parameterNode.setAttribute("value", value);
                }
                parametersNode.appendChild(parameterNode);
            }
        }
        root.appendChild(element);
    }

    @Override
    public MenueElement createDeepCopy() {
        MenueAction copy = new MenueAction(this.vorlage, this.actionId, this.name);
        copy.setUserLabel(this.userLabel);
        for (Parameter param : this.parameter.values()) {
            copy.setParameter(param.getParameterId(), param.getName(), param.getValue());
        }
        return copy;
    }

    public String getActionId() {
        return this.actionId;
    }

    public String getDescription() {
        if (this.userLabel != null && !this.userLabel.isEmpty()) {
            return this.userLabel;
        }
        return this.name;
    }

    @Override
    public Menue getMenue() {
        return this.menue;
    }

    public String getName() {
        return this.name;
    }

    public Collection<Parameter> getParameters() {
        HashMap<String, Parameter> resultMap = new HashMap<String, Parameter>();
        if (this.vorlage != null) {
            for (Map.Entry<String, RwToolbarElementParameter> entry : this.vorlage.getParameters().entrySet()) {
                resultMap.put(entry.getKey(), new Parameter(entry.getKey(), entry.getValue().getName(), entry.getValue().getDefaultValue()));
            }
        }
        resultMap.putAll(this.parameter);
        return Collections.unmodifiableCollection(resultMap.values());
    }

    public String getUserLabel() {
        return this.userLabel;
    }

    @Override
    public String getVisibleName() {
        String result = this.getUserLabel();
        if (result == null) {
            return this.getName();
        }
        return result;
    }

    private void setDirty() {
        if (this.menue != null) {
            this.menue.setDirty();
        }
    }

    @Override
    public void setMenue(Menue menue) {
        this.menue = menue;
    }

    public void setParameter(String id, String parameterName, String value) {
        this.parameter.put(id, new Parameter(id, parameterName, value));
    }

    public void setUserLabel(String userLabel) {
        this.userLabel = userLabel;
        this.setDirty();
    }

    @Override
    public void setVisibleName(String visibleName) {
        this.setUserLabel(visibleName);
    }

    public String toString() {
        return this.getDescription();
    }

    public boolean isAvailable() {
        return this.vorlage != null;
    }

    public final class Parameter {
        private final String parameterId;
        private final String parameterName;
        private String value;

        private Parameter(String id, String name, String value) {
            this.parameterId = id;
            this.parameterName = name;
            this.value = value;
            if (this.value == null) {
                this.value = "";
            }
        }

        public String getParameterId() {
            if (this.parameterId == null || this.parameterId.isEmpty()) {
                return this.parameterName;
            }
            return this.parameterId;
        }

        public String getName() {
            return this.parameterName;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value == null ? "" : value;
            MenueAction.this.setDirty();
        }
    }
}

