/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.rw.menu;

import de.bsvrz.buv.rw.rw.menu.MenueAction;
import de.bsvrz.buv.rw.rw.menu.RwToolbarElementParameter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.ui.services.IServiceLocator;
import org.osgi.framework.Bundle;

public abstract class RwToolbarElement {
    static final String ATT_ID = "id";
    static final String ATT_NAME = "name";
    static final String ATT_LABEL = "label";
    private final IConfigurationElement configuration;
    private final Map<String, RwToolbarElementParameter> parameters = new HashMap<String, RwToolbarElementParameter>();

    public RwToolbarElement(IConfigurationElement configuration) {
        this.configuration = configuration;
    }

    protected void addParameter(RwToolbarElementParameter parameter) {
        this.parameters.put(parameter.getId(), parameter);
    }

    public abstract IContributionItem createContributionItem(IServiceLocator var1, MenueAction var2) throws CoreException;

    public String getBeschreibung() {
        return this.getName();
    }

    public String getBundleName() {
        Bundle bundle = Platform.getBundle((String)this.getPluginId());
        return (String)bundle.getHeaders().get("Bundle-Name");
    }

    protected IConfigurationElement getConfiguration() {
        return this.configuration;
    }

    public String getId() {
        return this.configuration.getAttribute(ATT_ID);
    }

    public String getName() {
        String result = this.configuration.getAttribute(ATT_LABEL);
        if (result == null) {
            result = this.configuration.getAttribute(ATT_NAME);
        }
        if (result == null) {
            return this.getId();
        }
        return result;
    }

    public Map<String, RwToolbarElementParameter> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public String getPluginId() {
        return this.configuration.getContributor().getName();
    }

    public String toString() {
        return String.valueOf(this.getName()) + "(" + this.getId() + ")";
    }
}

