/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.rw.menu;

import de.bsvrz.buv.rw.basislib.menu.RwToolBarManager;
import de.bsvrz.buv.rw.rw.menu.RwToolbarAction;
import de.bsvrz.buv.rw.rw.menu.RwToolbarCommand;
import de.bsvrz.buv.rw.rw.menu.RwToolbarControl;
import de.bsvrz.buv.rw.rw.menu.RwToolbarElement;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Inject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;

public final class RwToolbarElementManagerImpl
implements RwToolBarManager {
    private static final Debug LOGGER = Debug.getLogger();
    private IMenuManager menuManager;
    private ICoolBarManager symbolLeisteManager;
    private final Map<String, RwToolbarElement> toolbarElemente = new TreeMap<String, RwToolbarElement>();
    private IToolBarManager symbolLeisteToolbar;
    private IStatusLineManager statusLeisteManager;
    @Inject
    private MApplication application;

    public void init() {
        this.leseActionSets();
        this.leseCommands();
        this.leseToolbarElemente();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RwToolbarElement getToolBarElement(String id) {
        Map<String, RwToolbarElement> map = this.toolbarElemente;
        synchronized (map) {
            if (this.toolbarElemente.containsKey(id)) {
                return this.toolbarElemente.get(id);
            }
            return null;
        }
    }

    public IMenuManager getMenuManager() {
        IMenuManager re = null;
        re = this.menuManager;
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RwToolbarElement> getPluginMenueElemente(String pluginID) {
        LinkedList<RwToolbarElement> actions = new LinkedList<RwToolbarElement>();
        Map<String, RwToolbarElement> map = this.toolbarElemente;
        synchronized (map) {
            for (Map.Entry<String, RwToolbarElement> entry : this.toolbarElemente.entrySet()) {
                if (!entry.getValue().getPluginId().equals(pluginID)) continue;
                actions.add(entry.getValue());
            }
        }
        return actions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getPluginIdAndNames() {
        TreeMap<String, String> tm = new TreeMap<String, String>();
        Map<String, RwToolbarElement> map = this.toolbarElemente;
        synchronized (map) {
            for (Map.Entry<String, RwToolbarElement> entry : this.toolbarElemente.entrySet()) {
                if (tm.containsKey(entry.getValue().getPluginId())) continue;
                tm.put(entry.getValue().getPluginId(), entry.getValue().getBundleName());
            }
        }
        return tm;
    }

    public IStatusLineManager getStatusLeisteManager() {
        return this.statusLeisteManager;
    }

    public ICoolBarManager getSymbolLeisteManager() {
        return this.symbolLeisteManager;
    }

    public IToolBarManager getSymbolLeisteManagerToolbar() {
        return this.symbolLeisteToolbar;
    }

    private void leseActionSets() {
        IConfigurationElement[] configElements;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = configElements = reg.getConfigurationElementsFor("org.eclipse.ui.actionSets");
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] actions;
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            IConfigurationElement[] iConfigurationElementArray2 = actions = configElement.getChildren("action");
            int n3 = actions.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement action = iConfigurationElementArray2[n4];
                this.registriereElement(new RwToolbarAction(action));
                ++n4;
            }
            ++n2;
        }
    }

    private void leseCommands() {
        IConfigurationElement[] configElements;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = configElements = reg.getConfigurationElementsFor("org.eclipse.ui.commands");
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement command = iConfigurationElementArray[n2];
            if ("command".equals(command.getName()) && command.getAttribute("name") != null) {
                this.registriereElement(new RwToolbarCommand(command));
            }
            ++n2;
        }
        this.application.getCommands();
    }

    private void leseToolbarElemente() {
        IConfigurationElement[] controls;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = controls = reg.getConfigurationElementsFor("de.bsvrz.buv.rw.basislib.toolbarcontrol");
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement control = iConfigurationElementArray[n2];
            this.registriereElement(new RwToolbarControl(control));
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registriereElement(RwToolbarElement element) {
        String aktionID = element.getId();
        Map<String, RwToolbarElement> map = this.toolbarElemente;
        synchronized (map) {
            if (!this.toolbarElemente.containsKey(aktionID)) {
                this.toolbarElemente.put(aktionID, element);
                LOGGER.finest(String.valueOf(this.getClass().getName()) + "::registriereDeskriptorAktion \n\t=> Registrierung ok -> " + aktionID);
            } else {
                LOGGER.fine("Ein Toolbarelement mit der ID \"" + aktionID + "\" wurde schon bereits registriert, Element aus " + element.getPluginId() + " wird ignoriert!");
            }
        }
    }

    public void setMenuManager(IMenuManager manager) {
        this.menuManager = manager;
    }

    public void setStatusLeisteManager(IStatusLineManager statusLeisteManager) {
        this.statusLeisteManager = statusLeisteManager;
    }

    public void setSymbolLeisteManager(ICoolBarManager manager, IToolBarManager toolbar) {
        this.symbolLeisteManager = manager;
        this.symbolLeisteToolbar = toolbar;
    }
}

