/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.rw.menu.editoren;

import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungsAdresse;
import de.bsvrz.buv.rw.basislib.einstellungen.SpeicherKey;
import de.bsvrz.buv.rw.rw.RahmenwerkActivator;
import de.bsvrz.buv.rw.rw.internal.InternalServices;
import de.bsvrz.buv.rw.rw.menu.AbstractMenueLeiste;
import de.bsvrz.buv.rw.rw.menu.LadeSpeicherDialogMenu;
import de.bsvrz.buv.rw.rw.menu.MenueAction;
import de.bsvrz.buv.rw.rw.menu.MenueElement;
import de.bsvrz.buv.rw.rw.menu.MenueLeiste;
import de.bsvrz.buv.rw.rw.menu.MenueSeparator;
import de.bsvrz.buv.rw.rw.menu.NamedMenueElement;
import de.bsvrz.buv.rw.rw.menu.StatusLeiste;
import de.bsvrz.buv.rw.rw.menu.SubMenue;
import de.bsvrz.buv.rw.rw.menu.SymbolLeiste;
import de.bsvrz.buv.rw.rw.menu.editoren.InfoBereichComposite;
import de.bsvrz.buv.rw.rw.menu.editoren.LocalViewerSelectionDragAdapter;
import de.bsvrz.buv.rw.rw.menu.editoren.MenueDndAdapter;
import de.bsvrz.buv.rw.rw.menu.editoren.MenueEditorInput;
import de.bsvrz.buv.rw.rw.menu.editoren.actions.ContextActionSeparatorEinfuegen;
import de.bsvrz.buv.rw.rw.menu.editoren.actions.ContextActionSubMenueEinfuegen;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.services.IServiceLocator;
import org.xml.sax.SAXException;

public abstract class AbstractMenueEditor
extends EditorPart
implements PropertyChangeListener {
    private TreeViewer treeViewer;
    private MenueDndAdapter dndAdapter;
    private InfoBereichComposite infoBereich;

    public void createPartControl(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)panel);
        panel.setLayout((Layout)new FillLayout());
        SashForm sash = new SashForm(panel, 512);
        this.treeViewer = new TreeViewer((Composite)sash, 2816);
        this.treeViewer.setContentProvider((IContentProvider)new MenueEditorContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new MenueEditorLabelProvider());
        this.treeViewer.setInput((Object)this.getEditorInput());
        this.treeViewer.expandAll();
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.treeViewer.getControl());
        int ops = 2;
        Transfer[] dropTransfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        this.dndAdapter = new MenueDndAdapter(this.treeViewer);
        this.treeViewer.addDropSupport(2, dropTransfers, (DropTargetListener)this.dndAdapter);
        Transfer[] dragTransfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        this.treeViewer.addDragSupport(2, dragTransfers, (DragSourceListener)new LocalViewerSelectionDragAdapter((StructuredViewer)this.treeViewer));
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractMenueEditor.this.infoBereich.updateFromSelection((IStructuredSelection)event.getSelection());
            }
        });
        this.infoBereich = new InfoBereichComposite((Composite)sash, 0);
        GridDataFactory.fillDefaults().grab(true, false).hint(-1, 150).applyTo((Control)this.infoBereich);
        this.infoBereich.updateFromSelection((IStructuredSelection)this.treeViewer.getSelection());
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        sash.setWeights(new int[]{70, 30});
        this.registerKontextMenu();
        this.registerActionBars();
    }

    private void registerKontextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                AbstractMenueEditor.this.fuelleKontextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.treeViewer);
    }

    @PostConstruct
    private void fuelleKontextMenu(@Optional IMenuManager manager) {
        manager.add((IAction)new Action("Laden"){

            public void run() {
                AbstractMenueEditor.this.ladeMenuleiste();
            }
        });
        CommandContributionItemParameter parameter = new CommandContributionItemParameter((IServiceLocator)this.getEditorSite().getWorkbenchWindow(), null, "org.eclipse.ui.file.save", 8);
        manager.add((IContributionItem)new CommandContributionItem(parameter));
        manager.add((IContributionItem)new Separator());
        parameter = new CommandContributionItemParameter((IServiceLocator)this.getEditorSite().getWorkbenchWindow(), null, "org.eclipse.ui.file.export", 8);
        manager.add((IContributionItem)new CommandContributionItem(parameter));
        parameter = new CommandContributionItemParameter((IServiceLocator)this.getEditorSite().getWorkbenchWindow(), null, "org.eclipse.ui.file.import", 8);
        manager.add((IContributionItem)new CommandContributionItem(parameter));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new MenueAktivierenAction());
        manager.add((IContributionItem)new Separator());
        parameter = new CommandContributionItemParameter((IServiceLocator)this.getEditorSite().getWorkbenchWindow(), null, "org.eclipse.ui.edit.cut", 8);
        manager.add((IContributionItem)new CommandContributionItem(parameter));
        parameter = new CommandContributionItemParameter((IServiceLocator)this.getEditorSite().getWorkbenchWindow(), null, "org.eclipse.ui.edit.copy", 8);
        manager.add((IContributionItem)new CommandContributionItem(parameter));
        parameter = new CommandContributionItemParameter((IServiceLocator)this.getEditorSite().getWorkbenchWindow(), null, "org.eclipse.ui.edit.paste", 8);
        manager.add((IContributionItem)new CommandContributionItem(parameter));
        manager.add((IAction)new ContextActionSubMenueEinfuegen(this.treeViewer));
        manager.add((IAction)new MenueElementUmbenennenAction((IStructuredSelection)this.treeViewer.getSelection()));
        manager.add((IAction)new MenueActionResetNameAction((IStructuredSelection)this.treeViewer.getSelection()));
        manager.add((IAction)new ContextActionSeparatorEinfuegen(this.treeViewer));
        parameter = new CommandContributionItemParameter((IServiceLocator)this.getEditorSite().getWorkbenchWindow(), null, "org.eclipse.ui.edit.delete", 8);
        manager.add((IContributionItem)new CommandContributionItem(parameter));
    }

    protected abstract String getMenueName();

    private ImageDescriptor getImageDescriptor(String imagePath) {
        return RahmenwerkActivator.getDefault().getImageDescriptor(imagePath);
    }

    public abstract String getEinstellungsId();

    private void ladeMenuleiste() {
        LadeSpeicherDialogMenu dialog = new LadeSpeicherDialogMenu(this.getSite().getShell(), 4096);
        if (dialog.open() == 0) {
            SpeicherKey speicherKey = dialog.getSpeicherKey();
            this.menueLeisteLaden(speicherKey);
        }
    }

    public void menueLeisteLaden(SpeicherKey speicherKey) {
        EinstellungsAdresse adresse = new EinstellungsAdresse(null, this.getEinstellungsId(), speicherKey.getOwnerType(), speicherKey.getPid(), speicherKey.getLocation());
        String parameter = null;
        try {
            parameter = (String)InternalServices.getInstance().getEinstellungen().getValue(adresse);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (parameter != null && parameter.length() > 0) {
            try {
                MenueEditorInput input = this.createInput(parameter);
                this.setInput(input);
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
        }
    }

    public MenueEditorInput getEditorInput() {
        return (MenueEditorInput)super.getEditorInput();
    }

    public void setInput(IEditorInput input) {
        MenueEditorInput oldInput = this.getEditorInput();
        if (oldInput != null) {
            oldInput.getMenueLeiste().removePropertyChangeListener(this);
        }
        if (input instanceof MenueEditorInput) {
            super.setInput(input);
            if (this.treeViewer != null) {
                this.treeViewer.setInput((Object)input);
                this.treeViewer.expandAll();
            }
            ((MenueEditorInput)input).getMenueLeiste().addPropertyChangeListener(this);
        }
    }

    public abstract MenueEditorInput createInput(String var1) throws ParserConfigurationException, SAXException, IOException;

    public abstract MenueEditorInput createInput(InputStream var1) throws ParserConfigurationException, SAXException, IOException;

    protected abstract void aktiviereMenu();

    public void setFocus() {
        if (this.treeViewer != null && !this.treeViewer.getControl().isDisposed()) {
            this.treeViewer.getControl().setFocus();
        }
    }

    private void registerActionBars() {
        CommandContributionItemParameter parameter;
        IToolBarManager toolBarManager = this.getEditorSite().getActionBars().getToolBarManager();
        if (toolBarManager.find("org.eclipse.ui.file.save") == null) {
            parameter = new CommandContributionItemParameter((IServiceLocator)this.getEditorSite().getWorkbenchWindow(), null, "org.eclipse.ui.file.save", 8);
            toolBarManager.add((IContributionItem)new CommandContributionItem(parameter));
        }
        if (toolBarManager.find("org.eclipse.ui.edit.cut") == null) {
            parameter = new CommandContributionItemParameter((IServiceLocator)this.getEditorSite().getWorkbenchWindow(), null, "org.eclipse.ui.edit.cut", 8);
            toolBarManager.add((IContributionItem)new CommandContributionItem(parameter));
        }
        if (toolBarManager.find("org.eclipse.ui.edit.copy") == null) {
            parameter = new CommandContributionItemParameter((IServiceLocator)this.getEditorSite().getWorkbenchWindow(), null, "org.eclipse.ui.edit.copy", 8);
            toolBarManager.add((IContributionItem)new CommandContributionItem(parameter));
        }
        if (toolBarManager.find("org.eclipse.ui.edit.paste") == null) {
            parameter = new CommandContributionItemParameter((IServiceLocator)this.getEditorSite().getWorkbenchWindow(), null, "org.eclipse.ui.edit.paste", 8);
            toolBarManager.add((IContributionItem)new CommandContributionItem(parameter));
        }
        if (toolBarManager.find("org.eclipse.ui.edit.delete") == null) {
            parameter = new CommandContributionItemParameter((IServiceLocator)this.getEditorSite().getWorkbenchWindow(), null, "org.eclipse.ui.edit.delete", 8);
            toolBarManager.add((IContributionItem)new CommandContributionItem(parameter));
        }
        if (toolBarManager.find("org.eclipse.ui.file.export") == null) {
            parameter = new CommandContributionItemParameter((IServiceLocator)this.getEditorSite().getWorkbenchWindow(), null, "org.eclipse.ui.file.export", 8);
            toolBarManager.add((IContributionItem)new CommandContributionItem(parameter));
        }
        if (toolBarManager.find("org.eclipse.ui.file.import") == null) {
            parameter = new CommandContributionItemParameter((IServiceLocator)this.getEditorSite().getWorkbenchWindow(), null, "org.eclipse.ui.file.import", 8);
            toolBarManager.add((IContributionItem)new CommandContributionItem(parameter));
        }
        toolBarManager.update(true);
    }

    public void doSave(IProgressMonitor monitor) {
        LadeSpeicherDialogMenu dialog = new LadeSpeicherDialogMenu(this.getSite().getShell(), 8192);
        if (dialog.open() == 0) {
            SpeicherKey key = dialog.getSpeicherKey();
            try {
                EinstellungsAdresse adresse = new EinstellungsAdresse(null, this.getEinstellungsId(), key.getOwnerType(), key.getPid(), key.getLocation());
                AbstractMenueLeiste menueLeiste = this.getEditorInput().getMenueLeiste();
                if (menueLeiste.isEmpty()) {
                    InternalServices.getInstance().getEinstellungen().setValue(adresse, null);
                } else {
                    String xmlStruktur = menueLeiste.getXmlFormat();
                    InternalServices.getInstance().getEinstellungen().setValue(adresse, (Object)xmlStruktur);
                }
                menueLeiste.clean();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (TransformerException e) {
                e.printStackTrace();
            }
        }
    }

    public void doSaveAs() {
        this.doSave((IProgressMonitor)new NullProgressMonitor());
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(input.getName());
    }

    public boolean isDirty() {
        return this.getEditorInput().getMenueLeiste().isDirty();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("dirty")) {
            this.firePropertyChange(257);
            if (((Boolean)evt.getNewValue()).booleanValue()) {
                this.treeViewer.refresh();
            }
        }
    }

    private static class MenueActionResetNameAction
    extends Action {
        private MenueAction menueElement;

        MenueActionResetNameAction(IStructuredSelection selection) {
            Object element;
            this.setText("Name zur\u00fccksetzen");
            this.setToolTipText("Setzt den vom Nutzer \u00fcberschriebenen Name zur\u00fcck.");
            if (selection.size() == 1 && (element = selection.getFirstElement()) instanceof MenueAction && ((MenueAction)element).getUserLabel() != null) {
                this.menueElement = (MenueAction)element;
            }
            this.setEnabled(this.menueElement != null);
        }

        public void run() {
            this.menueElement.setUserLabel(null);
        }
    }

    private final class MenueAktivierenAction
    extends Action {
        MenueAktivierenAction() {
            this.setText("Aktiviere aktuelle Men\u00fcstruktur");
            this.setToolTipText("Aktiviert die aktuell dargestellte Men\u00fcstruktur.");
            this.setImageDescriptor(AbstractMenueEditor.this.getImageDescriptor("icons/etool16/refresh.gif"));
        }

        public void run() {
            AbstractMenueEditor.this.aktiviereMenu();
        }
    }

    private static class MenueEditorContentProvider
    implements ITreeContentProvider {
        private MenueEditorContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            ArrayList<MenueElement> result = new ArrayList<MenueElement>();
            if (parentElement instanceof MenueEditorInput) {
                result.add(((MenueEditorInput)parentElement).getMenueLeiste());
            } else if (parentElement instanceof AbstractMenueLeiste) {
                result.addAll(((AbstractMenueLeiste)parentElement).getElemente());
            } else if (parentElement instanceof SubMenue) {
                result.addAll(((SubMenue)parentElement).getElemente());
            }
            return result.toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class MenueEditorLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private MenueEditorLabelProvider() {
        }

        public String getText(Object element) {
            String result = null;
            if (element instanceof StatusLeiste) {
                result = "Statusleiste";
            } else if (element instanceof MenueLeiste) {
                result = "Men\u00fcleiste";
            } else if (element instanceof SymbolLeiste) {
                result = "Symbolleiste";
            } else if (element instanceof SubMenue) {
                result = ((SubMenue)element).getName();
            } else if (element instanceof MenueAction) {
                result = ((MenueAction)element).getDescription();
            } else if (element instanceof MenueSeparator) {
                result = "----------------------------------";
            }
            if (result == null) {
                return "unbekanntes Element";
            }
            return result;
        }

        public Image getImage(Object element) {
            String iconPfad = null;
            if (element instanceof MenueLeiste) {
                iconPfad = "icons/obj16/menu.gif";
            } else if (element instanceof MenueLeiste) {
                iconPfad = "icons/obj16/menubar.gif";
            } else if (element instanceof SubMenue) {
                iconPfad = "icons/obj16/menusubmenu.png";
            } else if (element instanceof MenueAction) {
                String id = ((MenueAction)element).getActionId();
                Image commandImage = RahmenwerkActivator.getDefault().findCommandImage(id);
                if (commandImage != null) {
                    return commandImage;
                }
                iconPfad = "icons/obj16/menuitem.gif";
            } else {
                iconPfad = element instanceof MenueSeparator ? "icons/obj16/menuseparator.gif" : "icons/obj16/menu.gif";
            }
            return RahmenwerkActivator.getDefault().getImage(iconPfad);
        }

        public Color getForeground(Object element) {
            if (element instanceof MenueAction && !((MenueAction)element).isAvailable()) {
                return Display.getDefault().getSystemColor(3);
            }
            return null;
        }

        public Color getBackground(Object element) {
            if (element instanceof MenueAction && !((MenueAction)element).isAvailable()) {
                return Display.getDefault().getSystemColor(15);
            }
            return null;
        }
    }

    private class MenueElementUmbenennenAction
    extends Action {
        private NamedMenueElement menueElement;

        MenueElementUmbenennenAction(IStructuredSelection selection) {
            Object element;
            this.setText("Element umbenennen");
            this.setToolTipText("Benennt das aktuell selektierte Element um.");
            if (selection.size() == 1 && (element = selection.getFirstElement()) instanceof NamedMenueElement && ((NamedMenueElement)element).getMenue() != null) {
                this.menueElement = (NamedMenueElement)element;
            }
            this.setEnabled(this.menueElement != null);
        }

        public void run() {
            InputDialog eingabeDialog;
            String oldName = this.menueElement.getVisibleName();
            if (oldName != null && (eingabeDialog = new InputDialog(AbstractMenueEditor.this.getSite().getShell(), "Element umbenennen:", "Bitte geben Sie einen neuen Namen f\u00fcr das Element\"" + oldName + "\" ein.", oldName, new IInputValidator(){

                public String isValid(String newText) {
                    if (newText.trim().isEmpty()) {
                        return "Der Name darf nicht leer sein!";
                    }
                    return null;
                }
            })).open() == 0) {
                this.menueElement.setVisibleName(eingabeDialog.getValue());
            }
        }
    }
}

