/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.rw.perspective;

import de.bsvrz.buv.rw.rw.RahmenwerkActivator;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import javax.annotation.PostConstruct;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.osgi.framework.Bundle;

public class RwInfoView {
    public static final String VIEW_ID = "de.bsvrz.buv.rw.rw.view.rahmenwerkinfo";
    private static final String PLACEHOLDER = "___PLACEHOLDER____";
    private static final String ERROR_TEXT = "Oops, it happened something unexpected<br>Send a message to <a href=\"mailto:support@bitctrl.de\">support@bitctrl.de</a><p>___PLACEHOLDER____</p>";
    private Browser browser;

    @PostConstruct
    public void createPartControl(Composite parent) {
        this.browser = new Browser(parent, 0);
        Bundle bundle = RahmenwerkActivator.getDefault().getBundle();
        URL fileURL = bundle.getEntry("/assets/infotext.html");
        if (fileURL == null) {
            String errorMsg = ERROR_TEXT.replace(PLACEHOLDER, "File assets/infotext.html nicht gefunden!");
            this.browser.setText(errorMsg);
        } else {
            try {
                URL url = FileLocator.resolve((URL)fileURL);
                this.browser.setUrl(url.toString());
            }
            catch (IOException e) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter writer = new PrintWriter(stringWriter);
                e.printStackTrace(writer);
                String errorMsg = ERROR_TEXT.replace(PLACEHOLDER, stringWriter.getBuffer());
                this.browser.setText(errorMsg);
                writer.close();
            }
        }
    }

    @Focus
    public void setFocus() {
        if (this.browser != null && !this.browser.isDisposed()) {
            this.browser.setFocus();
        }
    }
}

