/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.rw.printing;

import de.bsvrz.buv.rw.rw.RahmenwerkActivator;
import de.bsvrz.buv.rw.rw.printing.PageNumberFormatErweitert;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.regex.Matcher;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.nebula.paperclips.core.LinePrint;
import org.eclipse.nebula.paperclips.core.PaperClips;
import org.eclipse.nebula.paperclips.core.Print;
import org.eclipse.nebula.paperclips.core.PrintJob;
import org.eclipse.nebula.paperclips.core.grid.DefaultGridLook;
import org.eclipse.nebula.paperclips.core.grid.GridLook;
import org.eclipse.nebula.paperclips.core.grid.GridPrint;
import org.eclipse.nebula.paperclips.core.page.PageDecoration;
import org.eclipse.nebula.paperclips.core.page.PageNumber;
import org.eclipse.nebula.paperclips.core.page.PageNumberFormat;
import org.eclipse.nebula.paperclips.core.page.PageNumberPageDecoration;
import org.eclipse.nebula.paperclips.core.page.PagePrint;
import org.eclipse.nebula.paperclips.core.text.TextPrint;
import org.eclipse.nebula.paperclips.widgets.PrintPreview;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class DruckvorschauDialog
extends Dialog {
    private final Display display = Display.getDefault();
    private PrintJob printJob;
    private Shell shell;
    private Button schaltflaecheVorhergehendeSeite;
    private Label labelSeitenNummer;
    private Button schaltflaecheNachfolgendeSeite;
    private ScrolledComposite verschiebbaresComposite;
    private PrintPreview druckVorschau;
    private double[] verschiebePosition;

    public DruckvorschauDialog(Shell parent) {
        super(parent, 0);
    }

    public boolean oeffne(PagePrint page, String druckauftrag) {
        if (page != null) {
            PagePrint erweitertePage = this.erweiterePage(page, druckauftrag);
            this.printJob = new PrintJob(druckauftrag, (Print)erweitertePage).setMargins(72);
        }
        this.erzeugeShell();
        this.shell.open();
        Display parentDisplay = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (parentDisplay.readAndDispatch()) continue;
            parentDisplay.sleep();
        }
        return true;
    }

    private Shell erzeugeShell() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setText("Druckvorschau");
        this.shell.setBounds(100, 100, 800, 600);
        this.shell.setLayout((Layout)new GridLayout(1, false));
        this.erzeugeSchaltflaechenBereich((Composite)this.shell).setLayoutData((Object)new GridData(4, 4, true, false));
        this.erzeugeVerschiebbareVorschau((Composite)this.shell).setLayoutData((Object)new GridData(4, 4, true, true));
        this.druckVorschau.setLazyPageLayout(false);
        this.display.timerExec(10, new Runnable(){

            @Override
            public void run() {
                DruckvorschauDialog.this.druckVorschau.setPrintJob(DruckvorschauDialog.this.printJob);
                DruckvorschauDialog.this.aktualisiereVorschauGroesse();
                DruckvorschauDialog.this.aktualisiereSeitenNummer();
            }
        });
        this.shell.setVisible(true);
        return this.shell;
    }

    private Control erzeugeSchaltflaechenBereich(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(16, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.schaltflaecheVorhergehendeSeite = this.erzeugeTextSchaltflaeche(composite, "<-", "Schaltet zur vorhergehenden Seite um", new Listener(){

            public void handleEvent(Event event) {
                DruckvorschauDialog.this.setVorschauSeitenIndex(DruckvorschauDialog.this.druckVorschau.getPageIndex() - DruckvorschauDialog.this.druckVorschau.getHorizontalPageCount() * DruckvorschauDialog.this.druckVorschau.getVerticalPageCount());
            }
        });
        this.labelSeitenNummer = new Label(composite, 0);
        this.schaltflaecheNachfolgendeSeite = this.erzeugeTextSchaltflaeche(composite, "->", "Schaltet auf die nachfolgende Seite um", new Listener(){

            public void handleEvent(Event event) {
                DruckvorschauDialog.this.aktionSeiteVor();
            }
        });
        this.erzeugeTextSchaltflaeche(composite, "Horiz. f\u00fcllen", "F\u00fcllt die Darstellung horizontal", new Listener(){

            public void handleEvent(Event event) {
                DruckvorschauDialog.this.druckVorschau.setFitHorizontal(true);
                DruckvorschauDialog.this.druckVorschau.setFitVertical(false);
                DruckvorschauDialog.this.sichereVerschiebePosition();
                DruckvorschauDialog.this.aktualisiereVorschauGroesse();
                DruckvorschauDialog.this.wiederherstellenVerschiebePosition();
            }
        });
        this.erzeugeTextSchaltflaeche(composite, "Vert. f\u00fcllen", "F\u00fcllt die Darstellung vertikal", new Listener(){

            public void handleEvent(Event event) {
                DruckvorschauDialog.this.druckVorschau.setFitVertical(true);
                DruckvorschauDialog.this.druckVorschau.setFitHorizontal(false);
                DruckvorschauDialog.this.sichereVerschiebePosition();
                DruckvorschauDialog.this.aktualisiereVorschauGroesse();
                DruckvorschauDialog.this.wiederherstellenVerschiebePosition();
            }
        });
        this.erzeugeTextSchaltflaeche(composite, "Opt. f\u00fcllen", "F\u00fcllt die Darstellung optimal", new Listener(){

            public void handleEvent(Event event) {
                DruckvorschauDialog.this.druckVorschau.setFitVertical(true);
                DruckvorschauDialog.this.druckVorschau.setFitHorizontal(true);
                DruckvorschauDialog.this.sichereVerschiebePosition();
                DruckvorschauDialog.this.aktualisiereVorschauGroesse();
                DruckvorschauDialog.this.wiederherstellenVerschiebePosition();
            }
        });
        this.erzeugeTextSchaltflaeche(composite, "+", "Hinein zoomen", new Listener(){

            public void handleEvent(Event event) {
                DruckvorschauDialog.this.setVorschauSkala((float)((double)DruckvorschauDialog.this.druckVorschau.getAbsoluteScale() * 1.1));
            }
        });
        this.erzeugeTextSchaltflaeche(composite, "-", "Heraus zoomen", new Listener(){

            public void handleEvent(Event event) {
                DruckvorschauDialog.this.setVorschauSkala((float)((double)DruckvorschauDialog.this.druckVorschau.getAbsoluteScale() / 1.1));
            }
        });
        this.erzeugeTextSchaltflaeche(composite, "1:1", "An Skalierung heranzoomen", new Listener(){

            public void handleEvent(Event event) {
                DruckvorschauDialog.this.setVorschauSkala(1.0f);
            }
        });
        this.erzeugeTextSchaltflaeche(composite, "Hoch", "Hochformat", new Listener(){

            public void handleEvent(Event event) {
                DruckvorschauDialog.this.printJob.setOrientation(512);
                DruckvorschauDialog.this.druckVorschau.setPrintJob(DruckvorschauDialog.this.printJob);
                DruckvorschauDialog.this.loescheVerschiebePosition();
                DruckvorschauDialog.this.aktualisiereVorschauGroesse();
                DruckvorschauDialog.this.aktualisiereSeitenNummer();
            }
        });
        this.erzeugeTextSchaltflaeche(composite, "Quer", "Querformat", new Listener(){

            public void handleEvent(Event event) {
                DruckvorschauDialog.this.printJob.setOrientation(256);
                DruckvorschauDialog.this.druckVorschau.setPrintJob(DruckvorschauDialog.this.printJob);
                DruckvorschauDialog.this.loescheVerschiebePosition();
                DruckvorschauDialog.this.aktualisiereVorschauGroesse();
                DruckvorschauDialog.this.aktualisiereSeitenNummer();
            }
        });
        this.erzeugeGrafischeSchaltflaeche(composite, "icons/etool16/print.gif", "Drucken", new Listener(){

            public void handleEvent(Event event) {
                PrintDialog dialog = new PrintDialog(DruckvorschauDialog.this.shell, 0);
                PrinterData printerData = dialog.open();
                if (printerData != null) {
                    PaperClips.print((PrintJob)DruckvorschauDialog.this.printJob, (PrinterData)printerData);
                    DruckvorschauDialog.this.druckVorschau.setPrinterData(printerData);
                }
            }
        });
        this.erzeugeLabel(composite, "Horz. Seiten:");
        this.erzeugeSeitenzaehlerSpinner(composite, new Listener(){

            public void handleEvent(Event event) {
                DruckvorschauDialog.this.druckVorschau.setHorizontalPageCount(((Spinner)event.widget).getSelection());
                DruckvorschauDialog.this.loescheVerschiebePosition();
                DruckvorschauDialog.this.aktualisiereVorschauGroesse();
                DruckvorschauDialog.this.aktualisiereSeitenNummer();
            }
        });
        this.erzeugeLabel(composite, "Vert. Seiten:");
        this.erzeugeSeitenzaehlerSpinner(composite, new Listener(){

            public void handleEvent(Event event) {
                DruckvorschauDialog.this.druckVorschau.setVerticalPageCount(((Spinner)event.widget).getSelection());
                DruckvorschauDialog.this.loescheVerschiebePosition();
                DruckvorschauDialog.this.aktualisiereVorschauGroesse();
                DruckvorschauDialog.this.aktualisiereSeitenNummer();
            }
        });
        return composite;
    }

    private void aktionSeiteVor() {
        this.setVorschauSeitenIndex(this.druckVorschau.getPageIndex() + this.druckVorschau.getHorizontalPageCount() * this.druckVorschau.getVerticalPageCount());
    }

    private Control erzeugeVerschiebbareVorschau(Composite parent) {
        this.verschiebbaresComposite = new ScrolledComposite(parent, 2816);
        this.verschiebbaresComposite.setExpandHorizontal(true);
        this.verschiebbaresComposite.setExpandVertical(true);
        this.druckVorschau = new PrintPreview((Composite)this.verschiebbaresComposite, 0);
        this.verschiebbaresComposite.setContent((Control)this.druckVorschau);
        this.verschiebbaresComposite.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Rectangle bounds = DruckvorschauDialog.this.verschiebbaresComposite.getClientArea();
                DruckvorschauDialog.this.verschiebbaresComposite.getHorizontalBar().setPageIncrement(bounds.width * 2 / 3);
                DruckvorschauDialog.this.verschiebbaresComposite.getVerticalBar().setPageIncrement(bounds.height * 2 / 3);
                if (DruckvorschauDialog.this.druckVorschau.isFitHorizontal() ^ DruckvorschauDialog.this.druckVorschau.isFitVertical()) {
                    DruckvorschauDialog.this.sichereVerschiebePosition();
                    DruckvorschauDialog.this.aktualisiereVorschauGroesse();
                    DruckvorschauDialog.this.wiederherstellenVerschiebePosition();
                }
            }
        });
        this.druckVorschau.setFitVertical(true);
        this.druckVorschau.setFitHorizontal(true);
        Listener dragListener = new Listener(){
            private final Point dpi;
            private boolean scrollable;
            private boolean dragging;
            private Point dragStartScrollOrigin;
            private Point dragStartMouseAnchor;
            {
                this.dpi = DruckvorschauDialog.this.display.getDPI();
            }

            public void handleEvent(Event event) {
                Point size = DruckvorschauDialog.this.druckVorschau.getSize();
                Rectangle bounds = DruckvorschauDialog.this.verschiebbaresComposite.getClientArea();
                switch (event.type) {
                    case 11: {
                        DruckvorschauDialog.this.loescheVerschiebePosition();
                        boolean bl = this.scrollable = size.x > bounds.width || size.y > bounds.height;
                        if (this.scrollable || !this.dragging) break;
                        this.endDragging();
                        break;
                    }
                    case 3: {
                        DruckvorschauDialog.this.loescheVerschiebePosition();
                        if (!this.scrollable || event.button != 1) break;
                        this.beginDragging(event);
                        break;
                    }
                    case 5: {
                        if (!this.dragging) break;
                        DruckvorschauDialog.this.loescheVerschiebePosition();
                        Point point = DruckvorschauDialog.this.druckVorschau.toDisplay(event.x, event.y);
                        DruckvorschauDialog.this.verschiebbaresComposite.setOrigin(this.dragStartScrollOrigin.x + this.dragStartMouseAnchor.x - point.x, this.dragStartScrollOrigin.y + this.dragStartMouseAnchor.y - point.y);
                        break;
                    }
                    case 4: {
                        DruckvorschauDialog.this.loescheVerschiebePosition();
                        if (!this.dragging) break;
                        this.endDragging();
                        break;
                    }
                    case 6: {
                        DruckvorschauDialog.this.display.addFilter(37, (Listener)this);
                        break;
                    }
                    case 37: {
                        if (event.count == 0) break;
                        if (this.scrollable && !this.dragging && (event.stateMask == 0 || event.stateMask == 131072)) {
                            int direction;
                            DruckvorschauDialog.this.loescheVerschiebePosition();
                            Point origin = DruckvorschauDialog.this.verschiebbaresComposite.getOrigin();
                            int n = direction = event.count > 0 ? -1 : 1;
                            if (size.y > bounds.height && event.stateMask == 0) {
                                origin.y += direction * Math.min(this.dpi.y, bounds.height / 4);
                            } else if (size.x > bounds.width) {
                                origin.x += direction * Math.min(this.dpi.x, bounds.width / 4);
                            }
                            DruckvorschauDialog.this.verschiebbaresComposite.setOrigin(origin);
                            event.doit = false;
                            break;
                        }
                        if (event.stateMask != 262144) break;
                        float scale = DruckvorschauDialog.this.druckVorschau.getAbsoluteScale();
                        if (event.count > 0) {
                            DruckvorschauDialog.this.setVorschauSkala((float)((double)scale / 1.1));
                            break;
                        }
                        DruckvorschauDialog.this.setVorschauSkala((float)((double)scale * 1.1));
                        break;
                    }
                    case 7: {
                        DruckvorschauDialog.this.display.removeFilter(37, (Listener)this);
                        break;
                    }
                }
            }

            private void beginDragging(Event event) {
                this.dragStartScrollOrigin = DruckvorschauDialog.this.verschiebbaresComposite.getOrigin();
                this.dragStartMouseAnchor = DruckvorschauDialog.this.druckVorschau.toDisplay(event.x, event.y);
                this.dragging = true;
            }

            private void endDragging() {
                this.dragging = false;
                this.dragStartMouseAnchor = null;
                this.dragStartScrollOrigin = null;
            }
        };
        this.verschiebbaresComposite.addListener(11, dragListener);
        this.druckVorschau.addListener(3, dragListener);
        this.druckVorschau.addListener(5, dragListener);
        this.druckVorschau.addListener(4, dragListener);
        this.druckVorschau.addListener(6, dragListener);
        this.druckVorschau.addListener(7, dragListener);
        return this.verschiebbaresComposite;
    }

    private Button erzeugeGrafischeSchaltflaeche(Composite parent, String imageFilename, String toolTipText, Listener selectionListener) {
        Button button = this.erzeugeSchaltflaeche(parent, toolTipText, selectionListener);
        button.setImage(RahmenwerkActivator.getDefault().getImage(imageFilename));
        return button;
    }

    private Button erzeugeTextSchaltflaeche(Composite parent, String text, String toolTipText, Listener selectionListener) {
        Button button = this.erzeugeSchaltflaeche(parent, toolTipText, selectionListener);
        button.setText(text);
        return button;
    }

    private Button erzeugeSchaltflaeche(Composite parent, String toolTipText, Listener selectionListener) {
        Button button = new Button(parent, 8);
        button.setToolTipText(toolTipText);
        button.setLayoutData((Object)new GridData(4, 4, false, false));
        button.addListener(13, selectionListener);
        return button;
    }

    private Spinner erzeugeSeitenzaehlerSpinner(Composite parent, Listener selectionListener) {
        Spinner spinner = new Spinner(parent, 2048);
        spinner.setMinimum(1);
        spinner.setMaximum(99);
        spinner.addListener(13, selectionListener);
        return spinner;
    }

    private void erzeugeLabel(Composite parent, String text) {
        new Label(parent, 0).setText(text);
    }

    private void aktualisiereSeitenNummer() {
        String text;
        int pageIndex = this.druckVorschau.getPageIndex();
        int pageCount = this.druckVorschau.getPageCount();
        int visiblePages = this.druckVorschau.getHorizontalPageCount() * this.druckVorschau.getVerticalPageCount();
        boolean layoutComplete = this.druckVorschau.isPageLayoutComplete();
        String string = text = visiblePages > 1 ? "Seiten " + (pageIndex + 1) + "-" + Math.min(pageCount, pageIndex + visiblePages) : "Seite " + (pageIndex + 1);
        if (layoutComplete) {
            text = String.valueOf(text) + " von " + pageCount;
        }
        this.labelSeitenNummer.setText(text);
        this.schaltflaecheVorhergehendeSeite.setEnabled(pageIndex > 0);
        this.schaltflaecheNachfolgendeSeite.setEnabled(pageIndex < pageCount - visiblePages || !layoutComplete);
        this.shell.layout(new Control[]{this.labelSeitenNummer});
    }

    private void sichereVerschiebePosition() {
        Point size = this.druckVorschau.getSize();
        if (size.x == 0 || size.y == 0) {
            this.loescheVerschiebePosition();
        } else if (this.verschiebePosition == null) {
            Point origin = this.verschiebbaresComposite.getOrigin();
            this.verschiebePosition = new double[]{(double)origin.x / (double)size.x, (double)origin.y / (double)size.y};
        }
    }

    private void loescheVerschiebePosition() {
        this.verschiebePosition = null;
    }

    private void wiederherstellenVerschiebePosition() {
        if (this.verschiebePosition != null) {
            Point size = this.druckVorschau.getSize();
            this.verschiebbaresComposite.setOrigin((int)Math.round(this.verschiebePosition[0] * (double)size.x), (int)Math.round(this.verschiebePosition[1] * (double)size.y));
        }
    }

    private void aktualisiereVorschauGroesse() {
        Rectangle bounds = this.verschiebbaresComposite.getClientArea();
        Point minSize = this.druckVorschau.isFitHorizontal() ? (this.druckVorschau.isFitVertical() ? new Point(0, 0) : new Point(0, this.druckVorschau.computeSize((int)bounds.width, (int)-1).y)) : (this.druckVorschau.isFitVertical() ? new Point(this.druckVorschau.computeSize((int)-1, (int)bounds.height).x, 0) : this.druckVorschau.computeSize(-1, -1));
        this.verschiebbaresComposite.setMinSize(minSize);
    }

    private void setVorschauSkala(float scale) {
        this.druckVorschau.setFitVertical(false);
        this.druckVorschau.setFitHorizontal(false);
        this.druckVorschau.setScale(scale);
        this.sichereVerschiebePosition();
        this.aktualisiereVorschauGroesse();
        this.wiederherstellenVerschiebePosition();
    }

    private void setVorschauSeitenIndex(int pageIndex) {
        int usedIndex = pageIndex;
        if (this.druckVorschau.isPageLayoutComplete()) {
            usedIndex = Math.min(pageIndex, this.druckVorschau.getPageCount() - this.druckVorschau.getHorizontalPageCount() * this.druckVorschau.getVerticalPageCount());
        }
        usedIndex = Math.max(usedIndex, 0);
        this.druckVorschau.setPageIndex(usedIndex);
        this.aktualisiereSeitenNummer();
    }

    private PagePrint erweiterePage(PagePrint page, String titel) {
        IPreferenceStore preferenceStore = RahmenwerkActivator.getDefault().getPreferenceStore();
        page.setHeader((PageDecoration)new SeitenDekoration(preferenceStore.getString("kopfzeileLinks"), preferenceStore.getString("kopfzeileMitte"), preferenceStore.getString("kopfzeileRechts"), true, titel));
        page.setHeaderGap(5);
        page.setFooter((PageDecoration)new SeitenDekoration(preferenceStore.getString("fusszeileLinks"), preferenceStore.getString("fusszeileMitte"), preferenceStore.getString("fusszeileRechts"), false, titel));
        page.setFooterGap(5);
        return page;
    }

    private static class SeitenDekoration
    implements PageDecoration {
        private final String links;
        private final String mitte;
        private final String rechts;
        private final boolean istKopfzeile;
        private LinkedList<String> sts;
        private final String titel;

        SeitenDekoration(String links, String mitte, String rechts, boolean istKopfzeile, String titel) {
            this.links = links;
            this.mitte = mitte;
            this.rechts = rechts;
            this.istKopfzeile = istKopfzeile;
            this.titel = titel;
        }

        public Print createPrint(PageNumber pageNumber) {
            DefaultGridLook look = new DefaultGridLook();
            look.setCellSpacing(2, 2);
            GridPrint grid = new GridPrint("l:pref:none, c:pref:grow, r:pref:none", (GridLook)look);
            if (!this.istKopfzeile) {
                grid.add((Print)new LinePrint(256), -1);
            }
            this.sts = new LinkedList();
            this.sts.add(this.links);
            this.sts.add(this.mitte);
            this.sts.add(this.rechts);
            this.pruefeStrings();
            for (String text : this.sts) {
                if (text.contains("[Seite]") || text.contains("[Seitenanzahl]")) {
                    PageNumberPageDecoration pnpd = new PageNumberPageDecoration();
                    pnpd.setFormat((PageNumberFormat)new PageNumberFormatErweitert(text));
                    grid.add(pnpd.createPrint(pageNumber));
                    continue;
                }
                grid.add((Print)new TextPrint(text));
            }
            if (this.istKopfzeile) {
                grid.add((Print)new LinePrint(256), -1);
            }
            return grid;
        }

        private void pruefeStrings() {
            Date date = new Date();
            SimpleDateFormat datumFormat = new SimpleDateFormat("dd.MM.yyyy");
            String datum = datumFormat.format(date);
            SimpleDateFormat zeitFormat = new SimpleDateFormat("HH:mm:ss");
            String zeit = zeitFormat.format(date);
            LinkedList<String> neueStrings = new LinkedList<String>();
            for (String pruefling : this.sts) {
                if (pruefling.contains("[Datum]")) {
                    pruefling = pruefling.replaceAll("\\[Datum\\]", datum);
                }
                if (pruefling.contains("[Uhrzeit]")) {
                    pruefling = pruefling.replaceAll("\\[Uhrzeit\\]", zeit);
                }
                if (pruefling.contains("[Titel]")) {
                    pruefling = pruefling.replaceAll("\\[Titel\\]", Matcher.quoteReplacement(this.titel));
                }
                neueStrings.add(pruefling);
            }
            this.sts = neueStrings;
        }
    }
}

