/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.rw.statusleiste;

import de.bsvrz.buv.rw.basislib.menu.AbstractRwMenuControl;
import de.bsvrz.buv.rw.basislib.util.RwColor;
import de.bsvrz.buv.rw.rw.RahmenwerkActivator;
import de.bsvrz.buv.rw.rw.internal.RahmenwerkImpl;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimerTask;
import org.eclipse.jface.action.StatusLineLayoutData;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class AktuelleZeitElement
extends AbstractRwMenuControl {
    private static final String PARAM_HINTERGRUND = "hintergrund";
    private static final String PARAM_FARBE = "farbe";
    private static final String PARAM_FORMAT = "format";
    private static final String PARAM_DAVZEIT = "davzeit";
    private Widget anzeigeText;
    private TimerTask task;
    private String formatStr = "HH:MM:SS";
    private String foreGround;
    private String backGround;
    private boolean davZeit;

    public void fill(Composite parent) {
        if (this.anzeigeText == null) {
            this.anzeigeText = new CLabel(parent, 2080);
            ((CLabel)this.anzeigeText).setText(this.formatStr);
            Color color = new Color((Device)this.anzeigeText.getDisplay(), RwColor.getRgbFromString((String)this.foreGround));
            ((CLabel)this.anzeigeText).setForeground(color);
            color.dispose();
            if (this.backGround != null && !this.backGround.trim().isEmpty()) {
                color = new Color((Device)this.anzeigeText.getDisplay(), RwColor.getRgbFromString((String)this.backGround));
                ((CLabel)this.anzeigeText).setBackground(color);
                color.dispose();
            } else {
                ((CLabel)this.anzeigeText).setBackground(null);
            }
            ((CLabel)this.anzeigeText).setAlignment(0x1000000);
            this.anzeigeText.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    AktuelleZeitElement.this.anzeigeText = null;
                    AktuelleZeitElement.this.stopTimer();
                }
            });
            Point preferredSize = ((Control)this.anzeigeText).computeSize(-1, -1);
            int widthHint = preferredSize.x + 10;
            StatusLineLayoutData data = new StatusLineLayoutData();
            data.widthHint = widthHint;
            ((CLabel)this.anzeigeText).setLayoutData((Object)data);
            this.updateTimeDisplay();
            this.startTimer();
        }
    }

    private void startTimer() {
        this.task = new TimerTask(){

            @Override
            public void run() {
                AktuelleZeitElement.this.updateTimeDisplay();
            }
        };
        RahmenwerkActivator.getRahmenwerkTimer().schedule(this.task, 1000L, 1000L);
    }

    private void stopTimer() {
        this.task.cancel();
        RahmenwerkActivator.getRahmenwerkTimer().purge();
    }

    private void updateTimeDisplay() {
        String zeitStr;
        Date date = new Date();
        if (this.davZeit) {
            if (RahmenwerkImpl.getInstanz().isOnline()) {
                date = new Date(RahmenwerkImpl.getInstanz().getDavVerbindung().getTime());
                zeitStr = new SimpleDateFormat(this.formatStr).format(date);
            } else {
                zeitStr = "???";
            }
        } else {
            zeitStr = new SimpleDateFormat(this.formatStr).format(date);
        }
        if (this.anzeigeText != null && !this.anzeigeText.isDisposed()) {
            this.anzeigeText.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (AktuelleZeitElement.this.anzeigeText != null && !AktuelleZeitElement.this.anzeigeText.isDisposed()) {
                        if (AktuelleZeitElement.this.anzeigeText instanceof ToolItem) {
                            ((ToolItem)AktuelleZeitElement.this.anzeigeText).setText(zeitStr);
                        } else if (AktuelleZeitElement.this.anzeigeText instanceof MenuItem) {
                            ((MenuItem)AktuelleZeitElement.this.anzeigeText).setText(zeitStr);
                        } else if (AktuelleZeitElement.this.anzeigeText instanceof CLabel) {
                            ((CLabel)AktuelleZeitElement.this.anzeigeText).setText(zeitStr);
                        }
                    }
                }
            });
        }
    }

    public void fill(Menu menu, int index) {
        if (this.anzeigeText == null) {
            this.anzeigeText = new MenuItem(menu, 64, index);
            ((MenuItem)this.anzeigeText).setText(this.formatStr);
            this.startTimer();
        }
    }

    public void fill(ToolBar parent, int index) {
        if (this.anzeigeText == null) {
            this.anzeigeText = new ToolItem(parent, 0, index);
            ((ToolItem)this.anzeigeText).setText(this.formatStr);
            ((ToolItem)this.anzeigeText).setImage(null);
            this.startTimer();
        }
    }

    public void setParameter(Map<String, String> parameters) {
        for (Map.Entry<String, String> parameter : parameters.entrySet()) {
            if (PARAM_FORMAT.equals(parameter.getKey())) {
                this.formatStr = parameter.getValue();
                continue;
            }
            if (PARAM_FARBE.equals(parameter.getKey())) {
                this.foreGround = parameter.getValue();
                continue;
            }
            if (PARAM_HINTERGRUND.equals(parameter.getKey())) {
                this.backGround = parameter.getValue();
                continue;
            }
            if (!PARAM_DAVZEIT.equals(parameter.getKey())) continue;
            this.davZeit = Boolean.parseBoolean(parameter.getValue());
        }
    }

    public boolean useInMenue() {
        return true;
    }

    public boolean useInStatusLine() {
        return true;
    }

    public boolean useInToolbar() {
        return true;
    }
}

