/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.rw.statusleiste;

import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsEvent;
import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsListener;
import de.bsvrz.buv.rw.basislib.menu.AbstractRwMenuControl;
import de.bsvrz.buv.rw.basislib.util.RwColor;
import de.bsvrz.buv.rw.rw.internal.RahmenwerkImpl;
import de.bsvrz.dav.daf.main.archive.ArchiveAvailabilityListener;
import de.bsvrz.dav.daf.main.archive.ArchiveRequestManager;
import de.bsvrz.dav.daf.main.config.SystemObject;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.StatusLineLayoutData;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class ArchivStatusControl
extends AbstractRwMenuControl {
    private static final String PARAM_PID = "pid";
    private static final String PARAM_FARBE_ONLINE = "farbeonline";
    private static final String PARAM_FARBE_OFFINE = "farbeoffline";
    private static final String PARAM_FARBE_UNKNOWN = "farbeunbekannt";
    private static final String PARAM_HINTERGRUND_ONLINE = "hintergrundonline";
    private static final String PARAM_HINTERGRUND_OFFLINE = "hintergrundoffline";
    private static final String PARAM_HINTERGRUND_UNKNOWN = "hintergrundunbekannt";
    private static final String PARAM_FORMAT_ONLINE = "textonline";
    private static final String PARAM_FORMAT_OFFLINE = "textoffline";
    private static final String PARAM_FORMAT_UNKNOWN = "textunbekannt";
    private String pid;
    private String formatOnline;
    private String formatOffline;
    private String formatUnknown;
    private String foreGroundOnline;
    private String foreGroundOffline;
    private String foreGroundUnknown;
    private String backGroundOnline;
    private String backGroundOffline;
    private String backGroundUnknown;
    private CLabel anzeigeText;
    private VerbindungsListener verbindungsListener;
    private ArchiveRequestManager archiveRequestManager;
    private ArchiveListener archiveListener;

    public void fill(Composite parent) {
        if (this.anzeigeText == null) {
            this.anzeigeText = new CLabel(parent, 2080);
            this.anzeigeText.setAlignment(0x1000000);
            this.anzeigeText.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ArchivStatusControl.this.deregisterArchive();
                    ArchivStatusControl.this.anzeigeText = null;
                    if (ArchivStatusControl.this.verbindungsListener != null) {
                        RahmenwerkImpl.getInstanz().removeDavVerbindungsListener(ArchivStatusControl.this.verbindungsListener);
                    }
                    ArchivStatusControl.this.verbindungsListener = null;
                }
            });
            this.verbindungsListener = new VerbindungsListener();
            RahmenwerkImpl.getInstanz().addDavVerbindungsListener(this.verbindungsListener);
            if (RahmenwerkImpl.getInstanz().isOnline()) {
                this.registerArchive();
            }
            this.updateText();
        }
    }

    private void registerArchive() {
        this.deregisterArchive();
        this.archiveRequestManager = this.pid == null || this.pid.trim().isEmpty() ? RahmenwerkImpl.getInstanz().getDavVerbindung().getArchive() : RahmenwerkImpl.getInstanz().getDavVerbindung().getArchive(this.getArchiveObject(this.pid));
        if (this.archiveRequestManager != null) {
            this.archiveListener = new ArchiveListener();
            this.archiveRequestManager.addArchiveAvailabilityListener((ArchiveAvailabilityListener)this.archiveListener);
        }
    }

    private void deregisterArchive() {
        if (this.archiveListener != null && this.archiveRequestManager != null) {
            this.archiveRequestManager.removeArchiveAvailabilityListener((ArchiveAvailabilityListener)this.archiveListener);
        }
        this.archiveListener = null;
        this.archiveRequestManager = null;
    }

    private SystemObject getArchiveObject(String archivPid) {
        SystemObject archiv = null;
        if (RahmenwerkImpl.getInstanz().isOnline()) {
            archiv = RahmenwerkImpl.getInstanz().getDavVerbindung().getDataModel().getObject(archivPid);
        }
        return archiv;
    }

    private void updateText() {
        if (PlatformUI.getWorkbench().isClosing()) {
            return;
        }
        UIJob job = new UIJob("Aktualisiere Archivstatus"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (ArchivStatusControl.this.anzeigeText != null && !ArchivStatusControl.this.anzeigeText.isDisposed()) {
                    String text = ArchivStatusControl.this.formatUnknown;
                    String colorDef = ArchivStatusControl.this.foreGroundUnknown;
                    String bkgdDef = ArchivStatusControl.this.backGroundUnknown;
                    if (ArchivStatusControl.this.archiveRequestManager != null) {
                        if (ArchivStatusControl.this.archiveRequestManager.isArchiveAvailable()) {
                            text = ArchivStatusControl.this.formatOnline;
                            colorDef = ArchivStatusControl.this.foreGroundOnline;
                            bkgdDef = ArchivStatusControl.this.backGroundOnline;
                        } else {
                            text = ArchivStatusControl.this.formatOffline;
                            colorDef = ArchivStatusControl.this.foreGroundOffline;
                            bkgdDef = ArchivStatusControl.this.backGroundOffline;
                        }
                    }
                    Color color = new Color((Device)ArchivStatusControl.this.anzeigeText.getDisplay(), RwColor.getRgbFromString((String)colorDef));
                    ArchivStatusControl.this.anzeigeText.setForeground(color);
                    color.dispose();
                    if (bkgdDef != null && !bkgdDef.trim().isEmpty()) {
                        color = new Color((Device)ArchivStatusControl.this.anzeigeText.getDisplay(), RwColor.getRgbFromString((String)bkgdDef));
                        ArchivStatusControl.this.anzeigeText.setBackground(color);
                        color.dispose();
                    } else {
                        ArchivStatusControl.this.anzeigeText.setBackground(null);
                    }
                    ArchivStatusControl.this.anzeigeText.setText(text);
                    Point preferredSize = ArchivStatusControl.this.anzeigeText.computeSize(-1, -1);
                    int widthHint = preferredSize.x + 10;
                    StatusLineLayoutData data = new StatusLineLayoutData();
                    data.widthHint = widthHint;
                    ArchivStatusControl.this.anzeigeText.setLayoutData((Object)data);
                    ArchivStatusControl.this.anzeigeText.getParent().layout(true);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return "RahmenwerkJobs".equals(family) || super.belongsTo(family);
            }
        };
        job.schedule();
    }

    public void setParameter(Map<String, String> parameters) {
        for (Map.Entry<String, String> parameter : parameters.entrySet()) {
            if (PARAM_PID.equals(parameter.getKey())) {
                this.pid = parameter.getValue();
                continue;
            }
            if (PARAM_FORMAT_ONLINE.equals(parameter.getKey())) {
                this.formatOnline = parameter.getValue();
                continue;
            }
            if (PARAM_FORMAT_OFFLINE.equals(parameter.getKey())) {
                this.formatOffline = parameter.getValue();
                continue;
            }
            if (PARAM_FORMAT_UNKNOWN.equals(parameter.getKey())) {
                this.formatUnknown = parameter.getValue();
                continue;
            }
            if (PARAM_FARBE_ONLINE.equals(parameter.getKey())) {
                this.foreGroundOnline = parameter.getValue();
                continue;
            }
            if (PARAM_FARBE_OFFINE.equals(parameter.getKey())) {
                this.foreGroundOffline = parameter.getValue();
                continue;
            }
            if (PARAM_FARBE_UNKNOWN.equals(parameter.getKey())) {
                this.foreGroundUnknown = parameter.getValue();
                continue;
            }
            if (PARAM_HINTERGRUND_ONLINE.equals(parameter.getKey())) {
                this.backGroundOnline = parameter.getValue();
                continue;
            }
            if (PARAM_HINTERGRUND_OFFLINE.equals(parameter.getKey())) {
                this.backGroundOffline = parameter.getValue();
                continue;
            }
            if (!PARAM_HINTERGRUND_UNKNOWN.equals(parameter.getKey())) continue;
            this.backGroundUnknown = parameter.getValue();
        }
    }

    public boolean useInStatusLine() {
        return true;
    }

    private class ArchiveListener
    implements ArchiveAvailabilityListener {
        private ArchiveListener() {
        }

        public void archiveAvailabilityChanged(ArchiveRequestManager arg0) {
            ArchivStatusControl.this.updateText();
        }
    }

    private class VerbindungsListener
    implements DavVerbindungsListener {
        private VerbindungsListener() {
        }

        public void verbindungHergestellt(DavVerbindungsEvent event) {
            ArchivStatusControl.this.registerArchive();
            ArchivStatusControl.this.updateText();
        }

        public void verbindungGetrennt(DavVerbindungsEvent event) {
            ArchivStatusControl.this.deregisterArchive();
            ArchivStatusControl.this.updateText();
        }

        public boolean verbindungHalten(DavVerbindungsEvent event) {
            return false;
        }
    }
}

