/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.rw.statusleiste;

import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsEvent;
import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsListener;
import de.bsvrz.buv.rw.basislib.menu.AbstractRwMenuControl;
import de.bsvrz.buv.rw.basislib.util.RwColor;
import de.bsvrz.buv.rw.rw.RahmenwerkActivator;
import de.bsvrz.buv.rw.rw.internal.RahmenwerkImpl;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientReceiverInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.ReceiveOptions;
import de.bsvrz.dav.daf.main.ReceiverRole;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.SystemObject;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.StatusLineLayoutData;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class BenutzerStatusControl
extends AbstractRwMenuControl {
    private static final String BENUTZER_PID = "benutzer.pid";
    private static final String TEXT_BENUTZER_OFFLINE = "text.benutzer.offline";
    private static final String TEXT_BENUTZER_ONLINE = "text.benutzer.online";
    private static final String HINTERGRUNDFARBE_BENUTZER_OFFLINE = "hintergrundfarbe.benutzer.offline";
    private static final String HINTERGRUNDFARBE_BENUTZER_ONLINE = "hintergrundfarbe.benutzer.online";
    private static final String TEXTFARBE_BENUTZER_OFFLINE = "textfarbe.benutzer.offline";
    private static final String TEXTFARBE_BENUTZER_ONLINE = "textfarbe.benutzer.online";
    private String benutzerPid;
    private String textBenutzerOffline;
    private String textBenutzerOnline;
    private String hintergrundFarbeBenutzerOffline;
    private String hintergrundFarbeBenutzerOnline;
    private String textFarbeBenutzerOffline;
    private String textFarbeBenutzerOnline;
    private String formatUnknown = "";
    private String foreGroundUnknown = "white";
    private String backGroundUnknown = "grey";
    private VerbindungsListener verbindungsListener;
    private CLabel anzeigeText;
    private AngemeldeteApplikationenListener applikationsListener;

    public void setParameter(Map<String, String> parameters) {
        for (Map.Entry<String, String> parameter : parameters.entrySet()) {
            if (BENUTZER_PID.equals(parameter.getKey())) {
                this.benutzerPid = parameter.getValue();
                continue;
            }
            if (TEXT_BENUTZER_OFFLINE.equals(parameter.getKey())) {
                this.textBenutzerOffline = parameter.getValue();
                continue;
            }
            if (TEXT_BENUTZER_ONLINE.equals(parameter.getKey())) {
                this.textBenutzerOnline = parameter.getValue();
                continue;
            }
            if (HINTERGRUNDFARBE_BENUTZER_OFFLINE.equals(parameter.getKey())) {
                this.hintergrundFarbeBenutzerOffline = parameter.getValue();
                continue;
            }
            if (HINTERGRUNDFARBE_BENUTZER_ONLINE.equals(parameter.getKey())) {
                this.hintergrundFarbeBenutzerOnline = parameter.getValue();
                continue;
            }
            if (TEXTFARBE_BENUTZER_OFFLINE.equals(parameter.getKey())) {
                this.textFarbeBenutzerOffline = parameter.getValue();
                continue;
            }
            if (!TEXTFARBE_BENUTZER_ONLINE.equals(parameter.getKey())) continue;
            this.textFarbeBenutzerOnline = parameter.getValue();
        }
    }

    public boolean useInStatusLine() {
        return true;
    }

    public void fill(Composite parent) {
        if (this.anzeigeText == null) {
            this.anzeigeText = new CLabel(parent, 2080);
            this.anzeigeText.setAlignment(0x1000000);
            this.anzeigeText.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    BenutzerStatusControl.this.deregisterAnmeldungsListener();
                    BenutzerStatusControl.this.anzeigeText = null;
                    if (BenutzerStatusControl.this.verbindungsListener != null) {
                        RahmenwerkImpl.getInstanz().removeDavVerbindungsListener(BenutzerStatusControl.this.verbindungsListener);
                    }
                    BenutzerStatusControl.this.verbindungsListener = null;
                }
            });
            this.verbindungsListener = new VerbindungsListener();
            RahmenwerkImpl.getInstanz().addDavVerbindungsListener(this.verbindungsListener);
            if (RahmenwerkImpl.getInstanz().isOnline()) {
                this.registerAnmeldungsListener();
            }
            this.updateText();
        }
    }

    private void registerAnmeldungsListener() {
        this.deregisterAnmeldungsListener();
        if (this.benutzerPid != null && !this.benutzerPid.trim().isEmpty()) {
            this.applikationsListener = new AngemeldeteApplikationenListener(this.benutzerPid);
            this.applikationsListener.anmelden();
        }
    }

    private void deregisterAnmeldungsListener() {
        if (this.applikationsListener != null) {
            this.applikationsListener.abmelden();
        }
        this.applikationsListener = null;
    }

    private void updateText() {
        if (PlatformUI.getWorkbench().isClosing()) {
            return;
        }
        UIJob job = new UIJob("Aktualisiere Benutzerstatus"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (BenutzerStatusControl.this.anzeigeText != null && !BenutzerStatusControl.this.anzeigeText.isDisposed()) {
                    String text = BenutzerStatusControl.this.formatUnknown;
                    String colorDef = BenutzerStatusControl.this.foreGroundUnknown;
                    String bkgdDef = BenutzerStatusControl.this.backGroundUnknown;
                    if (BenutzerStatusControl.this.applikationsListener != null) {
                        if (BenutzerStatusControl.this.applikationsListener.isBenutzerOnline()) {
                            text = BenutzerStatusControl.this.textBenutzerOnline;
                            colorDef = BenutzerStatusControl.this.textFarbeBenutzerOnline;
                            bkgdDef = BenutzerStatusControl.this.hintergrundFarbeBenutzerOnline;
                        } else {
                            text = BenutzerStatusControl.this.textBenutzerOffline;
                            colorDef = BenutzerStatusControl.this.textFarbeBenutzerOffline;
                            bkgdDef = BenutzerStatusControl.this.hintergrundFarbeBenutzerOffline;
                        }
                    }
                    Color color = new Color((Device)BenutzerStatusControl.this.anzeigeText.getDisplay(), RwColor.getRgbFromString((String)colorDef));
                    BenutzerStatusControl.this.anzeigeText.setForeground(color);
                    color.dispose();
                    if (bkgdDef != null && !bkgdDef.trim().isEmpty()) {
                        color = new Color((Device)BenutzerStatusControl.this.anzeigeText.getDisplay(), RwColor.getRgbFromString((String)bkgdDef));
                        BenutzerStatusControl.this.anzeigeText.setBackground(color);
                        color.dispose();
                    } else {
                        BenutzerStatusControl.this.anzeigeText.setBackground(null);
                    }
                    BenutzerStatusControl.this.anzeigeText.setText(text);
                    Point preferredSize = BenutzerStatusControl.this.anzeigeText.computeSize(-1, -1);
                    int widthHint = preferredSize.x + 10;
                    StatusLineLayoutData data = new StatusLineLayoutData();
                    data.widthHint = widthHint;
                    BenutzerStatusControl.this.anzeigeText.setLayoutData((Object)data);
                    BenutzerStatusControl.this.anzeigeText.getParent().layout(true);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return "RahmenwerkJobs".equals(family) || super.belongsTo(family);
            }
        };
        job.schedule();
    }

    private class AngemeldeteApplikationenListener
    implements ClientReceiverInterface {
        private final ClientDavInterface davVerbindung = RahmenwerkImpl.getInstanz().getDavVerbindung();
        private final DataDescription desc;
        private final String benutzerPid;
        private int anzahlAnmeldungen;

        AngemeldeteApplikationenListener(String benutzerPid) {
            Aspect aspect = this.davVerbindung.getDataModel().getAspect("asp.standard");
            AttributeGroup attributeGroup = this.davVerbindung.getDataModel().getAttributeGroup("atg.angemeldeteApplikationen");
            this.desc = new DataDescription(attributeGroup, aspect);
            this.benutzerPid = benutzerPid;
        }

        void anmelden() {
            this.davVerbindung.subscribeReceiver((ClientReceiverInterface)this, (SystemObject)this.davVerbindung.getLocalDav(), this.desc, ReceiveOptions.normal(), ReceiverRole.receiver());
        }

        void abmelden() {
            this.davVerbindung.unsubscribeReceiver((ClientReceiverInterface)this, (SystemObject)this.davVerbindung.getLocalDav(), this.desc);
        }

        public void update(final ResultData[] results) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    ResultData[] resultDataArray = results;
                    int n = results.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ResultData rd = resultDataArray[n2];
                        if (rd.hasData() && rd.getDataDescription().equals((Object)AngemeldeteApplikationenListener.this.desc)) {
                            AngemeldeteApplikationenListener.this.anzahlAnmeldungen = 0;
                            Data data = rd.getData();
                            Data.Array array = data.getArray("angemeldeteApplikation");
                            int i = 0;
                            while (i < array.getLength()) {
                                Data item = array.getItem(i);
                                Data.ReferenceValue referenceValue = item.getReferenceValue("benutzer");
                                SystemObject systemObject = referenceValue.getSystemObject();
                                if (systemObject != null && AngemeldeteApplikationenListener.this.benutzerPid.equals(systemObject.getPid())) {
                                    AngemeldeteApplikationenListener angemeldeteApplikationenListener = AngemeldeteApplikationenListener.this;
                                    angemeldeteApplikationenListener.anzahlAnmeldungen = angemeldeteApplikationenListener.anzahlAnmeldungen + 1;
                                }
                                ++i;
                            }
                        }
                        ++n2;
                    }
                    BenutzerStatusControl.this.updateText();
                }

                public void handleException(Throwable exception) {
                    RahmenwerkActivator.getDefault().getLog().log((IStatus)new Status(4, "de.bsvrz.buv.rw.rw", "Onlinestatus des Benutzers " + AngemeldeteApplikationenListener.this.benutzerPid + " konnte nicht ermittelt werden.", exception));
                }
            });
        }

        public boolean isBenutzerOnline() {
            return this.anzahlAnmeldungen > 0;
        }
    }

    private class VerbindungsListener
    implements DavVerbindungsListener {
        private VerbindungsListener() {
        }

        public void verbindungHergestellt(DavVerbindungsEvent event) {
            BenutzerStatusControl.this.registerAnmeldungsListener();
            BenutzerStatusControl.this.updateText();
        }

        public void verbindungGetrennt(DavVerbindungsEvent event) {
            BenutzerStatusControl.this.deregisterAnmeldungsListener();
            BenutzerStatusControl.this.updateText();
        }

        public boolean verbindungHalten(DavVerbindungsEvent event) {
            return false;
        }
    }
}

