/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.rw.statusleiste;

import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsEvent;
import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsListener;
import de.bsvrz.buv.rw.basislib.menu.AbstractRwMenuControl;
import de.bsvrz.buv.rw.basislib.util.RwColor;
import de.bsvrz.buv.rw.basislib.util.RwInfoDef;
import de.bsvrz.buv.rw.rw.internal.RahmenwerkImpl;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.StatusLineLayoutData;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.progress.UIJob;

public class RwInfoStatusControl
extends AbstractRwMenuControl {
    private static final String PARAM_HINTERGRUND = "hintergrund";
    private static final String PARAM_FARBE = "farbe";
    private static final String PARAM_FORMAT_ONLINE = "formatonline";
    private static final String PARAM_FORMAT_OFFLINE = "formatoffline";
    private String formatOnlineStr;
    private String formatOfflineStr;
    private String foreGround;
    private String backGround;
    private CLabel anzeigeText;
    private VerbindungsListener verbindungsListener;

    public void fill(Composite parent) {
        if (this.anzeigeText == null) {
            this.anzeigeText = new CLabel(parent, 2080);
            Color color = new Color((Device)this.anzeigeText.getDisplay(), RwColor.getRgbFromString((String)this.foreGround));
            this.anzeigeText.setForeground(color);
            color.dispose();
            if (this.backGround == null || this.backGround.trim().isEmpty()) {
                this.anzeigeText.setBackground(null);
            } else {
                color = new Color((Device)this.anzeigeText.getDisplay(), RwColor.getRgbFromString((String)this.backGround));
                this.anzeigeText.setBackground(color);
                color.dispose();
            }
            this.anzeigeText.setAlignment(0x1000000);
            this.anzeigeText.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    RwInfoStatusControl.this.anzeigeText = null;
                    if (RwInfoStatusControl.this.verbindungsListener != null) {
                        RahmenwerkImpl.getInstanz().removeDavVerbindungsListener(RwInfoStatusControl.this.verbindungsListener);
                    }
                    RwInfoStatusControl.this.verbindungsListener = null;
                }
            });
            this.verbindungsListener = new VerbindungsListener();
            RahmenwerkImpl.getInstanz().addDavVerbindungsListener(this.verbindungsListener);
            this.updateText();
        }
    }

    private void updateText() {
        if (this.anzeigeText != null) {
            UIJob job = new UIJob("Refresh RwInfo"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (RwInfoStatusControl.this.anzeigeText != null && !RwInfoStatusControl.this.anzeigeText.isDisposed()) {
                        String text = RahmenwerkImpl.getInstanz().isOnline() ? RwInfoDef.format((String)RwInfoStatusControl.this.formatOnlineStr) : RwInfoDef.format((String)RwInfoStatusControl.this.formatOfflineStr);
                        RwInfoStatusControl.this.anzeigeText.setVisible(text != null && !text.isEmpty());
                        RwInfoStatusControl.this.anzeigeText.setText(text);
                        Point preferredSize = RwInfoStatusControl.this.anzeigeText.computeSize(-1, -1);
                        int widthHint = preferredSize.x + 10;
                        StatusLineLayoutData data = new StatusLineLayoutData();
                        data.widthHint = widthHint;
                        RwInfoStatusControl.this.anzeigeText.setLayoutData((Object)data);
                        RwInfoStatusControl.this.anzeigeText.getParent().layout(true);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }

    public void setParameter(Map<String, String> parameters) {
        for (Map.Entry<String, String> parameter : parameters.entrySet()) {
            if (PARAM_FORMAT_ONLINE.equals(parameter.getKey())) {
                this.formatOnlineStr = parameter.getValue();
                continue;
            }
            if (PARAM_FORMAT_OFFLINE.equals(parameter.getKey())) {
                this.formatOfflineStr = parameter.getValue();
                continue;
            }
            if (PARAM_FARBE.equals(parameter.getKey())) {
                this.foreGround = parameter.getValue();
                continue;
            }
            if (!PARAM_HINTERGRUND.equals(parameter.getKey())) continue;
            this.backGround = parameter.getValue();
        }
    }

    public boolean useInStatusLine() {
        return true;
    }

    private class VerbindungsListener
    implements DavVerbindungsListener {
        private VerbindungsListener() {
        }

        public void verbindungHergestellt(DavVerbindungsEvent event) {
            UIJob job = new UIJob("Statusline-Update"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    RwInfoStatusControl.this.updateText();
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }

        public void verbindungGetrennt(DavVerbindungsEvent event) {
            RwInfoStatusControl.this.updateText();
        }

        public boolean verbindungHalten(DavVerbindungsEvent event) {
            return false;
        }
    }
}

