/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.rw.ui.internal;

import de.bsvrz.buv.rw.basislib.dav.DavConnectionException;
import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsEvent;
import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsListener;
import de.bsvrz.buv.rw.rw.RahmenwerkActivator;
import de.bsvrz.buv.rw.rw.internal.RahmenwerkImpl;
import de.bsvrz.buv.rw.rw.internal.RahmenwerkTray;
import de.bsvrz.buv.rw.rw.login.LoginDialog;
import de.bsvrz.buv.rw.rw.ui.internal.RahmenwerkWorkbenchWindowAdvisor;
import de.bsvrz.sys.funclib.debug.Debug;
import javax.inject.Inject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.css.swt.theme.IThemeManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;

public class RahmenwerkWorkbenchAdvisor
extends WorkbenchAdvisor {
    private static final Debug LOGGER = Debug.getLogger();
    private RahmenwerkTray tray;
    @Inject
    private IThemeManager themeManager;
    private boolean onShutDown;

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        return new RahmenwerkWorkbenchWindowAdvisor(configurer);
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        super.initialize(configurer);
        configurer.setSaveAndRestore(true);
    }

    public String getInitialWindowPerspectiveId() {
        return RahmenwerkActivator.getDefault().getDefaultPerspectiveId();
    }

    public IAdaptable getDefaultPageInput() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public void preStartup() {
        this.tray = new RahmenwerkTray(this.getWorkbenchConfigurer().getWorkbench().getDisplay().getSystemTray());
        boolean runLogin = true;
        String errorText = null;
        LoginDialog loginDialog = new LoginDialog(null);
        while (runLogin) {
            if (loginDialog.open() == 0) {
                LoginDialog.AnmeldeDaten anmeldeDaten = loginDialog.getAnmeldeDaten();
                if (anmeldeDaten.isOnline()) {
                    try {
                        RahmenwerkImpl.getInstanz().login(anmeldeDaten);
                        runLogin = false;
                    }
                    catch (DavConnectionException e) {
                        LOGGER.fine(e.getLocalizedMessage(), (Throwable)e);
                        if (e.getCause() != null) {
                            errorText = e.getCause().getLocalizedMessage();
                        }
                        if (errorText == null || errorText.isEmpty()) {
                            errorText = e.getLocalizedMessage();
                        }
                        loginDialog = new LoginDialog(errorText);
                    }
                    continue;
                }
                RahmenwerkImpl.getInstanz().setBenutzerName(anmeldeDaten.getName());
                runLogin = false;
                continue;
            }
            this.tray.dispose();
            System.exit(0);
        }
        this.updateTheme();
        RahmenwerkImpl.getInstanz().addDavVerbindungsListener(new DavVerbindungsListener(){

            public void verbindungHergestellt(DavVerbindungsEvent event) {
                RahmenwerkWorkbenchAdvisor.this.updateTheme();
            }

            public boolean verbindungHalten(DavVerbindungsEvent event) {
                return false;
            }

            public void verbindungGetrennt(DavVerbindungsEvent event) {
                RahmenwerkWorkbenchAdvisor.this.updateTheme();
            }
        });
        super.preStartup();
    }

    private void updateTheme() {
        if (this.onShutDown) {
            return;
        }
        if (this.themeManager != null) {
            this.getWorkbenchConfigurer().getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IThemeEngine engine = RahmenwerkWorkbenchAdvisor.this.themeManager.getEngineForDisplay(RahmenwerkWorkbenchAdvisor.this.getWorkbenchConfigurer().getWorkbench().getDisplay());
                    if (engine != null) {
                        if (RahmenwerkImpl.getInstanz().isOnline() && RahmenwerkImpl.getInstanz().getDavVerbindung().getClientDavParameters().getSimulationVariant() > 0) {
                            engine.setTheme("de.bsvrz.buv.rw.rw.theme.simulation", true);
                        } else {
                            engine.setTheme("de.bsvrz.buv.rw.rw.theme.default", true);
                        }
                    }
                }
            });
        }
    }

    public boolean preShutdown() {
        boolean result = MessageDialog.openConfirm(null, (String)"Rahmenwerk beenden", (String)"Soll die Anwendung wirklich beendet werden?");
        if (result) {
            this.onShutDown = true;
        }
        return result;
    }

    public void postShutdown() {
        RahmenwerkImpl rahmenwerk = RahmenwerkImpl.getInstanz();
        if (rahmenwerk != null) {
            rahmenwerk.davVerbindungBeenden();
        }
        if (this.tray != null) {
            this.tray.dispose();
        }
        super.postShutdown();
    }
}

