/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.rw.ui.internal;

import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsEvent;
import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsListener;
import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungChangeListener;
import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungLocation;
import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungOwnerType;
import de.bsvrz.buv.rw.basislib.einstellungen.Einstellungen;
import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungsAdresse;
import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungsEvent;
import de.bsvrz.buv.rw.rw.RahmenwerkActivator;
import de.bsvrz.buv.rw.rw.internal.InternalServices;
import de.bsvrz.buv.rw.rw.internal.RahmenwerkImpl;
import de.bsvrz.buv.rw.rw.menu.AbstractMenueLeiste;
import de.bsvrz.buv.rw.rw.menu.LeistenParser;
import de.bsvrz.buv.rw.rw.menu.MenuGenerator;
import de.bsvrz.buv.rw.rw.menu.MenueLeiste;
import de.bsvrz.buv.rw.rw.menu.StatusLeiste;
import de.bsvrz.buv.rw.rw.menu.SymbolLeiste;
import de.bsvrz.buv.rw.rw.ui.internal.ApplicationActionBarAdvisor;
import de.bsvrz.buv.rw.rw.ui.internal.ReconnectDialog;
import de.bsvrz.buv.rw.rw.ui.internal.WorkBenchWindowTitleProvider;
import de.bsvrz.sys.funclib.commandLineArgs.ArgumentList;
import de.bsvrz.sys.funclib.debug.Debug;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.services.IServiceLocator;
import org.xml.sax.SAXException;

public class RahmenwerkWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    private static final Debug LOGGER = Debug.getLogger();

    public RahmenwerkWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new ApplicationActionBarAdvisor(configurer);
    }

    public void preWindowOpen() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.setInitialSize(new Point(1024, 768));
        WorkBenchWindowTitleProvider titleProvider = new WorkBenchWindowTitleProvider(configurer);
        PlatformUI.getPreferenceStore().setValue("CLOSE_EDITORS_ON_EXIT", true);
        PlatformUI.getPreferenceStore().setValue("ENABLE_ANIMATIONS", true);
        PlatformUI.getPreferenceStore().setValue("SHOW_PROGRESS_ON_STARTUP", true);
        PlatformUI.getPreferenceStore().setValue("DOCK_PERSPECTIVE_BAR", "topRight");
        PlatformUI.getPreferenceStore().setValue("SHOW_TRADITIONAL_STYLE_TABS", false);
        PlatformUI.getPreferenceStore().setValue("SHOW_MEMORY_MONITOR", false);
        configurer.setShowProgressIndicator(true);
        configurer.setShowCoolBar(false);
        configurer.setShowStatusLine(true);
        configurer.setShowPerspectiveBar(true);
        configurer.setTitle(titleProvider.getTitel());
    }

    public void postWindowOpen() {
        final IWorkbenchWindow window = this.getWindowConfigurer().getWindow();
        window.addPerspectiveListener((IPerspectiveListener)new PerspectiveAdapter(){

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                ApplicationActionBarAdvisor.removeUnwantedToolbars(page.getWorkbenchWindow(), RahmenwerkImpl.getInstanz().getRwToolBarManager().getSymbolLeisteManager(), RahmenwerkImpl.getInstanz().getRwToolBarManager().getSymbolLeisteManagerToolbar());
            }

            public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
                if ("resetComplete".equals(changeId)) {
                    ApplicationActionBarAdvisor.removeUnwantedToolbars(page.getWorkbenchWindow(), RahmenwerkImpl.getInstanz().getRwToolBarManager().getSymbolLeisteManager(), RahmenwerkImpl.getInstanz().getRwToolBarManager().getSymbolLeisteManagerToolbar());
                }
            }

            public void perspectiveClosed(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                IPerspectiveDescriptor[] openPerspectives = page.getOpenPerspectives();
                if (openPerspectives.length <= 0) {
                    try {
                        IWorkbench workbench = page.getWorkbenchWindow().getWorkbench();
                        if (!workbench.isClosing()) {
                            workbench.showPerspective(RahmenwerkActivator.getDefault().getDefaultPerspectiveId(), page.getWorkbenchWindow());
                        }
                    }
                    catch (WorkbenchException e) {
                        LOGGER.error(e.getLocalizedMessage());
                    }
                }
                super.perspectiveClosed(page, perspective);
            }
        });
        this.ladeMenues(window);
        RahmenwerkImpl.getInstanz().addDavVerbindungsListener(new DavVerbindungsListener(){

            public void verbindungHergestellt(DavVerbindungsEvent event) {
                RahmenwerkWorkbenchWindowAdvisor.this.ladeMenues(window);
            }

            public boolean verbindungHalten(DavVerbindungsEvent event) {
                return false;
            }

            public void verbindungGetrennt(DavVerbindungsEvent event) {
                RahmenwerkWorkbenchWindowAdvisor.this.ladeMenues(window);
                if (!window.getWorkbench().isClosing()) {
                    UIJob uiJob = new UIJob("Reconnect Dialog"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            ReconnectDialog dialog = new ReconnectDialog(window.getShell());
                            dialog.open();
                            return Status.OK_STATUS;
                        }
                    };
                    uiJob.schedule();
                }
            }
        });
        Einstellungen einstellungen = InternalServices.getInstance().getEinstellungen();
        einstellungen.addEinstellungsListener(new EinstellungChangeListener(){

            public void einstellungEntfernt(EinstellungsEvent event) {
                this.update(window, event);
            }

            public void einstellungAngelegt(EinstellungsEvent event) {
                this.update(window, event);
            }

            public void einstellungAktualisiert(EinstellungsEvent event) {
                this.update(window, event);
            }

            private void update(final IWorkbenchWindow workbenchWndow, final EinstellungsEvent event) {
                UIJob job = new UIJob("Aktualisiere Men\u00fcs"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (!workbenchWndow.getWorkbench().isClosing()) {
                            if ("xmlStrukturMenuleiste".equals(event.getAdresse().getId())) {
                                RahmenwerkWorkbenchWindowAdvisor.this.ladeMenu(workbenchWndow);
                            } else if ("xmlStrukturSymbolleiste".equals(event.getAdresse().getId())) {
                                RahmenwerkWorkbenchWindowAdvisor.this.ladeToolbar(workbenchWndow);
                            } else if ("xmlStrukturStatusleiste".equals(event.getAdresse().getId())) {
                                RahmenwerkWorkbenchWindowAdvisor.this.ladeStatusLeiste(workbenchWndow);
                            }
                        }
                        return Status.OK_STATUS;
                    }

                    public boolean belongsTo(Object family) {
                        return "RahmenwerkJobs".equals(family) || super.belongsTo(family);
                    }
                };
                job.schedule();
            }
        });
    }

    private void ladeMenues(final IWorkbenchWindow window) {
        if (!window.getWorkbench().isClosing()) {
            UIJob job = new UIJob("Men\u00fcs laden"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (!window.getWorkbench().isClosing()) {
                        RahmenwerkWorkbenchWindowAdvisor.this.ladeMenu(window);
                        RahmenwerkWorkbenchWindowAdvisor.this.ladeToolbar(window);
                        RahmenwerkWorkbenchWindowAdvisor.this.ladeStatusLeiste(window);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }

    private void ladeStatusLeiste(IWorkbenchWindow window) {
        AbstractMenueLeiste statusLeiste = this.getLeiste("xmlStrukturStatusleiste", "-statusXmlDatei");
        IStatusLineManager statusLeisteManager = RahmenwerkImpl.getInstanz().getRwToolBarManager().getStatusLeisteManager();
        MenuGenerator menuGenerator = new MenuGenerator((IContributionManager)statusLeisteManager, statusLeiste);
        menuGenerator.generiereMenu((IServiceLocator)window);
    }

    private void ladeToolbar(IWorkbenchWindow window) {
        IToolBarManager toolBarManager = RahmenwerkImpl.getInstanz().getRwToolBarManager().getSymbolLeisteManagerToolbar();
        AbstractMenueLeiste symbolLeiste = this.getLeiste("xmlStrukturSymbolleiste", "-symbolXmlDatei");
        MenuGenerator menuGenerator = new MenuGenerator((IContributionManager)toolBarManager, symbolLeiste);
        menuGenerator.generiereMenu((IServiceLocator)window);
    }

    private void ladeMenu(IWorkbenchWindow window) {
        IMenuManager menuManager = RahmenwerkImpl.getInstanz().getRwToolBarManager().getMenuManager();
        AbstractMenueLeiste menuLeiste = this.getLeiste("xmlStrukturMenuleiste", "-menueXmlDatei");
        MenuGenerator menuGenerator = new MenuGenerator((IContributionManager)menuManager, menuLeiste);
        menuGenerator.generiereMenu((IServiceLocator)window);
    }

    private boolean getMenuFromXmlFile(AbstractMenueLeiste leiste, String argument) {
        String fileName;
        File menuFile;
        ArgumentList startParameter = RahmenwerkImpl.getInstanz().getStartParameter();
        if (startParameter.hasArgument(argument) && (menuFile = new File(fileName = startParameter.fetchArgument(argument).getValue())).exists() && menuFile.isFile()) {
            FileInputStream inputStream;
            Throwable throwable;
            block15: {
                throwable = null;
                Object var7_9 = null;
                inputStream = new FileInputStream(new File(fileName));
                new LeistenParser().parse(leiste, inputStream);
                if (inputStream == null) break block15;
                inputStream.close();
            }
            try {
                return true;
            }
            catch (Throwable throwable2) {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    try {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                    catch (IOException | ParserConfigurationException | SAXException e) {
                        LOGGER.error("Fehler beim Lesen der Menu-Datei: " + fileName, (Throwable)e);
                    }
                }
            }
        }
        return false;
    }

    private AbstractMenueLeiste getLeiste(String id, String fileArgument) {
        AbstractMenueLeiste leiste = null;
        switch (id) {
            case "xmlStrukturStatusleiste": {
                leiste = new StatusLeiste();
                break;
            }
            case "xmlStrukturSymbolleiste": {
                leiste = new SymbolLeiste();
                break;
            }
            case "xmlStrukturMenuleiste": {
                leiste = new MenueLeiste();
                break;
            }
            default: {
                throw new IllegalStateException("unbekannte Leisten-ID: " + id);
            }
        }
        Einstellungen einstellungen = InternalServices.getInstance().getEinstellungen();
        if (!this.getMenuFromXmlFile(leiste, fileArgument)) {
            String xmlStr = null;
            if (RahmenwerkImpl.getInstanz().isOnline()) {
                xmlStr = this.getParameterUserLokal(einstellungen, id);
                if (!(xmlStr != null && !xmlStr.trim().isEmpty() || (xmlStr = this.getParameterUserGlobal(einstellungen, id)) != null && !xmlStr.trim().isEmpty() || (xmlStr = this.getParameterSystemGlobal(einstellungen, id)) != null && !xmlStr.trim().isEmpty())) {
                    xmlStr = this.getParameterSystemLokal(einstellungen, id);
                }
            } else {
                xmlStr = this.getParameterSystemLokal(einstellungen, id);
            }
            if (xmlStr != null) {
                try {
                    new LeistenParser().parse(leiste, xmlStr);
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    LOGGER.warning(e.getLocalizedMessage());
                }
            }
        }
        return leiste;
    }

    private String getParameterSystemLokal(Einstellungen einstellungen, String id) {
        try {
            EinstellungsAdresse adresse = new EinstellungsAdresse(null, id, EinstellungOwnerType.SYSTEM, null, EinstellungLocation.LOKAL);
            return (String)einstellungen.getValue(adresse);
        }
        catch (IOException e) {
            LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    private String getParameterSystemGlobal(Einstellungen einstellungen, String id) {
        try {
            EinstellungsAdresse adresse = new EinstellungsAdresse(null, id, EinstellungOwnerType.SYSTEM, null, EinstellungLocation.NETZWERKWEIT);
            return (String)einstellungen.getValue(adresse);
        }
        catch (IOException e) {
            LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    private String getParameterUserLokal(Einstellungen einstellungen, String id) {
        try {
            EinstellungsAdresse adresse = new EinstellungsAdresse(null, id, EinstellungOwnerType.BENUTZER, RahmenwerkImpl.getInstanz().getBenutzer().getPid(), EinstellungLocation.LOKAL);
            return (String)einstellungen.getValue(adresse);
        }
        catch (IOException e) {
            LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    private String getParameterUserGlobal(Einstellungen einstellungen, String id) {
        try {
            EinstellungsAdresse adresse = new EinstellungsAdresse(null, id, EinstellungOwnerType.BENUTZER, RahmenwerkImpl.getInstanz().getBenutzer().getPid(), EinstellungLocation.NETZWERKWEIT);
            return (String)einstellungen.getValue(adresse);
        }
        catch (IOException e) {
            LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }
}

