/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.rw.rw.ui.internal;

import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsEvent;
import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsListener;
import de.bsvrz.buv.rw.basislib.util.RwInfoDef;
import de.bsvrz.buv.rw.rw.RahmenwerkActivator;
import de.bsvrz.buv.rw.rw.internal.RahmenwerkImpl;
import de.bsvrz.buv.rw.rw.preferences.RahmenwerkPreference;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;

public class WorkBenchWindowTitleProvider
implements IPropertyChangeListener {
    private final IWorkbenchWindowConfigurer configurer;

    public WorkBenchWindowTitleProvider(final IWorkbenchWindowConfigurer configurer) {
        this.configurer = configurer;
        RahmenwerkActivator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        RahmenwerkImpl.getInstanz().addDavVerbindungsListener(new DavVerbindungsListener(){

            public void verbindungHergestellt(DavVerbindungsEvent event) {
                WorkBenchWindowTitleProvider.this.setTitleInUI(configurer);
            }

            public boolean verbindungHalten(DavVerbindungsEvent event) {
                return false;
            }

            public void verbindungGetrennt(DavVerbindungsEvent event) {
                WorkBenchWindowTitleProvider.this.setTitleInUI(configurer);
            }
        });
    }

    public String getTitel() {
        String result = RahmenwerkImpl.getInstanz().isOnline() ? RwInfoDef.format((String)RahmenwerkActivator.getDefault().getPreferenceStore().getString(RahmenwerkPreference.ONLINE_TITLE_FORMAT.getId())) : RwInfoDef.format((String)RahmenwerkActivator.getDefault().getPreferenceStore().getString(RahmenwerkPreference.OFFLINE_TITLE_FORMAT.getId()));
        return result;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource().equals(RahmenwerkActivator.getDefault().getPreferenceStore())) {
            if (RahmenwerkPreference.ONLINE_TITLE_FORMAT.getId().equals(event.getProperty())) {
                if (RahmenwerkImpl.getInstanz().isOnline()) {
                    this.configurer.getWindow().getShell().setText(RwInfoDef.format((String)((String)event.getNewValue())));
                }
            } else if (RahmenwerkPreference.OFFLINE_TITLE_FORMAT.getId().equals(event.getProperty()) && !RahmenwerkImpl.getInstanz().isOnline()) {
                this.configurer.getWindow().getShell().setText(RwInfoDef.format((String)((String)event.getNewValue())));
            }
        }
    }

    private void setTitleInUI(final IWorkbenchWindowConfigurer windowConfigurer) {
        final IWorkbench workbench = windowConfigurer.getWindow().getWorkbench();
        if (workbench.isClosing()) {
            return;
        }
        final Display display = workbench.getDisplay();
        if (!workbench.isClosing() && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!workbench.isClosing() && !display.isDisposed()) {
                        windowConfigurer.getWindow().getShell().setText(WorkBenchWindowTitleProvider.this.getTitel());
                    }
                }
            });
        }
    }
}

