/*
 * Rahmenwerk-Plug-in Darstellungsobjekt "RDS-Symbole"
 * Copyright (C) 2009 BitCtrl Systems GmbH
 * Copyright (C) 2014 Regierungspräsidium Tübingen, Landesstelle für Straßentechnik, Thomas Bräuner
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 * 
 * Landesstelle für Straßentechnik
 * Heilbronner Straße 300 - 302
 * 70469 Stuttgart
 * Phone: +49 0711 8910-200
 * mailto: abteilung9@rpt.bwl.de
 */
package de.bsvrz.buv.plugin.netz.rdssymbole;

import org.osgi.framework.BundleContext;

import com.bitctrl.lib.eclipse.AbstractBitCtrlPlugin;

/**
 * Das Plug-in <em>RDS-Symbole</em>,
 * mit dem RDS-Meldungen in Abhängigkeit des Ereignisses
 * mit unterschiedlichen Symbolen dargestellt werden.
 * 
 * @author RPT, LST, 95-31, Thomas Bräuner
 * @version $Id$
 */
public class RDSSymbolePlugin extends AbstractBitCtrlPlugin {

	/** die ID des Plug-ins. */
	public static final String PLUGIN_ID = "de.bsvrz.buv.plugin.netz.rdssymbole";

	/** die globale Instanz des Plug-ins. */
	private static RDSSymbolePlugin instance;

	/**
	 * Gibt die gemeinsame Instanz des Plug-ins zurück.
	 * 
	 * @return die Instanz oder <code>null</code>, wenn das Plug-in nicht aktiv
	 *         ist.
	 */
	public static RDSSymbolePlugin getDefault() {
		return RDSSymbolePlugin.instance;
	}

	@Override
	public void start(final BundleContext context) throws Exception {
		super.start(context);
		RDSSymbolePlugin.instance = this;
	}

	@Override
	public void stop(final BundleContext context) throws Exception {
		RDSSymbolePlugin.instance = null;
		super.stop(context);
	}

}
