/*
 * Rahmenwerk-Plug-in Darstellungsobjekt "RDS-Symbole"
 * Copyright (C) 2009 BitCtrl Systems GmbH
 * Copyright (C) 2014 Regierungspräsidium Tübingen, Landesstelle für Straßentechnik, Thomas Bräuner
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 * 
 * Landesstelle für Straßentechnik
 * Heilbronner Straße 300 - 302
 * 70469 Stuttgart
 * Phone: +49 0711 8910-200
 * mailto: abteilung9@rpt.bwl.de
 */
package de.bsvrz.buv.plugin.netz.rdssymbole;

import org.eclipse.draw2d.geometry.PointList;

import de.bsvrz.buv.plugin.dobj.decorator.LinienabstandMediator;
import de.bsvrz.buv.plugin.dobj.editparts.BitCtrlDoModelEditPart;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.objekte.RdsMeldung;

/**
 * Basisklasse für MVC-Controller zur Darstellung einer <em>RDS-Meldung</em>.
 * 
 * @author BitCtrl Systems GmbH, Falko Schumann
 * @version $Id$
 */
abstract class RdsMeldungEditPart<F extends RdsMeldungFigure> extends
		BitCtrlDoModelEditPart<RdsMeldung, F> {

	private RdsMeldungEmpfaenger empfaenger;

	@Override
	protected void geheOnline() {
		super.geheOnline();

		if (getSystemObjekt() != null) {
			empfaenger = createRdsMeldungEmpfaenger();
			empfaenger.anmelden();
		}
	}

	protected abstract RdsMeldungEmpfaenger createRdsMeldungEmpfaenger();

	@Override
	protected void geheOffline() {
		if (empfaenger != null) {
			empfaenger.abmelden();
			empfaenger = null;
		}

		super.geheOffline();
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();

		refreshLocation();

		new LinienabstandMediator(this).mediate();
	}

	final void refreshLocation() {
		if (empfaenger != null) {
			getFigure().setStreckenabschnitt(empfaenger.getStreckenabschnitt());
		} else {
			getFigure().setStreckenabschnitt(new PointList());
		}
	}

}
