/*
 * Rahmenwerk-Plug-in Darstellungsobjekt "RDS-Symbole"
 * Copyright (C) 2009 BitCtrl Systems GmbH
 * Copyright (C) 2014 Regierungspräsidium Tübingen, Landesstelle für Straßentechnik, Thomas Bräuner
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 * 
 * Landesstelle für Straßentechnik
 * Heilbronner Straße 300 - 302
 * 70469 Stuttgart
 * Phone: +49 0711 8910-200
 * mailto: abteilung9@rpt.bwl.de
 */
package de.bsvrz.buv.plugin.netz.rdssymbole;

import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

import de.bsvrz.buv.plugin.dobj.decorator.AntikollisionsalgorithmusMediator;
import de.bsvrz.buv.plugin.dobj.legende.DoLegendeBaustein;
import de.bsvrz.buv.plugin.dobj.requests.DobjRequestConstants;
import de.bsvrz.buv.plugin.dobj.requests.VerbindungslinieRequest;
import de.bsvrz.buv.plugin.netz.SymbolFigure;
import de.bsvrz.buv.plugin.netz.model.RdsMeldungSymbolDoModel;
import de.bsvrz.buv.plugin.netz.model.RdsMeldungSymbolDoTyp;
import de.bsvrz.buv.rw.basislib.legende.ILegendeBaustein;

//import de.bsvrz.buv.rw.bitctrl.eclipse.legende.ILegendeBaustein;

/**
 * MVC-Controller zur Darstellung einer <em>RDS-Meldung</em> als Symbol.
 * 
 * @author BitCtrl Systems GmbH, thierfelder
 * @author BitCtrl Systems GmbH, Falko Schumann
 * @author Anpassungen: RPT, LST, 95-31, Thomas Bräuner
 * @version $Id: RdsMeldungSymbolEditPart.java 33323 2012-03-28 13:48:14Z
 *          schumann $
 */
@SuppressWarnings("restriction")
public class RdsMeldungSymbolEditPart extends
		RdsMeldungEditPart<RdsMeldungSymbolFigure> {

	private final ImageDescriptor imageDescriptor = RDSSymbolePlugin.getDefault()
			.getImageDescriptor("images/dot/rdsmeldung_blau.png");

	private DoLegendeBaustein legendeBaustein;
	
	// Ergänzung RDS-Symbole
	protected final ImageDescriptor getRdsMeldungSymbol() {
		return imageDescriptor;
	}
	// Ende Ergänzung
	
	@Override
	protected RdsMeldungSymbolFigure createFigure() {
		final Image image = getResourceManager().createImage(imageDescriptor);
		return new RdsMeldungSymbolFigure(getKollisionsManager(), image);
	}

	@Override
	protected RdsMeldungEmpfaenger createRdsMeldungEmpfaenger() {
		// Ergänzung RDS-Symbole
//		return new RdsMeldungSymbolEmpfaenger(this);
		return new RdsMeldungSymbolEmpfaenger(this, getFigure());
		// Ende Ergänzung
	}

	@Override
	public void notifyChanged(final Notification notification) {
		super.notifyChanged(notification);

		final Object notifier = notification.getNotifier();
		if (notifier instanceof RdsMeldungSymbolDoTyp
				|| notifier instanceof RdsMeldungSymbolDoModel) {
			refreshVisuals();
		}
	}

	@Override
	protected void createEditPolicies() {
		super.createEditPolicies();

		if (!isEditor()) {
			installEditPolicy(EditPolicy.SELECTION_FEEDBACK_ROLE,
					new RdsMeldungsPopUpEditPolicy());
		}
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();

		new AntikollisionsalgorithmusMediator(this).mediate();
	}

	@Override
	protected IFigure getToolTip() {
		if (isEditor()) {
			return super.getToolTip();
		}

		return null;
	}

	@Override
	public void performRequest(final Request req) {
		super.performRequest(req);

		if (DobjRequestConstants.REQ_VERBINDUNGSLINIE.equals(req.getType())) {
			final VerbindungslinieRequest vlr = (VerbindungslinieRequest) req;
			getFigure().setVerbindungslinieSichtbar(vlr.isVerbindungsLinie());
		}
	}

	@Override
	public Object getAdapter(@SuppressWarnings("rawtypes") final Class key) {
		if (ILegendeBaustein.class.equals(key)) {
			return getLegendeBaustein();
		}

		return super.getAdapter(key);
	}

	private ILegendeBaustein getLegendeBaustein() {
		disposeLegende();
		final SymbolFigure f = createFigure();
		f.setVerbindungslinieSichtbar(false);
		legendeBaustein = new DoLegendeBaustein(getModel().getDoTyp(), f,
				f.getSize());
		return legendeBaustein;
	}

	private void disposeLegende() {
		if (legendeBaustein != null) {
			legendeBaustein.dispose();
			legendeBaustein = null;
		}
	}

}
