/*
 * Rahmenwerk-Plug-in Darstellungsobjekt "RDS-Symbole"
 * Copyright (C) 2009 BitCtrl Systems GmbH
 * Copyright (C) 2014 Regierungspräsidium Tübingen, Landesstelle für Straßentechnik, Thomas Bräuner
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 * 
 * Landesstelle für Straßentechnik
 * Heilbronner Straße 300 - 302
 * 70469 Stuttgart
 * Phone: +49 0711 8910-200
 * mailto: abteilung9@rpt.bwl.de
 */
package de.bsvrz.buv.plugin.netz.rdssymbole;

import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Image;

import com.bitctrl.lib.eclipse.draw2d.FixedSizeFigure;

import de.bsvrz.buv.plugin.dobj.kollision.KollisionsManager;
import de.bsvrz.buv.plugin.netz.SymbolFigure;

/**
 * Figure zur Darstellung einer <em>RDS-Meldung</em> als Symbol.
 * 
 * @author BitCtrl Systems GmbH, thierfelder
 * @author BitCtrl Systems GmbH, Falko Schumann
 * @author Anpassungen: RPT, LST, 95-31, Thomas Bräuner
 */
@SuppressWarnings("restriction")
class RdsMeldungSymbolFigure extends SymbolFigure implements
		RdsMeldungFigure {

	// Ergänzung RDS-Symbole
	private FixedSizeFigure symbol;
	// Ende Ergänzung
	
	public RdsMeldungSymbolFigure(final KollisionsManager kollisionsManager,
			final Image image) {
		super(kollisionsManager, image);
	}

	// Ergänzung RDS-Symbole
	protected void setImage(Image image) {
		final Dimension imageSize = new Dimension(image);
		symbol = getSymbol();
		final ImageFigure imageFigure = new ImageFigure(image);
		imageFigure.setSize(imageSize);
		symbol.removeAll();
		symbol.add(imageFigure);
		add(symbol);
		updateBounds();
		updateFigure();
	}
	
	@Override
	protected void updateVisible() {
		setVisible(isZoomInSichtbareZoomStufe()
				&& getStreckenabschnitt() != null
				&& getStreckenabschnitt().size() > 0);
	}
	// Ende Ergänzung
}
