/*
 * Rahmenwerk-Plug-in Darstellungsobjekt "RDS-Symbole"
 * Copyright (C) 2009 BitCtrl Systems GmbH
 * Copyright (C) 2014 Regierungspräsidium Tübingen, Landesstelle für Straßentechnik, Thomas Bräuner
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 * 
 * Landesstelle für Straßentechnik
 * Heilbronner Straße 300 - 302
 * 70469 Stuttgart
 * Phone: +49 0711 8910-200
 * mailto: abteilung9@rpt.bwl.de
 */
package de.bsvrz.buv.plugin.netz.rdssymbole;

import org.eclipse.swt.graphics.Image;

/**
 * MVC-Controller zur Darstellung einer <em>RDS-Meldung</em> als Symbol mit Länge.
 * 
 * @author RPT, LST, 95-31, Thomas Bräuner
 */
public final class RdsMeldungSymbolMitLaengeEditPart extends
		RdsMeldungSymbolEditPart {

	@Override
	protected RdsMeldungSymbolMitLaengeFigure createFigure() {
		// Diese Zuweisung ist fehlerhaft, da die erzeugten Image nie freigegeben werden.
		// Durch das Speicherleck stürzt irgendwann das Rahmenwerk ab.
//		final Image image = getRdsMeldungSymbol().createImage();
		// Diese Zuweisung aus RdsMeldungSymbolEditPart ist korrekt...
//		final Image image = getResourceManager().createImage(imageDescriptor);
		// ... und muss wie folgt modifiziert werden.
		final Image image = getResourceManager().createImage(getRdsMeldungSymbol());
		return new RdsMeldungSymbolMitLaengeFigure(getKollisionsManager(), getResourceManager(), image);
	}

	@Override
	protected RdsMeldungEmpfaenger createRdsMeldungEmpfaenger() {
		return new RdsMeldungSymbolMitLaengeEmpfaenger(this, (RdsMeldungSymbolMitLaengeFigure) getFigure());
	}

}
