/*
 * Rahmenwerk-Plug-in Darstellungsobjekt "RDS-Symbole"
 * Copyright (C) 2009 BitCtrl Systems GmbH
 * Copyright (C) 2014 Regierungspräsidium Tübingen, Landesstelle für Straßentechnik, Thomas Bräuner
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 * 
 * Landesstelle für Straßentechnik
 * Heilbronner Straße 300 - 302
 * 70469 Stuttgart
 * Phone: +49 0711 8910-200
 * mailto: abteilung9@rpt.bwl.de
 */
package de.bsvrz.buv.plugin.netz.rdssymbole;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

import com.bitctrl.lib.eclipse.draw2d.FixedSizeFigure;

import de.bsvrz.buv.plugin.dobj.kollision.KollisionsManager;

/**
 * Figure zur Darstellung einer <em>RDS-Meldung</em> als Symbol mit Länge.
 * 
 * @author RPT, LST, 95-31, Thomas Bräuner
 */
//@SuppressWarnings("restriction")
class RdsMeldungSymbolMitLaengeFigure extends RdsMeldungSymbolFigure {

	private FixedSizeFigure symbol;
	private static final FontDescriptor STAULAENGE_FONT = FontDescriptor
			.createFrom("Arial", 8, SWT.NORMAL);
	private static final String STAULAENGE_UNBEKANNT = "----";

	private final Font staulaengeFont;
	private final Label staulaenge;
	private final Dimension dimMitLaenge;
	private final Dimension dimOhneLaenge;

	
	@SuppressWarnings("restriction")
	public RdsMeldungSymbolMitLaengeFigure(final KollisionsManager kollisionsManager,
			final ResourceManager resourceManager,
			final Image image) {
		super(kollisionsManager, image);
		
		staulaengeFont = resourceManager.createFont(STAULAENGE_FONT);
		
		staulaenge = new Label(STAULAENGE_UNBEKANNT);
		staulaenge.setOpaque(true);
		staulaenge.setBackgroundColor(ColorConstants.tooltipBackground);
		staulaenge.setFont(staulaengeFont);
		
//		final FixedSizeFigure symbol = getSymbol();
		symbol = getSymbol();
		final Dimension symbolSize = symbol.getDimension();
		final int fontHeight = staulaengeFont.getFontData()[0]
				.getHeight();
		final Dimension staulaengeSize = new Dimension(symbolSize.width,
				fontHeight + 4);
		staulaenge.setLocation(new Point(0, symbolSize.height));
		staulaenge.setSize(staulaengeSize);

		dimMitLaenge = new Dimension(symbolSize.width, symbolSize.height + staulaengeSize.height);
		dimOhneLaenge = new Dimension(symbolSize.width, symbolSize.height);
		symbol.add(staulaenge);
//		symbol.setDimension(new Dimension(symbolSize.width, symbolSize.height
//				+ staulaengeSize.height));
		symbol.setDimension(dimMitLaenge);

		updateFigure();
	}

	private void setStaulaenge(final long staulaengeInKm) {
		if (staulaengeInKm > 0) {
			staulaenge.setText(staulaengeInKm + " km");
		} else {
			staulaenge.setText(STAULAENGE_UNBEKANNT);
		}
	}
	
	@SuppressWarnings("restriction")
	protected void setImage(Image image, Long laenge) {
		final Dimension imageSize = new Dimension(image);
		symbol = getSymbol();
		symbol.removeAll();
		final ImageFigure imageFigure = new ImageFigure(image);
		imageFigure.setSize(imageSize);
		symbol.add(imageFigure);
		
		if (laenge != null)
			if (laenge > 0) {
				setStaulaenge(laenge);
				symbol.add(staulaenge);
				symbol.setDimension(dimMitLaenge);
			}
			else ;
		else
			symbol.setDimension(dimOhneLaenge);
		add(symbol);
		updateBounds();
		updateFigure();
	}
	
}
