/*
 * Rahmenwerk-Plug-in Darstellungsobjekt "RDS-Symbole"
 * Copyright (C) 2009 BitCtrl Systems GmbH
 * Copyright (C) 2014 Regierungspräsidium Tübingen, Landesstelle für Straßentechnik, Thomas Bräuner
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 * 
 * Landesstelle für Straßentechnik
 * Heilbronner Straße 300 - 302
 * 70469 Stuttgart
 * Phone: +49 0711 8910-200
 * mailto: abteilung9@rpt.bwl.de
 */
package de.bsvrz.buv.plugin.netz.rdssymbole.internal;

import de.bsvrz.buv.rw.basislib.Rahmenwerk;
import de.bsvrz.buv.rw.bitctrl.CacheService;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;

public class RahmenwerkService {

	private static RahmenwerkService service;

	private Rahmenwerk rahmenwerk;
	private ObjektFactory objektFactory;

	private CacheService cacheService;

	protected void activate() {
		service = this;
	}

	protected void deactivate() {
		service = null;
	}

	public static RahmenwerkService getService() {
		return service;
	}

	protected void bindRahmenwerk(final Rahmenwerk newRahmenwerk) {
		rahmenwerk = newRahmenwerk;
	}

	protected void unbindRahmenwerk(final Rahmenwerk oldRahmenwerk) {
		rahmenwerk = null;
	}

	public Rahmenwerk getRahmenwerk() {
		return rahmenwerk;
	}

	protected void bindObjektFactory(final ObjektFactory newObjektFactory) {
		objektFactory = newObjektFactory;
	}

	protected void unbindObjektFactory(final ObjektFactory oldObjektFactory) {
		objektFactory = null;
	}

	public ObjektFactory getObjektFactory() {
		return objektFactory;
	}

	protected void bindCacheService(final CacheService newCacheService) {
		cacheService = newCacheService;
	}

	protected void unbindCacheService(final CacheService newCacheService) {
		cacheService = null;
	}

	public CacheService getCacheService() {
		return cacheService;
	}

}
