/*
 * Rahmenwerk-Plug-in Darstellungsobjekt "RDS-Symbole"
 * Copyright (C) 2009 BitCtrl Systems GmbH
 * Copyright (C) 2014 Regierungspräsidium Tübingen, Landesstelle für Straßentechnik, Thomas Bräuner
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 * 
 * Landesstelle für Straßentechnik
 * Heilbronner Straße 300 - 302
 * 70469 Stuttgart
 * Phone: +49 0711 8910-200
 * mailto: abteilung9@rpt.bwl.de
 */
package de.bsvrz.buv.plugin.netz.rdssymbole.util;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

import de.bsvrz.buv.plugin.netz.rdssymbole.RDSSymbolePlugin;

/**
 * Stellt gemeinsam nutzbare Bilder zur Verfügung.
 * 
 * @author RP Tübingen, LST, T. Bräuner
 * @version $Id$
 */
public enum NetzIcons {

	/**
	 * Icon fuer Warnhinweis.
	 */
	Achtung_Icon("images/dot/achtung_blau.png"),

	/**
	 * Icon fuer Sperrung.
	 */
	Sperrung_Icon("images/dot/sperrung_blau.png"),

	/**
	 * Icon fuer Stau.
	 */
	Stau_Icon("images/dot/stau_blau.png"),

	/**
	 * Icon fuer RDS-Meldung allgemein.
	 */
	RDSMeldung_Icon("images/dot/rdsmeldung_blau.png"),

	/**
	 * Icon fuer Aufhebung.
	 */
	Aufhebung_Icon("images/dot/aufhebung_blau.png");

	/**
	 * Konstruktor.
	 * 
	 * @param imagePath
	 *            der Pfad zu den Images
	 */
	private NetzIcons(final String imagePath) {
		final ImageDescriptor imageDescriptor = RDSSymbolePlugin.getDefault()
				.getImageDescriptor(imagePath);
		if (imageDescriptor != null) {
			RDSSymbolePlugin.getDefault().getImageRegistry()
					.put(name(), imageDescriptor);
		} else {
			final String message = "Datei nicht gefunden: " + imagePath;
			RDSSymbolePlugin.getDefault().getLogger().error(message);
		}
	}

	/**
	 * Gibt den {@link ImageDescriptor} zurück.
	 * 
	 * @return den {@link ImageDescriptor}.
	 */
	public ImageDescriptor getImageDescriptor() {
		return RDSSymbolePlugin.getDefault().getImageRegistry()
				.getDescriptor(name());
	}

	/**
	 * Gibt ein gemeinsamnes {@link Image} zurück.
	 * 
	 * <p>
	 * 
	 * Das zurückgegebene Image darf <em>nicht</em> disposed werden.
	 * 
	 * @return ein gemeinsamnes {@link Image}.
	 */
	public Image getImage() {
		return RDSSymbolePlugin.getDefault().getImageRegistry().get(name());
	}

}
