/*
 * Rahmenwerk-Plug-in Darstellungsobjekt "RDS-Symbole"
 * Copyright (C) 2009 BitCtrl Systems GmbH
 * Copyright (C) 2014 Regierungspräsidium Tübingen, Landesstelle für Straßentechnik, Thomas Bräuner
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 * 
 * Landesstelle für Straßentechnik
 * Heilbronner Straße 300 - 302
 * 70469 Stuttgart
 * Phone: +49 0711 8910-200
 * mailto: abteilung9@rpt.bwl.de
 */
package de.bsvrz.buv.plugin.netz.rdssymbole.util;

/**
 * Definitionen für die Klassifizierung der RDS-meldungen.
 * 
 * @author BitCtrl Systems GmbH, Uwe Peuker
 * @version $Id$
 */
public enum RdsCode {
	/** RDS-Meldung repräsentiert einen Stau. */
	STAU(1),

	/** RDS-Meldung repräsentiert eine Sperrung. */
	SPERRUNG(2),

	/** RDS-Meldung repräsentiert eine Warnung. */
	ACHTUNG(3),

	/** RDS-Meldung repräsentiert eine allgemeine Meldung. */
	RDSMELDUNG(4),

	/** RDS-Meldung repräsentiert eine Meldungsaufhebung. */
	AUFHEBUNG(5),

	/** RDS-Meldung repräsentiert den Standardwert mit höchster Wertigkeit. */
	DEFAULT(6);

	/**
	 * Code des RdsCodes, zur internen Verwendung und zur Verwendung in der
	 * definierenden Excel-Tabelle.
	 */
	private Integer code;

	/**
	 * Konstruktor.
	 * 
	 * @param code
	 *            der Zahlencode der Instanz
	 */
	private RdsCode(final int code) {
		this.code = code;
	}

	/**
	 * liefert das ENUM, das dem übergebenen Zahlencode entspricht. Wenn kein
	 * entsprechendes gefunden wurde, wird der Standardwert {@link #DEFAULT}
	 * geliefert.
	 * 
	 * @param code
	 *            der Zahlencode, für den eine Entsprechung gesucht wird
	 * @return der passende {@link RdsCode}
	 */
	public static final RdsCode getCode(final int code) {
		RdsCode result = DEFAULT;
		for (RdsCode lookup : values()) {
			if (lookup.code == code) {
				result = lookup;
				break;
			}
		}

		return result;
	}
}
