/*
 * Rahmenwerk-Plug-in Darstellungsobjekt "RDS-Symbole"
 * Copyright (C) 2009 BitCtrl Systems GmbH
 * Copyright (C) 2014 Regierungspräsidium Tübingen, Landesstelle für Straßentechnik, Thomas Bräuner
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 * 
 * Landesstelle für Straßentechnik
 * Heilbronner Straße 300 - 302
 * 70469 Stuttgart
 * Phone: +49 0711 8910-200
 * mailto: abteilung9@rpt.bwl.de
 */
package de.bsvrz.buv.plugin.netz.rdssymbole.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.graphics.Image;

import de.bsvrz.buv.plugin.netz.rdssymbole.RDSSymbolePlugin;

/**
 * Klasse zum EInlesen einer speziellen Excel-Tabelle, die die Zuordnungen von
 * RDS-Codes zu den hier verwendeten RDS-Meldungklassen definiert.
 * 
 * @author RP Tübingen, LST, T. Bräuner
 * @version $Id$
 */
public class TabelleEinleser {

	/** die Zuordnung von RDS-Code zur RDS-Meldungsklassen. */
	private final Map<Integer, RdsCode> zuordnung = new HashMap<Integer, RdsCode>(
			1400);

	/**
	 * liefert die Liste der Zuordnung von Codes zu RDS-Meldungsklassen.
	 * 
	 * @return die Zuordnungen
	 */
	public final Map<Integer, RdsCode> getZuordnung() {
		return zuordnung;
	}

	/** Konstruktor. */
	public TabelleEinleser() {
		// FileInputStream fin = null;
		try {
			// System.out.println("Pfad URL: " +
			// RDSSymbolePlugin.getDefault().getBundle().getEntry("res/Event_Codes_fuer_VRZ.xls").getPath());
			// URL tabres =
			// FileLocator.resolve(RDSSymbolePlugin.getDefault().getBundle().getEntry("res/Event_Codes_fuer_VRZ.xls"));
			// System.out.println("Pfad: " + tabres.getPath());
			// fin = new FileInputStream(tabres.getPath());
			final InputStream inst = FileLocator.openStream(RDSSymbolePlugin
					.getDefault().getBundle(), new Path(
					"res/Event_Codes_fuer_VRZ.xls"), false);
			// File datei = new File(tabres.getPath());
			// Workbook wb = Workbook.getWorkbook(datei);
			final Workbook wb = Workbook.getWorkbook(inst);
			final Sheet blatt = wb.getSheet("Eventcode");
			final int anzZeilen = blatt.getRows();
			int code = 0;
			int symbol = 0;
			// System.out.println("Anzahl Zeilen: " + anzZeilen);
			for (int lauf = 1; lauf < anzZeilen; lauf++) {
				code = Integer.parseInt(blatt.getCell(1, lauf).getContents());
				symbol = Integer.parseInt(blatt.getCell(2, lauf).getContents());
				zuordnung.put(code, RdsCode.getCode(symbol));
				// System.out.println(lauf + ". Zeile: " + code + " => " +
				// symbol);
			}
			// fin.close();
		} catch (final IOException e) {
			System.out.println("Tabelle mit Event-Codes nicht gefunden.");
			e.printStackTrace();
		} catch (final BiffException e) {
			System.out.println("Probleme in Excel-Bibliothek.");
			e.printStackTrace();
		}
	}

	/**
	 * liefert das dem Code zugeordnete Image.
	 * 
	 * @param code
	 *            der Code
	 * @return das Image
	 */
	public Image getImageByRdsCode(final RdsCode code) {
		switch (code) {
		case STAU:
			return NetzIcons.Stau_Icon.getImage();
		case SPERRUNG:
			return NetzIcons.Sperrung_Icon.getImage();
		case ACHTUNG:
			return NetzIcons.Achtung_Icon.getImage();
		case RDSMELDUNG:
			return NetzIcons.RDSMeldung_Icon.getImage();
		case AUFHEBUNG:
			return NetzIcons.Aufhebung_Icon.getImage();
		default:
			return NetzIcons.RDSMeldung_Icon.getImage();
		}
	}
}
