/*
 * Rahmenwerk-Plug-in "Benutzerverwaltung/Zugriffsrechte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.benutzervew;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

import de.bsvrz.buv.plugin.benutzervew.views.BenutzerListe;
import de.bsvrz.buv.plugin.benutzervew.views.BenutzerNavigator;
import de.bsvrz.buv.plugin.benutzervew.views.RegionenView;
import de.bsvrz.buv.plugin.benutzervew.views.RollenView;

/**
 * Perspektive des Benutzerverwaltung/Zugriffsrechte-Plugins.
 *
 * @author BitCtrl Systems GmbH, Steffen Gieseler
 *
 *
 */
public class BenutzerVewPerspective implements IPerspectiveFactory {

	@Override
	public void createInitialLayout(final IPageLayout layout) {

		IFolderLayout folder = layout.createFolder("left", IPageLayout.LEFT, 0.4f, layout.getEditorArea()); //$NON-NLS-1$
		folder.addView(BenutzerNavigator.VIEW_ID);
		layout.addShowViewShortcut(BenutzerNavigator.VIEW_ID);
		folder = layout.createFolder("buttom", IPageLayout.BOTTOM, 0.4f, layout.getEditorArea()); //$NON-NLS-1$
		folder.addView(BenutzerListe.VIEW_ID);
		folder.addView(RollenView.ID);
		folder.addView(RegionenView.ID);
		layout.addShowViewShortcut(BenutzerListe.VIEW_ID);
		layout.addShowViewShortcut(RollenView.ID);
		layout.addShowViewShortcut(RegionenView.ID);
	}
}
