/*
 * Rahmenwerk-Plug-in "Benutzerverwaltung/Zugriffsrechte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.benutzervew;

import de.bsvrz.buv.plugin.benutzervew.internal.RahmenwerkService;
import de.bsvrz.buv.rw.basislib.berechtigung.Berechtigungen;
import de.bsvrz.buv.rw.basislib.berechtigung.FunktionMitBerechtigung;

/**
 * Die Definition der Funktionen, f&uuml;r die Berechtigungen innerhalb des
 * Rahmenwerkes festgelegt werden k&ouml;nnen.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker, Steffen Gieseler
 */
public enum BenutzerVewPluginFunktion {

	/** Aktion Perspektive &ouml;ffnen. */
	BENUTZERVEW_PERSPEKTIVE_OEFFNEN("BenutzerVewPluginFunktion.PerspektiveOeffnenBenutzerverwaltung"),

	/** Aktion Ansicht 'Benutzer und Berechtigungsklassen' &ouml;ffnen. */
	BENUTZERVEW_NAVIGATOR_OEFFNEN("BenutzerVewPluginFunktion.AnsichtOeffnenBenutzerUndBerechtigungsklassen"),

	/** Aktion Ansicht 'Benutzerliste' &ouml;ffnen. */
	BENUTZERVEW_LISTE_OEFFNEN("BenutzerVewPluginFunktion.AnsichtOeffnenBenutzerliste"),

	/** Aktion zum Anlegen eines Benutzers. */
	BENUTZER_ANLEGEN("BenutzerVewPluginFunktion.benutzerAnlegen"),

	/** Aktion zum L&ouml;schen eines Benutzers. */
	BENUTZER_LOESCHEN("BenutzerVewPluginFunktion.benutzerLoeschen"),

	/** Aktion zum &Auml;ndern des Passwortes eines Benutzers. */
	BENUTZER_PASSWORT_AENDERN("BenutzerVewPluginFunktion.benutzerPasswortAendern"),

	/** Aktion zum &Auml;ndern der Berechtigungen eines Benutzers. */
	BENUTZER_BEARBEITEN("BenutzerVewPluginFunktion.benutzerRechteBearbeiten"),

	/** Aktion zum L&ouml;schen der Einmalpassworte eines Benutzers. */
	BENUTZER_PASSWORTE_LOESCHEN("BenutzerVewPluginFunktion.benutzerPassworteLoeschen"),

	/** Aktion zum L&ouml;schen der Einmalpassworte eines Benutzers. */
	BENUTZER_EINMALPASSWORTE_ANZEIGEN("BenutzerVewPluginFunktion.benutzerFreieEinmalPassworteAnzeigen"),

	/** Aktion zum Bearbeiten einer Berechtigungsklasse. */
	BERECHTIGUNGSKLASSE_BEARBEITEN("BenutzerVewPluginFunktion.berechtigungsklasseBearbeiten");

	/** die ID mit der Funktion registriert wird. */
	private String id;

	/**
	 * Konstruktor, erzeugt eine Funktionsdefinition mit der gegebenen ID.
	 *
	 * Die ID wird über den Extension-Point um die Plugin-ID erweitert (Präfix),
	 * deshalb wird diese hier ergänzt.
	 *
	 * @param id die ID
	 */
	private BenutzerVewPluginFunktion(final String id) {
		this.id = PluginBenutzerVew.PLUGIN_ID + "." + id;
	}

	/**
	 * liefert die Id der Funktion.
	 *
	 * @return die Id
	 */
	public String getId() {
		return id;
	}

	/**
	 * liefert die Funktion aus der Berechtigungsverwaltung.
	 *
	 * @return die Funktion oder <code>null</code>, wenn keine solche existiert
	 */
	public FunktionMitBerechtigung getFunktionMitBerechtigung() {
		return RahmenwerkService.getService().getBerechtigungen().getFunktion(id);
	}

	/**
	 * liefert den Freigabestatus der Funktion für den angemeldeten Nutzer.
	 *
	 * @return den Status
	 */
	public boolean isFreigegeben() {
		final Berechtigungen berechtigungen = RahmenwerkService.getService().getBerechtigungen();
		return berechtigungen.hasBerechtigung(berechtigungen.getFunktion(id));
	}
}
