/*
 * Rahmenwerk-Plug-in "Benutzerverwaltung/Zugriffsrechte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.benutzervew;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

import com.bitctrl.lib.eclipse.AbstractBitCtrlPlugin;

import de.bsvrz.sys.funclib.debug.Debug;

/**
 * Der Eclipse-Framework-Aktivator für das Plugin
 * "Benutzerverwaltung/Zugriffsrechte".
 *
 * @author BitCtrl Systems GmbH, Steffen Gieseler
 *
 */
public class PluginBenutzerVew extends AbstractBitCtrlPlugin {

	public static final String ICONS_ROLLE_GIF = "icons/rolle.gif";
	public static final String ICONS_REGION_GIF = "icons/region.gif";

	private static final Debug LOGGER = Debug.getLogger();

	/** Die ID des Plugins. */
	public static final String PLUGIN_ID = "de.bsvrz.buv.plugin.benutzervew";

	/** Die globale Instanz des Plugins. */
	private static PluginBenutzerVew plugin;

	/** Das Ressource bundle. */
	private ResourceBundle resourceBundle;

	/**
	 * The constructor.
	 */
	public PluginBenutzerVew() {
		super();
		try {
			resourceBundle = ResourceBundle.getBundle("de.bsvrz.buv.plugin.benutzervew.PluginBenutzerVewResources"); //$NON-NLS-1$
		} catch (final MissingResourceException e) {
			LOGGER.warning(e.getLocalizedMessage());
		}
	}

	@Override
	public void start(final BundleContext context) throws Exception {
		super.start(context);
		plugin = this;

	}

	@Override
	public void stop(final BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	/**
	 * liefert die globale Instanz.
	 *
	 * @return die Instanz
	 */
	public static PluginBenutzerVew getDefault() {
		return plugin;
	}

	/**
	 * liefert einen Imagedescriptor für den übergebenen Dateipfad.
	 *
	 * @param path der Pfad.
	 * @return der Descriptor.
	 */
	@Override
	public ImageDescriptor getImageDescriptor(final String path) {
		return AbstractUIPlugin.imageDescriptorFromPlugin(PluginBenutzerVew.PLUGIN_ID, path);
	}

	/**
	 * ermittelt des Bundle mit den Plugin-Ressourcen.
	 *
	 * @return das Resource-Bundle.
	 */
	public ResourceBundle getResourceBundle() {
		return resourceBundle;
	}

	@Override
	protected void initializeImageRegistry(final ImageRegistry reg) {
		super.initializeImageRegistry(reg);

		reg.put(ICONS_ROLLE_GIF, getImageDescriptor(ICONS_ROLLE_GIF));
		reg.put(ICONS_REGION_GIF, getImageDescriptor(ICONS_REGION_GIF));
	}

}
