/*
 * Rahmenwerk-Plug-in "Benutzerverwaltung/Zugriffsrechte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.benutzervew.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Event;

import com.bitctrl.lib.eclipse.resources.CommonIcons;

/**
 * Aktion Aktualisierung des Views. <br>
 * Die Datenverteiler-API stellt z. Zt. keine Listener-Funktionalit&auml;t
 * f&uuml;r eine &Auml;nderung der Benutzer im System bereit. &Uuml;ber diese
 * Aktion kann eine Aktualisierung der Daten erzwungen werden.
 *
 * @author BitCtrl Systems GmbH, Steffen Gieseler
 *
 */
public class ViewAktualisierenAktion extends Action {

	private final Viewer viewer;

	/**
	 * Konstruktor.
	 *
	 * @param viewer der View
	 */
	public ViewAktualisierenAktion(final Viewer viewer) {
		super("Ansicht aktualisieren");
		setToolTipText("Aktualisiert die Ansicht");
		setImageDescriptor(
				CommonIcons.getImageRegistry().getDescriptor(CommonIcons.ExtraSmall_Actions_View_Refresh.toString()));
		this.viewer = viewer;
	}

	@Override
	public void runWithEvent(final Event event) {
		if (viewer != null) {
			viewer.refresh();
		}
	}
}
