/*
 * Rahmenwerk-Plug-in "Benutzerverwaltung/Zugriffsrechte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.benutzervew.data;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;

import de.bsvrz.dav.daf.main.config.SystemObject;

public class AngemeldeteApplikation extends SystemObjectWrapper {

	private String benutzerPid;
	private LocalDateTime anmeldeZeit = LocalDateTime.MIN;

	public AngemeldeteApplikation(final SystemObject systemObject) {
		super(systemObject);
	}

	public LocalDateTime getAnmeldeZeit() {
		return anmeldeZeit;
	}

	public String getUserPid() {
		if (benutzerPid == null) {
			return "";
		}
		return benutzerPid;
	}

	public void setBenutzerPid(final String pid) {
		benutzerPid = pid;
	}

	public void setAnmeldeZeit(final long millis) {
		anmeldeZeit = new Date(millis).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
	}
}
