/*
 * Rahmenwerk-Plug-in "Benutzerverwaltung/Zugriffsrechte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.benutzervew.data;

import java.util.EventListener;

/**
 * Listener für das Anlegen, Löschen und Ändern eines Benutzers.
 *
 * @author BitCtrl Systems GmbH, Schumann
 */
public interface BenutzerListener extends EventListener {

	/**
	 * Wird aufgerufen, wenn ein neuer Benutzer angelegt wurde.
	 *
	 * @param e das entsprechende Event.
	 */
	void benutzerAdded(Benutzer benutzer);

	/**
	 * Wird aufgerufen, wenn ein neuer Benutzer angelegt wurde.
	 *
	 * @param e das entsprechende Event.
	 */
	void benutzerRemoved(Benutzer benutzer);

	/**
	 * Wird aufgerufen, wenn die Berechtigungsklasse eines Benutzers geändert wurde.
	 *
	 * @param e das entsprechende Event.
	 */
	void benutzerChanged(Benutzer benutzer);
}
