/*
 * Rahmenwerk-Plug-in "Benutzerverwaltung/Zugriffsrechte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.benutzervew.data;

import java.util.ArrayList;
import java.util.Collection;

import de.bsvrz.buv.plugin.benutzervew.internal.RahmenwerkService;
import de.bsvrz.buv.rw.basislib.Rahmenwerk;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.Data.Array;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.ReceiveOptions;
import de.bsvrz.dav.daf.main.ReceiverRole;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.puk.param.lib.daten.UrlasserInfo;

public class BerechtigungsKlasse extends SystemObjectWrapper {

	private static final String ATG_ROLLEN_REGIONEN_PARAMETER = "atg.rollenRegionenPaareParameter";
	private static final String ATG_ROLLEN_REGIONEN = "atg.rollenRegionenPaare";

	private final DataDescription rollenRegionenDesc;
	private final DataDescription rollenRegionenDescVorgabe;

	private final Collection<RolleRegionPaar> rolleRegionPaare = new ArrayList<>();

	public BerechtigungsKlasse(final SystemObject systemObject) {
		super(systemObject);

		final ClientDavInterface dav = RahmenwerkService.getService().getRahmenWerk().getDavVerbindung();
		final DataModel dataModel = systemObject.getDataModel();

		if (RahmenwerkService.getService().getRahmenWerk().usesBerechtigungenNeu()) {
			rollenRegionenDesc = new DataDescription(dataModel.getAttributeGroup(ATG_ROLLEN_REGIONEN),
					getAspectParameterSoll());
			rollenRegionenDescVorgabe = new DataDescription(dataModel.getAttributeGroup(ATG_ROLLEN_REGIONEN),
					getAspectParameterVorgabe());
		} else {
			rollenRegionenDesc = new DataDescription(dataModel.getAttributeGroup(ATG_ROLLEN_REGIONEN_PARAMETER),
					getAspectParameterSoll());
			rollenRegionenDescVorgabe = new DataDescription(dataModel.getAttributeGroup(ATG_ROLLEN_REGIONEN_PARAMETER),
					getAspectParameterVorgabe());
		}
		updateRolleRegionPaare(dav.getData(systemObject, rollenRegionenDesc, 0));
		dav.subscribeReceiver((results) -> updateRolleRegionPaare(results), systemObject, rollenRegionenDesc,
				ReceiveOptions.normal(), ReceiverRole.receiver());
	}

	private void updateRolleRegionPaare(ResultData... results) {
		for (final ResultData result : results) {
			rolleRegionPaare.clear();
			if (result.hasData()) {
				if (ATG_ROLLEN_REGIONEN_PARAMETER.equals(result.getDataDescription().getAttributeGroup().getPid())) {
					final Array array = result.getData().getArray("rollenRegionenPaare");
					for (int idx = 0; idx < array.getLength(); idx++) {
						final Rolle rolle = RahmenwerkService.getService().getBenutzerverwaltung()
								.getRolle(array.getItem(idx).getReferenceValue("rolle").getSystemObjectPid());
						final Region region = RahmenwerkService.getService().getBenutzerverwaltung()
								.getRegion(array.getItem(idx).getReferenceValue("region").getSystemObjectPid());
						if ((rolle != null) && (region != null)) {
							rolleRegionPaare.add(new RolleRegionPaar(rolle, region));
						}
					}
				} else if (ATG_ROLLEN_REGIONEN.equals(result.getDataDescription().getAttributeGroup().getPid())) {
					final Array array = result.getData().getArray("RollenRegionenPaare");
					for (int idx = 0; idx < array.getLength(); idx++) {
						final Rolle rolle = RahmenwerkService.getService().getBenutzerverwaltung()
								.getRolle(array.getItem(idx).getReferenceValue("Rolle").getSystemObjectPid());
						final Region region = RahmenwerkService.getService().getBenutzerverwaltung()
								.getRegion(array.getItem(idx).getReferenceValue("Region").getSystemObjectPid());
						if ((rolle != null) && (region != null)) {
							rolleRegionPaare.add(new RolleRegionPaar(rolle, region));
						}
					}
				}
			}
		}
	}

	public Collection<RolleRegionPaar> getRolleRegionenPaare() {
		return new ArrayList<>(rolleRegionPaare);
	}

	public void sendeRolleRegionenPaare(Collection<RolleRegionPaar> collection, UrlasserInfo urlasser) {

		final Rahmenwerk rahmenWerk = RahmenwerkService.getService().getRahmenWerk();
		if (!rahmenWerk.isOnline()) {
			return;
		}

		final ClientDavInterface dav = rahmenWerk.getDavVerbindung();
		final AttributeGroup atg = rollenRegionenDesc.getAttributeGroup();
		final Data data = dav.createData(atg);

		if (ATG_ROLLEN_REGIONEN_PARAMETER.equals(atg.getPid())) {
			final Array array = data.getArray("rollenRegionenPaare");
			array.setLength(collection.size());
			int idx = 0;
			for (final RolleRegionPaar paar : collection) {
				array.getItem(idx).getReferenceValue("rolle").setSystemObject(paar.getRolle().getSystemObject());
				array.getItem(idx).getReferenceValue("region").setSystemObject(paar.getRegion().getSystemObject());
				idx++;
			}
		} else if (ATG_ROLLEN_REGIONEN.equals(atg.getPid())) {
			final Array array = data.getArray("RollenRegionenPaare");
			array.setLength(collection.size());
			int idx = 0;
			for (final RolleRegionPaar paar : collection) {
				array.getItem(idx).getReferenceValue("Rolle").setSystemObject(paar.getRolle().getSystemObject());
				array.getItem(idx).getReferenceValue("Region").setSystemObject(paar.getRegion().getSystemObject());
				idx++;
			}
		}

		if (urlasser != null) {
			final Data urlasserItem = data.getItem("Urlasser");
			urlasserItem.getReferenceValue("BenutzerReferenz").setSystemObject(urlasser.getBenutzer());
			urlasserItem.getTextValue("Ursache").setText(urlasser.getUrsache());
			urlasserItem.getTextValue("Veranlasser").setText(urlasser.getVeranlasser());
		}

		RahmenwerkService.getService().getBenutzerverwaltung().getSender()
				.sende(new ResultData(getSystemObject(), rollenRegionenDescVorgabe, 0, data));
	}
}
