/*
 * Rahmenwerk-Plug-in "Benutzerverwaltung/Zugriffsrechte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.benutzervew.data;

/**
 * Diese Ausnahme zeigt an, dass ein Benutzer nicht die notwendigen Rechte für
 * die angeforderte Aktion besitzt.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 */
public class KeineRechteException extends Exception {

	/**
	 * Konstruktor ohne Meldungstext und vorangegangende Fehler.
	 */
	public KeineRechteException() {
		// nix zu tun
	}

	/**
	 * Konstruktor mit Meldungstext.
	 *
	 * @param message der Meldungstext.
	 */
	public KeineRechteException(final String message) {
		super(message);
	}

	/**
	 * Konstruktor mit vorangegangende Fehler.
	 *
	 * @param cause der vorangegangende Fehler.
	 */
	public KeineRechteException(final Throwable cause) {
		super(cause);
	}

	/**
	 * Konstruktor mit Meldungstext und vorangegangende Fehler.
	 *
	 * @param message der Meldungstext.
	 * @param cause   der vorangegangende Fehler.
	 */
	public KeineRechteException(final String message, final Throwable cause) {
		super(message, cause);
	}

}
