/*
 * Rahmenwerk-Plug-in "Benutzerverwaltung/Zugriffsrechte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.benutzervew.data;

import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.ConfigurationObject;
import de.bsvrz.dav.daf.main.config.SystemObject;

public class SystemObjectWrapper {

	private String kurzInfo;

	private final SystemObject systemObject;

	private final Aspect aspectParameterSoll;
	private final Aspect aspectParameterVorgabe;

	public SystemObjectWrapper(final SystemObject systemObject) {
		this.systemObject = systemObject;

		if (systemObject instanceof ConfigurationObject) {
			final AttributeGroup infoAtg = systemObject.getDataModel().getAttributeGroup("atg.info");
			final Data data = ((ConfigurationObject) systemObject).getConfigurationData(infoAtg);
			if (data != null) {
				kurzInfo = data.getTextValue("kurzinfo").getText();
			}
		}

		aspectParameterSoll = systemObject.getDataModel().getAspect("asp.parameterSoll");
		aspectParameterVorgabe = systemObject.getDataModel().getAspect("asp.parameterVorgabe");
	}

	public SystemObject getSystemObject() {
		return systemObject;
	}

	public String getName() {
		return systemObject.getNameOrPidOrId();
	}

	public String getPid() {
		return systemObject.getPid();
	}

	public String getKurzInfo() {
		if (kurzInfo == null) {
			return "";
		}
		return kurzInfo;
	}

	protected Aspect getAspectParameterSoll() {
		return aspectParameterSoll;
	}

	protected Aspect getAspectParameterVorgabe() {
		return aspectParameterVorgabe;
	}

	@Override
	public String toString() {
		return systemObject.getNameOrPidOrId();
	}
}
