/*
 * Rahmenwerk-Plug-in "Benutzerverwaltung/Zugriffsrechte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.benutzervew.editor;

import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.plugin.AbstractUIPlugin;

import de.bsvrz.buv.plugin.benutzervew.PluginBenutzerVew;
import de.bsvrz.buv.plugin.benutzervew.internal.RahmenwerkService;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.att.Feld;
import de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.MengenTyp;

public class MengenTypWizardPage extends WizardPage {

	private final Collection<MengenTyp> verwendeteMengenTypen = new TreeSet<>();
	private ListViewer listVerfuegbareMengenTypen;
	private ListViewer listVerwendeteMengenTypen;

	public MengenTypWizardPage() {
		super(MengenTypWizardPage.class.getName());
		setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin(PluginBenutzerVew.PLUGIN_ID,
				"icons/mengen_typen_wizard_page.gif"));
		setTitle("Auswahl der Mengen-Typen");
		setDescription(
				"Mengen-Typen, die hier betrachtet werden sollen. Wenn das Array leer ist, sind alle Mengen-Typen gemeint.");
	}

	@Override
	public void createControl(Composite parent) {
		final Composite container = new Composite(parent, SWT.NONE);

		setControl(container);
		container.setLayout(new GridLayout(3, false));

		final Group groupVerfuegbareBK = new Group(container, SWT.NONE);
		groupVerfuegbareBK.setText("Verfügbare Mengen-Typen");
		groupVerfuegbareBK.setLayout(new FillLayout());
		groupVerfuegbareBK
				.setLayoutData(GridDataFactory.fillDefaults().grab(true, true).span(1, 1).hint(300, 400).create());

		listVerfuegbareMengenTypen = new ListViewer(groupVerfuegbareBK,
				SWT.BORDER | SWT.V_SCROLL | SWT.H_SCROLL | SWT.MULTI);
		listVerfuegbareMengenTypen.setContentProvider(new ArrayContentProvider());
		listVerfuegbareMengenTypen.setFilters(new ViewerFilter() {

			@Override
			public boolean select(Viewer viewer, Object parentElement, Object element) {
				return !verwendeteMengenTypen.contains(element);
			}
		});

		final ObjektFactory objektFactory = RahmenwerkService.getService().getObjektFactory();
		listVerfuegbareMengenTypen.setInput(objektFactory.bestimmeModellobjekte(MengenTyp.PID));

		final Composite buttonComposite = new Composite(container, SWT.NONE);
		buttonComposite.setLayout(new GridLayout(1, false));
		buttonComposite.setLayoutData(GridDataFactory.fillDefaults().align(SWT.FILL, SWT.CENTER).grab(false, true)
				.hint(100, SWT.DEFAULT).create());

		final Button btnEinfuegen = new Button(buttonComposite, SWT.NONE);
		btnEinfuegen.setLayoutData(new GridData(SWT.FILL, SWT.BOTTOM, true, true, 1, 1));
		btnEinfuegen.setText(">>");
		btnEinfuegen.addSelectionListener(new SelectionAdapter() {

			@SuppressWarnings("unchecked")
			@Override
			public void widgetSelected(SelectionEvent e) {
				final IStructuredSelection selection = (IStructuredSelection) listVerfuegbareMengenTypen.getSelection();
				verwendeteMengenTypen.addAll(selection.toList());
				listVerfuegbareMengenTypen.refresh();
				listVerwendeteMengenTypen.refresh();
			}

		});

		final Button btnEntfernen = new Button(buttonComposite, SWT.NONE);
		btnEntfernen.setLayoutData(GridDataFactory.fillDefaults().align(SWT.FILL, SWT.CENTER).grab(true, true)
				.hint(100, SWT.DEFAULT).create());
		btnEntfernen.setText("<<");
		btnEntfernen.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				final IStructuredSelection selection = (IStructuredSelection) listVerwendeteMengenTypen.getSelection();
				verwendeteMengenTypen.removeAll(selection.toList());
				listVerfuegbareMengenTypen.refresh();
				listVerwendeteMengenTypen.refresh();
			}

		});

		final Group groupVerwendeteKB = new Group(container, SWT.NONE);
		groupVerwendeteKB.setText("Verwendete Mengen-Typen");
		groupVerwendeteKB.setLayout(new FillLayout());
		groupVerwendeteKB
				.setLayoutData(GridDataFactory.fillDefaults().grab(true, true).span(1, 1).hint(300, 400).create());

		listVerwendeteMengenTypen = new ListViewer(groupVerwendeteKB,
				SWT.BORDER | SWT.V_SCROLL | SWT.H_SCROLL | SWT.MULTI);
		listVerwendeteMengenTypen.setContentProvider(new ArrayContentProvider());
		listVerwendeteMengenTypen.setInput(verwendeteMengenTypen);

	}

	public void setVerwendeteMengenTypen(Feld<MengenTyp> mengenTypen) {
		verwendeteMengenTypen.addAll(mengenTypen);
	}

	public Collection<MengenTyp> getVerwendeteMengenTypen() {
		return Collections.unmodifiableCollection(verwendeteMengenTypen);
	}
}
